/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.json.stream.JsonGenerator;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import sting.processor.Binding;
import sting.processor.IncludeDescriptor;

final class FragmentDescriptor {
    @Nonnull
    private final TypeElement _element;
    @Nonnull
    private final Collection<IncludeDescriptor> _includes;
    @Nonnull
    private final Collection<Binding> _bindings;
    private boolean _javaStubGenerated;
    private boolean _containsError;

    FragmentDescriptor(@Nonnull TypeElement element, @Nonnull Collection<IncludeDescriptor> includes, @Nonnull Collection<Binding> bindings) {
        assert (ElementKind.INTERFACE == element.getKind());
        this._element = Objects.requireNonNull(element);
        this._includes = Objects.requireNonNull(includes);
        this._bindings = Objects.requireNonNull(bindings);
        this._bindings.forEach(b -> b.setOwner(this));
    }

    @Nonnull
    String getQualifiedTypeName() {
        return this._element.getQualifiedName().toString();
    }

    @Nonnull
    TypeElement getElement() {
        return this._element;
    }

    @Nonnull
    Collection<IncludeDescriptor> getIncludes() {
        return this._includes;
    }

    @Nonnull
    Collection<Binding> getBindings() {
        return this._bindings;
    }

    boolean isJavaStubGenerated() {
        return this._javaStubGenerated;
    }

    void markJavaStubAsGenerated() {
        this._javaStubGenerated = true;
    }

    boolean containsError() {
        return this._containsError;
    }

    void markAsContainsError() {
        this._containsError = true;
    }

    void write(@Nonnull JsonGenerator g) {
        g.writeStartObject();
        g.write("schema", "fragment/1");
        if (!this._includes.isEmpty()) {
            g.writeStartArray("includes");
            for (IncludeDescriptor include : this._includes) {
                g.write(include.getIncludedType().toString());
            }
            g.writeEnd();
        }
        if (!this._bindings.isEmpty()) {
            g.writeStartArray("bindings");
            for (Binding binding : this._bindings) {
                g.writeStartObject();
                binding.write(g);
                g.writeEnd();
            }
            g.writeEnd();
        }
        g.writeEnd();
    }
}

