/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import sting.processor.Binding;
import sting.processor.CircularDependencyChecker;
import sting.processor.ComponentGraph;
import sting.processor.Coordinate;
import sting.processor.DescriptorIO;
import sting.processor.Edge;
import sting.processor.FragmentDescriptor;
import sting.processor.FragmentGenerator;
import sting.processor.IncludeDescriptor;
import sting.processor.InjectableDescriptor;
import sting.processor.InjectableGenerator;
import sting.processor.InjectorDescriptor;
import sting.processor.InjectorGenerator;
import sting.processor.InjectorProviderGenerator;
import sting.processor.InputDescriptor;
import sting.processor.Node;
import sting.processor.PathEntry;
import sting.processor.ProviderEntry;
import sting.processor.Registry;
import sting.processor.ServiceDescriptor;
import sting.processor.ServiceSpec;
import sting.processor.WorkEntry;
import sting.processor.vendor.proton.AbstractStandardProcessor;
import sting.processor.vendor.proton.AnnotationsUtil;
import sting.processor.vendor.proton.DeferredElementSet;
import sting.processor.vendor.proton.ElementsUtil;
import sting.processor.vendor.proton.GeneratorUtil;
import sting.processor.vendor.proton.IOUtil;
import sting.processor.vendor.proton.JsonUtil;
import sting.processor.vendor.proton.MemberChecks;
import sting.processor.vendor.proton.ProcessorException;
import sting.processor.vendor.proton.TypesUtil;

@SupportedAnnotationTypes(value={"sting.Injector", "sting.Injectable", "sting.Fragment", "sting.Eager", "sting.Typed", "sting.Named"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"sting.defer.unresolved", "sting.defer.errors", "sting.debug", "sting.emit_json_descriptors", "sting.verbose_out_of_round.errors", "sting.verify_descriptors"})
public final class StingProcessor
extends AbstractStandardProcessor {
    static final String JSON_SUFFIX = ".sting.json";
    static final String SUFFIX = ".sbf";
    static final String GRAPH_SUFFIX = "__ObjectGraph.sting.json";
    @Nonnull
    private final Registry _registry = new Registry();
    @Nonnull
    private final DeferredElementSet _deferredInjectableTypes = new DeferredElementSet();
    @Nonnull
    private final DeferredElementSet _deferredFragmentTypes = new DeferredElementSet();
    @Nonnull
    private final DeferredElementSet _deferredInjectorTypes = new DeferredElementSet();
    private boolean _emitJsonDescriptors;
    private boolean _verifyDescriptors;
    private DescriptorIO _descriptorIO;

    @Override
    @Nonnull
    protected String getIssueTrackerURL() {
        return "https://github.com/sting-ioc/sting/issues";
    }

    @Override
    @Nonnull
    protected String getOptionPrefix() {
        return "sting";
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this._descriptorIO = new DescriptorIO(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
        this._emitJsonDescriptors = this.readBooleanOption("emit_json_descriptors", false);
        this._verifyDescriptors = this.readBooleanOption("verify_descriptors", false);
    }

    @Override
    public boolean process(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env) {
        this.processTypeElements(annotations, env, "sting.Injectable", this._deferredInjectableTypes, this::processInjectable);
        this.processTypeElements(annotations, env, "sting.Fragment", this._deferredFragmentTypes, this::processFragment);
        annotations.stream().filter(a -> a.getQualifiedName().toString().equals("sting.Named")).findAny().ifPresent(a -> this.verifyNamedElements(env, env.getElementsAnnotatedWith((TypeElement)a)));
        annotations.stream().filter(a -> a.getQualifiedName().toString().equals("sting.Typed")).findAny().ifPresent(a -> this.verifyTypedElements(env, env.getElementsAnnotatedWith((TypeElement)a)));
        annotations.stream().filter(a -> a.getQualifiedName().toString().equals("sting.Eager")).findAny().ifPresent(a -> this.verifyEagerElements(env, env.getElementsAnnotatedWith((TypeElement)a)));
        this.processTypeElements(annotations, env, "sting.Injector", this._deferredInjectorTypes, this::processInjector);
        this.processResolvedInjectables(env);
        this.processResolvedFragments(env);
        this.processResolvedInjectors(env);
        this.errorIfProcessingOverAndInvalidTypesDetected(env);
        this.errorIfProcessingOverAndUnprocessedInjectorDetected(env);
        if (env.processingOver() || env.errorRaised()) {
            this._registry.clear();
        }
        return true;
    }

    private void errorIfProcessingOverAndUnprocessedInjectorDetected(@Nonnull RoundEnvironment env) {
        List<InjectorDescriptor> injectors;
        if (env.processingOver() && !env.errorRaised() && !(injectors = this._registry.getInjectors()).isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getSimpleName() + " failed to process " + injectors.size() + " injectors as not all of their dependencies could be resolved. The java code resolved but the descriptors were missing or in the incorrect format. Ensure that the included typed have been compiled with a compatible version of Sting and that the .sbf descriptors have been packaged with the .class files.");
            for (InjectorDescriptor injector : injectors) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to process the " + injector.getElement().getQualifiedName() + " injector.");
            }
        }
    }

    private void processResolvedInjectables(@Nonnull RoundEnvironment env) {
        for (InjectableDescriptor injectable : new ArrayList<InjectableDescriptor>(this._registry.getInjectables())) {
            this.performAction(env, e -> {
                if (!injectable.isJavaStubGenerated()) {
                    injectable.markJavaStubAsGenerated();
                    this.writeBinaryDescriptor(injectable.getElement(), injectable);
                    this.emitInjectableJsonDescriptor(injectable);
                    this.emitInjectableStub(injectable);
                }
            }, injectable.getElement());
        }
    }

    private void emitInjectableStub(@Nonnull InjectableDescriptor injectable) throws IOException {
        String packageName = GeneratorUtil.getQualifiedPackageName(injectable.getElement());
        this.emitTypeSpec(packageName, InjectableGenerator.buildType(this.processingEnv, injectable));
    }

    private void processResolvedFragments(@Nonnull RoundEnvironment env) {
        for (FragmentDescriptor fragment : new ArrayList<FragmentDescriptor>(this._registry.getFragments())) {
            this.performAction(env, e -> {
                if (!fragment.isJavaStubGenerated() && !fragment.containsError() && this.isFragmentResolved(env, fragment)) {
                    fragment.markJavaStubAsGenerated();
                    this.writeBinaryDescriptor(fragment.getElement(), fragment);
                    this.emitFragmentJsonDescriptor(fragment);
                    this.emitFragmentStub(fragment);
                }
            }, fragment.getElement());
        }
    }

    private void emitFragmentStub(@Nonnull FragmentDescriptor fragment) throws IOException {
        String packageName = GeneratorUtil.getQualifiedPackageName(fragment.getElement());
        this.emitTypeSpec(packageName, FragmentGenerator.buildType(this.processingEnv, fragment));
    }

    private void processResolvedInjectors(@Nonnull RoundEnvironment env) {
        for (InjectorDescriptor injector : new ArrayList<InjectorDescriptor>(this._registry.getInjectors())) {
            this.performAction(env, e -> {
                if (!injector.containsError() && this.isInjectorResolved(env, injector)) {
                    this._registry.deregisterInjector(injector);
                    this.buildAndEmitObjectGraph(injector);
                }
            }, injector.getElement());
        }
    }

    private void buildAndEmitObjectGraph(@Nonnull InjectorDescriptor injector) throws Exception {
        ComponentGraph graph = new ComponentGraph(injector);
        this.registerIncludesComponents(graph);
        this.registerInputs(graph);
        this.buildObjectGraphNodes(graph);
        if (graph.getNodes().isEmpty() && graph.getRootNode().getDependsOn().isEmpty()) {
            throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector") + " target produced an empty object graph. This means that there are no eager nodes in the includes and there are no dependencies or only unsatisfied optional dependencies defined by the injector", graph.getInjector().getElement());
        }
        this.propagateEagerFlagUpstream(graph);
        CircularDependencyChecker.verifyNoCircularDependencyLoops(graph);
        this.emitObjectGraphJsonDescriptor(graph);
        String packageName = GeneratorUtil.getQualifiedPackageName(graph.getInjector().getElement());
        this.emitTypeSpec(packageName, InjectorGenerator.buildType(this.processingEnv, graph));
        this.emitTypeSpec(packageName, InjectorProviderGenerator.buildType(this.processingEnv, graph));
    }

    private void registerInputs(@Nonnull ComponentGraph graph) {
        for (InputDescriptor input : graph.getInjector().getInputs()) {
            graph.registerInput(input);
        }
    }

    private void propagateEagerFlagUpstream(@Nonnull ComponentGraph graph) {
        graph.getNodes().stream().filter(n -> n.getBinding().isEager()).forEach(Node::markNodeAndUpstreamAsEager);
    }

    private void registerIncludesComponents(@Nonnull ComponentGraph graph) {
        this.registerIncludes(graph, graph.getInjector().getIncludes());
    }

    private void registerIncludes(@Nonnull ComponentGraph graph, @Nonnull Collection<IncludeDescriptor> includes) {
        for (IncludeDescriptor include : includes) {
            String classname = include.getActualTypeName();
            TypeElement element = this.processingEnv.getElementUtils().getTypeElement(classname);
            assert (null != element);
            if (AnnotationsUtil.hasAnnotationOfType(element, "sting.Fragment")) {
                FragmentDescriptor fragment = this._registry.getFragmentByClassName(element.getQualifiedName().toString());
                this.registerIncludes(graph, fragment.getIncludes());
                graph.registerFragment(fragment);
                continue;
            }
            assert (AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable"));
            graph.registerInjectable(this._registry.getInjectableByClassName(element.getQualifiedName().toString()));
        }
    }

    private void buildObjectGraphNodes(@Nonnull ComponentGraph graph) {
        HashSet<Node> completed = new HashSet<Node>();
        Stack<WorkEntry> workList = new Stack<WorkEntry>();
        ArrayList<Node> eagerNodes = new ArrayList<Node>(graph.getRawNodeCollection());
        Node rootNode = graph.getRootNode();
        rootNode.setDepth(0);
        this.addDependsOnToWorkList(workList, rootNode, null);
        this.processWorkList(graph, completed, workList);
        for (Node node : eagerNodes) {
            if (!node.isDepthNotSet()) continue;
            node.setDepth(0);
            this.addDependsOnToWorkList(workList, node, null);
            this.processWorkList(graph, completed, workList);
        }
        graph.complete();
    }

    private void processWorkList(@Nonnull ComponentGraph graph, @Nonnull Set<Node> completed, @Nonnull Stack<WorkEntry> workList) {
        InjectorDescriptor injector = graph.getInjector();
        while (!workList.isEmpty()) {
            String message;
            Node node;
            WorkEntry workEntry = workList.pop();
            Edge edge = workEntry.getEntry().getEdge();
            assert (null != edge);
            ServiceDescriptor service = edge.getService();
            Coordinate coordinate = service.getService().getCoordinate();
            ArrayList<Binding> bindings = new ArrayList<Binding>(graph.findAllBindingsByCoordinate(coordinate));
            if (bindings.isEmpty()) {
                TypeElement typeElement;
                byte[] data;
                String classname = coordinate.getType().toString();
                InjectableDescriptor injectable = this._registry.findInjectableByClassName(classname);
                if (null != injectable && injectable.getBinding().getPublishedServices().stream().anyMatch(s -> coordinate.equals(s.getCoordinate()))) {
                    bindings.add(injectable.getBinding());
                }
                if (bindings.isEmpty() && null != (data = this.tryLoadDescriptorData(typeElement = this.processingEnv.getElementUtils().getTypeElement(classname)))) {
                    try {
                        InjectableDescriptor injectableDescriptor;
                        Object descriptor = this.loadDescriptor(classname, data);
                        if (descriptor instanceof InjectableDescriptor && (injectableDescriptor = (InjectableDescriptor)descriptor).getBinding().getPublishedServices().stream().anyMatch(s -> coordinate.equals(s.getCoordinate()))) {
                            this._registry.registerInjectable(injectableDescriptor);
                            bindings.add(injectableDescriptor.getBinding());
                        }
                    }
                    catch (IOException e) {
                        Object owner;
                        node = edge.getNode();
                        Object object = owner = node.hasNoBinding() ? null : node.getBinding().getOwner();
                        TypeElement ownerElement = owner instanceof FragmentDescriptor ? ((FragmentDescriptor)owner).getElement() : (owner instanceof InjectableDescriptor ? ((InjectableDescriptor)owner).getElement() : injector.getElement());
                        throw new ProcessorException("Failed to read the Sting descriptor for type " + classname + ". Error: " + e, ownerElement);
                    }
                }
            }
            List<Binding> nullableProviders = bindings.stream().filter(b -> b.getPublishedServices().stream().anyMatch(ServiceSpec::isOptional)).collect(Collectors.toList());
            if (!service.getService().isOptional() && !nullableProviders.isEmpty()) {
                message = MemberChecks.mustNot("sting.Injector", "contain an optional provider method or optional injector input and a non-optional service request for the coordinate " + coordinate + "\nDependency Path:\n" + workEntry.describePathFromRoot() + "\nBinding" + (nullableProviders.size() > 1 ? "s" : "") + ":\n" + this.bindingsToString(nullableProviders));
                throw new ProcessorException(message, service.getElement());
            }
            if (bindings.isEmpty()) {
                if (service.getService().isOptional() || service.getKind().isCollection()) {
                    edge.setSatisfiedBy(Collections.emptyList());
                    continue;
                }
                message = MemberChecks.mustNot("sting.Injector", "contain a non-optional dependency " + coordinate + " that can not be satisfied.\nDependency Path:\n" + workEntry.describePathFromRoot());
                throw new ProcessorException(message, service.getElement());
            }
            ServiceDescriptor.Kind kind = service.getKind();
            if (1 == bindings.size() || kind.isCollection()) {
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (Binding binding : bindings) {
                    node = graph.findOrCreateNode(binding);
                    nodes.add(node);
                    if (completed.contains(node)) continue;
                    completed.add(node);
                    this.addDependsOnToWorkList(workList, node, workEntry);
                }
                edge.setSatisfiedBy(nodes);
                continue;
            }
            assert (bindings.size() > 1 && !kind.isCollection());
            String message2 = MemberChecks.mustNot("sting.Injector", "contain a non-collection dependency " + coordinate + " that can be satisfied by multiple nodes.\nDependency Path:\n" + workEntry.describePathFromRoot() + "\nCandidate Nodes:\n" + this.bindingsToString(bindings));
            throw new ProcessorException(message2, service.getElement());
        }
    }

    @Nonnull
    private String bindingsToString(@Nonnull List<Binding> bindings) {
        return bindings.stream().map(b -> "  " + b.getTypeLabel() + "    " + b.describe()).collect(Collectors.joining("\n"));
    }

    private void addDependsOnToWorkList(@Nonnull Stack<WorkEntry> workList, @Nonnull Node node, @Nullable WorkEntry parent) {
        for (Edge e : node.getDependsOn()) {
            Stack<PathEntry> stack = new Stack<PathEntry>();
            if (null != parent) {
                stack.addAll(parent.getStack());
            }
            PathEntry entry = new PathEntry(node, e);
            stack.add(entry);
            workList.add(new WorkEntry(entry, stack));
        }
    }

    private void emitObjectGraphJsonDescriptor(@Nonnull ComponentGraph graph) throws IOException {
        if (this._emitJsonDescriptors) {
            TypeElement element = graph.getInjector().getElement();
            String filename = this.toFilename(element) + GRAPH_SUFFIX;
            JsonUtil.writeJsonResource(this.processingEnv, element, filename, graph::write);
        }
    }

    private boolean isFragmentResolved(@Nonnull RoundEnvironment env, @Nonnull FragmentDescriptor fragment) {
        return this.isResolved(env, fragment, fragment.getElement(), fragment.getIncludes());
    }

    private boolean isInjectorResolved(@Nonnull RoundEnvironment env, @Nonnull InjectorDescriptor injector) {
        return this.isResolved(env, injector, injector.getElement(), injector.getIncludes());
    }

    private boolean isResolved(@Nonnull RoundEnvironment env, @Nonnull Object descriptor, @Nonnull TypeElement originator, @Nonnull Collection<IncludeDescriptor> includes) {
        for (IncludeDescriptor include : includes) {
            String annotationClassname;
            AnnotationMirror annotation;
            String classname = include.getActualTypeName();
            TypeElement element = this.processingEnv.getElementUtils().getTypeElement(classname);
            if (null == element) {
                assert (include.isProvider());
                if (env.processingOver()) {
                    annotation = AnnotationsUtil.findAnnotationByType(originator, "sting.Injector");
                    String string = annotationClassname = null != annotation ? "sting.Injector" : "sting.Fragment";
                    if (null == annotation) {
                        annotation = AnnotationsUtil.getAnnotationByType(originator, "sting.Fragment");
                    }
                    if (descriptor instanceof FragmentDescriptor) {
                        ((FragmentDescriptor)descriptor).markAsContainsError();
                    } else {
                        ((InjectorDescriptor)descriptor).markAsContainsError();
                    }
                    String message = MemberChecks.toSimpleName(annotationClassname) + " target has an parameter named 'includes' containing the value " + include.getIncludedType() + " and that type is annotated by the @StingProvider annotation. The provider annotation expects a provider class named " + include.getActualTypeName() + " but no such class exists. The type need to be removed from the includes or the provider class needs to be present.";
                    this.reportError(env, message, originator, annotation, null);
                }
                return false;
            }
            if (include.isProvider() && !AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable") && !AnnotationsUtil.hasAnnotationOfType(element, "sting.Fragment")) {
                annotation = AnnotationsUtil.findAnnotationByType(originator, "sting.Injector");
                String string = annotationClassname = null != annotation ? "sting.Injector" : "sting.Fragment";
                if (null == annotation) {
                    annotation = AnnotationsUtil.getAnnotationByType(originator, "sting.Fragment");
                }
                if (descriptor instanceof FragmentDescriptor) {
                    ((FragmentDescriptor)descriptor).markAsContainsError();
                } else {
                    ((InjectorDescriptor)descriptor).markAsContainsError();
                }
                String message = MemberChecks.toSimpleName(annotationClassname) + " target has an parameter named 'includes' containing the value " + include.getIncludedType() + " and that type is annotated by the @StingProvider annotation. The provider annotation expects a provider class named " + include.getActualTypeName() + " but that class is not annotated with either " + MemberChecks.toSimpleName("sting.Injector") + " or " + MemberChecks.toSimpleName("sting.Fragment");
                throw new ProcessorException(message, originator, annotation);
            }
            if (null != this._registry.findFragmentByClassName(classname) || null != this._registry.findInjectableByClassName(classname)) continue;
            byte[] data = this.tryLoadDescriptorData(element);
            if (null == data) {
                return false;
            }
            try {
                Object loadedDescriptor = this.loadDescriptor(classname, data);
                if (loadedDescriptor instanceof FragmentDescriptor) {
                    this._registry.registerFragment((FragmentDescriptor)loadedDescriptor);
                    continue;
                }
                this._registry.registerInjectable((InjectableDescriptor)loadedDescriptor);
            }
            catch (IOException e) {
                throw new ProcessorException("Failed to read the Sting descriptor for include: " + classname + ". Error: " + e, originator);
            }
        }
        return true;
    }

    private void processInjector(@Nonnull TypeElement element) throws Exception {
        this.debug(() -> "Processing Injector: " + element);
        ElementKind kind = element.getKind();
        if (ElementKind.INTERFACE != kind) {
            throw new ProcessorException(MemberChecks.must("sting.Injector", "be an interface"), element);
        }
        if (!element.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "have type parameters"), element);
        }
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(element);
        if (!scopedAnnotations.isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "be annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations), element);
        }
        List<IncludeDescriptor> includes = this.extractIncludes(element, "sting.Injector");
        List<InputDescriptor> inputs = this.extractInputs(element);
        ArrayList<ServiceDescriptor> outputs = new ArrayList<ServiceDescriptor>();
        List<ExecutableElement> methods = ElementsUtil.getMethods(element, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        for (ExecutableElement executableElement : methods) {
            if (!executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            this.processInjectorOutputMethod(outputs, executableElement);
        }
        for (Element element2 : element.getEnclosedElements()) {
            DeclaredType type;
            if (ElementKind.INTERFACE == element2.getKind() && AnnotationsUtil.hasAnnotationOfType(element2, "sting.Fragment")) {
                type = (DeclaredType)element2.asType();
                if (!includes.stream().noneMatch(d -> Objects.equals(d.getIncludedType(), type))) continue;
                includes.add(new IncludeDescriptor(type, type.toString()));
                continue;
            }
            if (ElementKind.CLASS != element2.getKind() || !AnnotationsUtil.hasAnnotationOfType(element2, "sting.Injectable")) continue;
            type = (DeclaredType)element2.asType();
            if (!includes.stream().noneMatch(d -> Objects.equals(d.getIncludedType(), type))) continue;
            includes.add(new IncludeDescriptor(type, type.toString()));
        }
        InjectorDescriptor injector = new InjectorDescriptor(element, includes, inputs, outputs);
        this._registry.registerInjector(injector);
        this.emitInjectorJsonDescriptor(injector);
    }

    private void emitInjectorJsonDescriptor(@Nonnull InjectorDescriptor injector) throws IOException {
        if (this._emitJsonDescriptors) {
            TypeElement element = injector.getElement();
            String filename = this.toFilename(element) + JSON_SUFFIX;
            JsonUtil.writeJsonResource(this.processingEnv, element, filename, injector::write);
        }
    }

    private void processInjectorOutputMethod(@Nonnull List<ServiceDescriptor> outputs, @Nonnull ExecutableElement method) {
        assert (method.getModifiers().contains((Object)Modifier.ABSTRACT));
        if (TypeKind.VOID == method.getReturnType().getKind()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that has a void return value"), method);
        }
        if (!method.getParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that has parameters"), method);
        }
        if (!method.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that has any type parameters"), method);
        }
        if (!method.getThrownTypes().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that throws any exceptions"), method);
        }
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(method);
        if (!scopedAnnotations.isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that is annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations), method);
        }
        outputs.add(this.processOutputMethod(method));
    }

    @Nonnull
    private ServiceDescriptor processOutputMethod(@Nonnull ExecutableElement method) {
        TypeMirror type = method.getReturnType();
        if (TypesUtil.containsArrayType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method with a return type that contains an array type"), method);
        }
        if (TypesUtil.containsWildcard(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method with a return type that contains a wildcard type parameter"), method);
        }
        if (TypesUtil.containsRawType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method with a return type that contains a raw type"), method);
        }
        TypeMirror dependencyType = null;
        ServiceDescriptor.Kind kind = null;
        for (ServiceDescriptor.Kind candidate : ServiceDescriptor.Kind.values()) {
            dependencyType = candidate.extractType(type);
            if (null == dependencyType) continue;
            kind = candidate;
            break;
        }
        if (null == kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method with a return type that contains an unexpected parameterized type. Only parameterized types known to the framework are supported"), method);
        }
        boolean optional = AnnotationsUtil.hasNullableAnnotation(method);
        if (optional && ServiceDescriptor.Kind.INSTANCE != kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method annotated with " + MemberChecks.toSimpleName("javax.annotation.Nullable") + " that is not an instance dependency kind"), method);
        }
        String qualifier = this.getQualifier(method);
        if (AnnotationsUtil.hasAnnotationOfType(method, "javax.inject.Named")) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead"), method);
        }
        Coordinate coordinate = new Coordinate(qualifier, dependencyType);
        ServiceSpec service = new ServiceSpec(coordinate, optional);
        return new ServiceDescriptor(kind, service, method, -1);
    }

    private void verifyNamedElements(@Nonnull RoundEnvironment env, @Nonnull Set<? extends Element> elements) {
        for (Element element : elements) {
            if (ElementKind.PARAMETER == element.getKind()) {
                boolean isProvider;
                Element executableElement = element.getEnclosingElement();
                boolean injectableType = AnnotationsUtil.hasAnnotationOfType(executableElement.getEnclosingElement(), "sting.Injectable");
                boolean isFragmentType = !injectableType && AnnotationsUtil.hasAnnotationOfType(executableElement.getEnclosingElement(), "sting.Fragment");
                ElementKind executableKind = executableElement.getKind();
                boolean bl = isProvider = !injectableType && !isFragmentType && this.hasStingProvider(executableElement.getEnclosingElement());
                if (!injectableType && ElementKind.CONSTRUCTOR == executableKind && !isProvider) {
                    this.reportError(env, MemberChecks.must("sting.Named", "only be present on a constructor parameter if the constructor is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Injectable") + " or the type has an associated provider"), element);
                    continue;
                }
                if (!isFragmentType && ElementKind.METHOD == executableKind) {
                    this.reportError(env, MemberChecks.must("sting.Named", "only be present on a method parameter if the method is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Fragment")), element);
                    continue;
                }
                assert (injectableType && ElementKind.CONSTRUCTOR == executableKind || isProvider && ElementKind.CONSTRUCTOR == executableKind || isFragmentType && ElementKind.METHOD == executableKind);
                continue;
            }
            if (ElementKind.CLASS == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable") || this.hasStingProvider(element)) continue;
                this.reportError(env, MemberChecks.must("sting.Named", "only be present on a type if the type is annotated with " + MemberChecks.toSimpleName("sting.Injectable") + " or the type has an associated provider"), element);
                continue;
            }
            if (ElementKind.METHOD == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Fragment") || AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Injector")) continue;
                this.reportError(env, MemberChecks.mustNot("sting.Named", "be a method unless the method is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Fragment") + " or " + MemberChecks.toSimpleName("sting.Injector")), element);
                continue;
            }
            this.reportError(env, MemberChecks.toSimpleName("sting.Named") + " target is not valid", element);
        }
    }

    private boolean hasStingProvider(@Nonnull Element element) {
        return element.getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().asElement().getAnnotationMirrors().stream().anyMatch(ca -> ca.getAnnotationType().asElement().getSimpleName().contentEquals("StingProvider")));
    }

    private void verifyTypedElements(@Nonnull RoundEnvironment env, @Nonnull Set<? extends Element> elements) {
        for (Element element : elements) {
            if (ElementKind.CLASS == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable") || this.hasStingProvider(element)) continue;
                this.reportError(env, MemberChecks.must("sting.Typed", "only be present on a type if the type is annotated with " + MemberChecks.toSimpleName("sting.Injectable") + " or the type has an associated provider"), element);
                continue;
            }
            if (ElementKind.METHOD == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Fragment") || AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Injector")) continue;
                this.reportError(env, MemberChecks.mustNot("sting.Typed", "be a method unless the method is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Fragment") + " or " + MemberChecks.toSimpleName("sting.Injector")), element);
                continue;
            }
            this.reportError(env, MemberChecks.toSimpleName("sting.Typed") + " target is not valid", element);
        }
    }

    private void verifyEagerElements(@Nonnull RoundEnvironment env, @Nonnull Set<? extends Element> elements) {
        for (Element element : elements) {
            if (ElementKind.CLASS == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable") || this.hasStingProvider(element)) continue;
                this.reportError(env, MemberChecks.must("sting.Eager", "only be present on a type if the type is annotated with " + MemberChecks.toSimpleName("sting.Injectable") + " or the type has an associated provider"), element);
                continue;
            }
            if (ElementKind.METHOD == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Fragment")) continue;
                this.reportError(env, MemberChecks.must("sting.Eager", "only be present on a method if the method is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Fragment")), element);
                continue;
            }
            this.reportError(env, MemberChecks.toSimpleName("sting.Eager") + " target is not valid", element);
        }
    }

    private void processFragment(@Nonnull TypeElement element) {
        this.debug(() -> "Processing Fragment: " + element);
        if (ElementKind.INTERFACE != element.getKind()) {
            throw new ProcessorException(MemberChecks.must("sting.Fragment", "be an interface"), element);
        }
        if (!element.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "have type parameters"), element);
        }
        if (!element.getInterfaces().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "extend any interfaces"), element);
        }
        List<IncludeDescriptor> includes = this.extractIncludes(element, "sting.Fragment");
        LinkedHashMap<ExecutableElement, Binding> bindings = new LinkedHashMap<ExecutableElement, Binding>();
        List<ExecutableElement> methods = ElementsUtil.getMethods(element, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        for (ExecutableElement method : methods) {
            this.processProvidesMethod(element, bindings, method);
        }
        if (bindings.isEmpty() && includes.isEmpty()) {
            throw new ProcessorException(MemberChecks.must("sting.Fragment", "contain one or more methods or one or more includes"), element);
        }
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(element);
        if (!scopedAnnotations.isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "be annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations), element);
        }
        this._registry.registerFragment(new FragmentDescriptor(element, includes, bindings.values()));
    }

    @Nonnull
    private List<InputDescriptor> extractInputs(@Nonnull TypeElement element) {
        ArrayList<InputDescriptor> results = new ArrayList<InputDescriptor>();
        AnnotationMirror annotation = AnnotationsUtil.getAnnotationByType(element, "sting.Injector");
        AnnotationValue inputsAnnotationValue = AnnotationsUtil.findAnnotationValue(annotation, "inputs");
        assert (null != inputsAnnotationValue);
        List inputs = (List)inputsAnnotationValue.getValue();
        int size = inputs.size();
        for (int i = 0; i < size; ++i) {
            AnnotationMirror input = (AnnotationMirror)inputs.get(i);
            String qualifier = (String)AnnotationsUtil.getAnnotationValueValue(input, "qualifier");
            AnnotationValue typeAnnotationValue = AnnotationsUtil.getAnnotationValue(input, "type");
            TypeMirror type = (TypeMirror)typeAnnotationValue.getValue();
            if (TypeKind.ARRAY == type.getKind()) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector.Input") + " must not specify an array type for the type parameter", element, input, typeAnnotationValue);
            }
            if (TypeKind.VOID == type.getKind()) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector.Input") + " must specify a non-void type for the type parameter", element, input, typeAnnotationValue);
            }
            if (TypeKind.DECLARED == type.getKind() && !((TypeElement)((DeclaredType)type).asElement()).getTypeParameters().isEmpty()) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector.Input") + " must not specify a parameterized type for the type parameter", element, input, typeAnnotationValue);
            }
            Coordinate coordinate = new Coordinate(qualifier, type);
            boolean optional = (Boolean)AnnotationsUtil.getAnnotationValueValue(input, "optional");
            ServiceSpec service = new ServiceSpec(coordinate, optional);
            Binding binding = new Binding(Binding.Kind.INPUT, element.getQualifiedName() + "#" + i, Collections.singletonList(service), true, element, new ServiceDescriptor[0]);
            results.add(new InputDescriptor(service, binding, "input" + (i + 1)));
        }
        return results;
    }

    @Nonnull
    private List<IncludeDescriptor> extractIncludes(@Nonnull TypeElement element, @Nonnull String annotationClassname) {
        ArrayList<IncludeDescriptor> results = new ArrayList<IncludeDescriptor>();
        List<TypeMirror> includes = AnnotationsUtil.getTypeMirrorsAnnotationParameter(element, annotationClassname, "includes");
        for (TypeMirror include : includes) {
            Element includeElement = this.processingEnv.getTypeUtils().asElement(include);
            if (AnnotationsUtil.hasAnnotationOfType(includeElement, "sting.Fragment") || AnnotationsUtil.hasAnnotationOfType(includeElement, "sting.Injectable")) {
                results.add(new IncludeDescriptor((DeclaredType)include, include.toString()));
                continue;
            }
            ElementKind kind = includeElement.getKind();
            if (ElementKind.CLASS != kind && ElementKind.INTERFACE != kind) continue;
            List providers = includeElement.getAnnotationMirrors().stream().map(a -> {
                AnnotationMirror provider = this.getStingProvider(element, annotationClassname, (TypeElement)includeElement, (AnnotationMirror)a);
                return null != provider ? new ProviderEntry((AnnotationMirror)a, provider) : null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (providers.size() > 1) {
                String message = MemberChecks.toSimpleName(annotationClassname) + " target has an 'includes' parameter containing the value " + includeElement.asType() + " that is annotated by multiple @StingProvider annotations. Matching annotations:\n" + providers.stream().map(a -> ((TypeElement)a.getAnnotation().getAnnotationType().asElement()).getQualifiedName()).map(a -> "  " + a).collect(Collectors.joining("\n"));
                throw new ProcessorException(message, element);
            }
            if (!providers.isEmpty()) {
                ProviderEntry entry = (ProviderEntry)providers.get(0);
                AnnotationMirror providerAnnotation = entry.getProvider();
                String namePattern = (String)AnnotationsUtil.getAnnotationValueValue(providerAnnotation, "value");
                String targetCompoundType = namePattern.replace("[SimpleName]", includeElement.getSimpleName().toString()).replace("[CompoundName]", this.getComponentName((TypeElement)includeElement)).replace("[EnclosingName]", this.getEnclosingName((TypeElement)includeElement)).replace("[FlatEnclosingName]", this.getEnclosingName((TypeElement)includeElement).replace('.', '_'));
                String targetQualifiedName = ElementsUtil.getPackageElement(includeElement).getQualifiedName().toString() + "." + targetCompoundType;
                results.add(new IncludeDescriptor((DeclaredType)include, targetQualifiedName));
                continue;
            }
            throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target has an includes parameter containing the value " + include + " that is not a type annotated by either " + MemberChecks.toSimpleName("sting.Fragment") + " or " + MemberChecks.toSimpleName("sting.Injectable") + " and the type does not declare a provider", element);
        }
        return results;
    }

    @Nullable
    private AnnotationMirror getStingProvider(@Nonnull TypeElement element, @Nonnull String annotationClassname, @Nonnull TypeElement includeElement, @Nonnull AnnotationMirror annotation) {
        return annotation.getAnnotationType().asElement().getAnnotationMirrors().stream().filter(ca -> this.isStingProvider(element, annotationClassname, includeElement, (AnnotationMirror)ca)).findAny().orElse(null);
    }

    @Nonnull
    private String getComponentName(@Nonnull TypeElement element) {
        return this.getEnclosingName(element) + element.getSimpleName();
    }

    @Nonnull
    private String getEnclosingName(@Nonnull TypeElement element) {
        Element enclosingElement = element.getEnclosingElement();
        ArrayList<String> nameParts = new ArrayList<String>();
        while (ElementKind.PACKAGE != enclosingElement.getKind()) {
            nameParts.add(enclosingElement.getSimpleName().toString());
            enclosingElement = enclosingElement.getEnclosingElement();
        }
        if (nameParts.isEmpty()) {
            return "";
        }
        Collections.reverse(nameParts);
        return String.join((CharSequence)".", nameParts) + ".";
    }

    private boolean isStingProvider(@Nonnull TypeElement element, @Nonnull String annotationClassname, @Nonnull Element includeElement, @Nonnull AnnotationMirror annotation) {
        if (!annotation.getAnnotationType().asElement().getSimpleName().contentEquals("StingProvider")) {
            return false;
        }
        boolean nameMatched = annotation.getElementValues().entrySet().stream().anyMatch(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value") && ((AnnotationValue)e.getValue()).getValue() instanceof String);
        if (nameMatched) {
            return true;
        }
        String message = MemberChecks.toSimpleName(annotationClassname) + " target has an 'includes' parameter containing the value " + includeElement.asType() + " that is annotated by " + annotation + " that is annotated by an invalid @StingProvider annotation missing a 'value' parameter of type string.";
        throw new ProcessorException(message, element);
    }

    private void emitFragmentJsonDescriptor(@Nonnull FragmentDescriptor fragment) throws IOException {
        if (this._emitJsonDescriptors) {
            TypeElement element = fragment.getElement();
            String filename = this.toFilename(element) + JSON_SUFFIX;
            JsonUtil.writeJsonResource(this.processingEnv, element, filename, fragment::write);
        }
    }

    private void processProvidesMethod(@Nonnull TypeElement element, @Nonnull Map<ExecutableElement, Binding> bindings, @Nonnull ExecutableElement method) {
        if (TypeKind.VOID == method.getReturnType().getKind()) {
            throw new ProcessorException(MemberChecks.must("sting.Fragment", "only contain methods that return a value"), method);
        }
        if (!method.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain methods with a type parameter"), method);
        }
        if (!method.getModifiers().contains((Object)Modifier.DEFAULT)) {
            throw new ProcessorException(MemberChecks.must("sting.Fragment", "only contain methods with a default modifier"), method);
        }
        boolean nullablePresent = AnnotationsUtil.hasNullableAnnotation(method);
        if (nullablePresent && method.getReturnType().getKind().isPrimitive()) {
            throw new ProcessorException(MemberChecks.toSimpleName("sting.Fragment") + " contains a method that is incorrectly annotated with " + MemberChecks.toSimpleName("javax.annotation.Nullable") + " as the return type is a primitive value", method);
        }
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(method);
        if (!scopedAnnotations.isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method that is annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations), method);
        }
        boolean eager = AnnotationsUtil.hasAnnotationOfType(method, "sting.Eager");
        ArrayList<ServiceDescriptor> dependencies = new ArrayList<ServiceDescriptor>();
        int index = 0;
        List<? extends TypeMirror> parameterTypes = ((ExecutableType)method.asType()).getParameterTypes();
        for (VariableElement variableElement : method.getParameters()) {
            dependencies.add(this.processFragmentServiceParameter(variableElement, parameterTypes.get(index), index));
            ++index;
        }
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(method, "sting.Typed");
        AnnotationValue annotationValue = null != annotation ? AnnotationsUtil.findAnnotationValue(annotation, "value") : null;
        String qualifier = this.getQualifier(method);
        if (AnnotationsUtil.hasAnnotationOfType(method, "javax.inject.Named")) {
            String message = MemberChecks.mustNot("sting.Fragment", "contain a method annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead");
            throw new ProcessorException(message, method);
        }
        if (AnnotationsUtil.hasAnnotationOfType(method, "javax.enterprise.inject.Typed")) {
            String message = MemberChecks.mustNot("sting.Fragment", "contain a method annotated with the javax.enterprise.inject.Typed annotation. Use the sting.Typed annotation instead");
            throw new ProcessorException(message, method);
        }
        List<TypeMirror> types = null == annotationValue ? Collections.singletonList(method.getReturnType()) : ((List)annotationValue.getValue()).stream().map(v -> (TypeMirror)v.getValue()).collect(Collectors.toList());
        ServiceSpec[] specs = new ServiceSpec[types.size()];
        for (int i = 0; i < specs.length; ++i) {
            TypeMirror type = types.get(i);
            if (!this.processingEnv.getTypeUtils().isAssignable(method.getReturnType(), type)) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Typed") + " specified a type that is not assignable to the return type of the method", element, annotation, annotationValue);
            }
            if (TypeKind.DECLARED == type.getKind() && this.isParameterized((DeclaredType)type)) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Typed") + " specified a type that is a a parameterized type", element, annotation, annotationValue);
            }
            specs[i] = new ServiceSpec(new Coordinate(qualifier, type), nullablePresent);
        }
        if (0 == specs.length && !eager) {
            throw new ProcessorException(MemberChecks.toSimpleName("sting.Fragment") + " target must not contain methods that specify zero types with the " + MemberChecks.toSimpleName("sting.Typed") + " annotation and are not annotated with the " + MemberChecks.toSimpleName("sting.Eager") + " annotation otherwise the component can not be created by the injector", element);
        }
        Binding binding = new Binding(Binding.Kind.PROVIDES, element.getQualifiedName() + "#" + method.getSimpleName(), Arrays.asList(specs), eager, method, dependencies.toArray(new ServiceDescriptor[0]));
        bindings.put(method, binding);
    }

    @Nonnull
    private ServiceDescriptor processFragmentServiceParameter(@Nonnull VariableElement parameter, @Nonnull TypeMirror type, int parameterIndex) {
        if (TypesUtil.containsArrayType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter that contains an array type"), parameter);
        }
        if (TypesUtil.containsWildcard(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter that contains a wildcard type parameter"), parameter);
        }
        if (TypesUtil.containsRawType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter that contains a raw type"), parameter);
        }
        TypeMirror dependencyType = null;
        ServiceDescriptor.Kind kind = null;
        for (ServiceDescriptor.Kind candidate : ServiceDescriptor.Kind.values()) {
            dependencyType = candidate.extractType(type);
            if (null == dependencyType) continue;
            kind = candidate;
            break;
        }
        if (null == kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter that contains an unexpected parameterized type. Only parameterized types known to the framework are supported"), parameter);
        }
        boolean optional = AnnotationsUtil.hasNullableAnnotation(parameter);
        if (optional && ServiceDescriptor.Kind.INSTANCE != kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter annotated with the " + MemberChecks.toSimpleName("javax.annotation.Nullable") + " annotation that is not an instance dependency kind"), parameter);
        }
        String qualifier = this.getQualifier(parameter);
        if (AnnotationsUtil.hasAnnotationOfType(parameter, "javax.inject.Named")) {
            String message = MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead");
            throw new ProcessorException(message, parameter);
        }
        Coordinate coordinate = new Coordinate(qualifier, dependencyType);
        ServiceSpec service = new ServiceSpec(coordinate, optional);
        return new ServiceDescriptor(kind, service, parameter, parameterIndex);
    }

    private void processInjectable(@Nonnull TypeElement element) {
        String message;
        this.debug(() -> "Processing Injectable: " + element);
        if (ElementKind.CLASS != element.getKind()) {
            throw new ProcessorException(MemberChecks.must("sting.Injectable", "be a class"), element);
        }
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "be abstract"), element);
        }
        if (ElementsUtil.isNonStaticNestedClass(element)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "be a non-static nested class"), element);
        }
        if (!element.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "have type parameters"), element);
        }
        List<ExecutableElement> constructors = ElementsUtil.getConstructors(element);
        ExecutableElement constructor = constructors.get(0);
        if (constructors.size() > 1) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "have multiple constructors"), element);
        }
        this.injectableConstructorShouldNotBeProtected(constructor);
        this.injectableConstructorShouldNotBePublic(constructor);
        this.injectableShouldNotHaveScopedAnnotation(element);
        boolean eager = AnnotationsUtil.hasAnnotationOfType(element, "sting.Eager");
        ArrayList<ServiceDescriptor> dependencies = new ArrayList<ServiceDescriptor>();
        int index = 0;
        List<? extends TypeMirror> parameterTypes = ((ExecutableType)constructor.asType()).getParameterTypes();
        for (VariableElement variableElement : constructor.getParameters()) {
            dependencies.add(this.handleConstructorParameter(variableElement, parameterTypes.get(index), index));
            ++index;
        }
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(element, "sting.Typed");
        AnnotationValue annotationValue = null != annotation ? AnnotationsUtil.findAnnotationValue(annotation, "value") : null;
        String qualifier = this.getQualifier(element);
        if (AnnotationsUtil.hasAnnotationOfType(element, "javax.inject.Named") && ElementsUtil.isWarningNotSuppressed(element, "Sting:Jsr330NamedPresent")) {
            message = MemberChecks.mustNot("sting.Injectable", "be annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead. " + MemberChecks.suppressedBy("Sting:Jsr330NamedPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
        }
        if (AnnotationsUtil.hasAnnotationOfType(element, "javax.enterprise.inject.Typed") && ElementsUtil.isWarningNotSuppressed(element, "Sting:CdiTypedPresent")) {
            message = MemberChecks.mustNot("sting.Injectable", "be annotated with the javax.enterprise.inject.Typed annotation. Use the sting.Typed annotation instead. " + MemberChecks.suppressedBy("Sting:CdiTypedPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
        }
        if (AnnotationsUtil.hasAnnotationOfType(constructor, "javax.inject.Inject") && ElementsUtil.isWarningNotSuppressed(constructor, "Sting:Jsr330InjectPresent")) {
            message = MemberChecks.mustNot("sting.Injectable", "be annotated with the javax.inject.Inject annotation. " + MemberChecks.suppressedBy("Sting:Jsr330InjectPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, constructor);
        }
        List<TypeMirror> types = null == annotationValue ? Collections.singletonList(element.asType()) : ((List)annotationValue.getValue()).stream().map(v -> (TypeMirror)v.getValue()).collect(Collectors.toList());
        ServiceSpec[] specs = new ServiceSpec[types.size()];
        for (int i = 0; i < specs.length; ++i) {
            TypeMirror type = types.get(i);
            if (!this.processingEnv.getTypeUtils().isAssignable(element.asType(), type)) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Typed") + " specified a type that is not assignable to the declaring type", element, annotation, annotationValue);
            }
            if (TypeKind.DECLARED == type.getKind() && this.isParameterized((DeclaredType)type)) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Typed") + " specified a type that is a a parameterized type", element, annotation, annotationValue);
            }
            specs[i] = new ServiceSpec(new Coordinate(qualifier, type), false);
        }
        if (0 == specs.length && !eager) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "specify zero types with the " + MemberChecks.toSimpleName("sting.Typed") + " annotation or must be annotated with the " + MemberChecks.toSimpleName("sting.Eager") + " annotation otherwise the component can not be created by the injector"), element);
        }
        Binding binding = new Binding(Binding.Kind.INJECTABLE, element.getQualifiedName().toString(), Arrays.asList(specs), eager, constructor, dependencies.toArray(new ServiceDescriptor[0]));
        InjectableDescriptor injectable = new InjectableDescriptor(binding);
        this._registry.registerInjectable(injectable);
    }

    private void writeBinaryDescriptor(@Nonnull TypeElement element, @Nonnull Object descriptor) throws IOException {
        String[] nameParts = this.extractNameParts(element);
        FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, nameParts[0], nameParts[1], element);
        try (OutputStream out = resource.openOutputStream();
             DataOutputStream dos1 = new DataOutputStream(out);){
            this._descriptorIO.write(dos1, descriptor);
        }
        if (this._verifyDescriptors) {
            this.verifyDescriptor(element, descriptor);
        }
    }

    @Nonnull
    private String[] extractNameParts(@Nonnull TypeElement element) {
        String binaryName = this.processingEnv.getElementUtils().getBinaryName(element).toString();
        int lastIndex = binaryName.lastIndexOf(".");
        String packageName = -1 == lastIndex ? "" : binaryName.substring(0, lastIndex);
        String relativeName = binaryName.substring(-1 == lastIndex ? 0 : lastIndex + 1) + SUFFIX;
        return new String[]{packageName, relativeName};
    }

    private void verifyDescriptor(@Nonnull TypeElement element, @Nonnull Object descriptor) throws IOException {
        Object newDescriptor;
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos1);){
            this._descriptorIO.write(dos, descriptor);
        }
        try (DataInputStream dos = new DataInputStream(new ByteArrayInputStream(baos1.toByteArray()));){
            newDescriptor = this._descriptorIO.read(dos, element.getQualifiedName().toString());
        }
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos2);){
            this._descriptorIO.write(dos, newDescriptor);
        }
        if (!Arrays.equals(baos1.toByteArray(), baos2.toByteArray())) {
            throw new ProcessorException("Failed to emit valid binary descriptor for " + element.getQualifiedName() + ". Reading the emitted descriptor did not produce an equivalent descriptor.", element);
        }
    }

    private void emitInjectableJsonDescriptor(@Nonnull InjectableDescriptor injectable) throws IOException {
        if (this._emitJsonDescriptors) {
            TypeElement element = injectable.getElement();
            String filename = this.toFilename(element) + JSON_SUFFIX;
            JsonUtil.writeJsonResource(this.processingEnv, element, filename, injectable::write);
        }
    }

    @Nonnull
    private String toFilename(@Nonnull TypeElement typeElement) {
        return GeneratorUtil.getGeneratedClassName(typeElement, "", "").toString().replace(".", "/");
    }

    @Nonnull
    private ServiceDescriptor handleConstructorParameter(@Nonnull VariableElement parameter, @Nonnull TypeMirror type, int parameterIndex) {
        if (TypesUtil.containsArrayType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter that contains an array type"), parameter);
        }
        if (TypesUtil.containsWildcard(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter that contains a wildcard type parameter"), parameter);
        }
        if (TypesUtil.containsRawType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter that contains a raw type"), parameter);
        }
        TypeMirror dependencyType = null;
        ServiceDescriptor.Kind kind = null;
        for (ServiceDescriptor.Kind candidate : ServiceDescriptor.Kind.values()) {
            dependencyType = candidate.extractType(type);
            if (null == dependencyType) continue;
            kind = candidate;
            break;
        }
        if (null == kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter that contains an unexpected parameterized type. Only parameterized types known to the framework are supported"), parameter);
        }
        boolean optional = AnnotationsUtil.hasNullableAnnotation(parameter);
        if (optional && ServiceDescriptor.Kind.INSTANCE != kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter annotated with " + MemberChecks.toSimpleName("javax.annotation.Nullable") + " that is not an instance dependency kind"), parameter);
        }
        String qualifier = this.getQualifier(parameter);
        if (AnnotationsUtil.hasAnnotationOfType(parameter, "javax.inject.Named") && ElementsUtil.isWarningNotSuppressed(parameter, "Sting:Jsr330NamedPresent")) {
            String message = MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead. " + MemberChecks.suppressedBy("Sting:Jsr330NamedPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, parameter);
        }
        Coordinate coordinate = new Coordinate(qualifier, dependencyType);
        ServiceSpec service = new ServiceSpec(coordinate, optional);
        return new ServiceDescriptor(kind, service, parameter, parameterIndex);
    }

    @Nonnull
    private String getQualifier(@Nonnull Element element) {
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(element, "sting.Named");
        return null == annotation ? "" : (String)AnnotationsUtil.getAnnotationValueValue(annotation, "value");
    }

    private void injectableShouldNotHaveScopedAnnotation(@Nonnull TypeElement element) {
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(element);
        if (!scopedAnnotations.isEmpty() && ElementsUtil.isWarningNotSuppressed(element, "Sting:Jsr330ScopedPresent")) {
            String message = MemberChecks.shouldNot("sting.Injectable", "be annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations + ". " + MemberChecks.suppressedBy("Sting:Jsr330ScopedPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
        }
    }

    private void injectableConstructorShouldNotBePublic(@Nonnull ExecutableElement constructor) {
        if (ElementsUtil.isNotSynthetic(constructor) && constructor.getModifiers().contains((Object)Modifier.PUBLIC) && ElementsUtil.isWarningNotSuppressed(constructor, "Sting:PublicConstructor")) {
            String message = MemberChecks.shouldNot("sting.Injectable", "have a public constructor. The type is instantiated by the injector and should have a package-access constructor. " + MemberChecks.suppressedBy("Sting:PublicConstructor"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, constructor);
        }
    }

    private void injectableConstructorShouldNotBeProtected(@Nonnull ExecutableElement constructor) {
        if (constructor.getModifiers().contains((Object)Modifier.PROTECTED) && ElementsUtil.isWarningNotSuppressed(constructor, "Sting:ProtectedConstructor")) {
            String message = MemberChecks.shouldNot("sting.Injectable", "have a protected constructor. The type is instantiated by the injector and should have a package-access constructor. " + MemberChecks.suppressedBy("Sting:ProtectedConstructor"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, constructor);
        }
    }

    @Nonnull
    private Object loadDescriptor(String classname, byte[] data) throws IOException {
        return this._descriptorIO.read(new DataInputStream(new ByteArrayInputStream(data)), classname);
    }

    @Nullable
    private byte[] tryLoadDescriptorData(@Nonnull TypeElement element) {
        byte[] data = this.tryLoadDescriptorData(StandardLocation.CLASS_PATH, element);
        return null != data ? data : this.tryLoadDescriptorData(StandardLocation.CLASS_OUTPUT, element);
    }

    @Nullable
    private byte[] tryLoadDescriptorData(@Nonnull JavaFileManager.Location location, @Nonnull TypeElement element) {
        String[] nameParts = this.extractNameParts(element);
        try {
            return IOUtil.readFully(this.processingEnv.getFiler().getResource(location, nameParts[0], nameParts[1]));
        }
        catch (IOException ignored) {
            return null;
        }
        catch (RuntimeException e) {
            if (e.getClass().getCanonicalName().equals("com.sun.tools.javac.util.ClientCodeException") && e.getCause() instanceof NullPointerException) {
                return null;
            }
            throw e;
        }
    }

    private boolean isParameterized(@Nonnull DeclaredType nestedParameterType) {
        return !((TypeElement)nestedParameterType.asElement()).getTypeParameters().isEmpty();
    }

    @Nonnull
    private List<? extends AnnotationMirror> getScopedAnnotations(@Nonnull Element element) {
        return element.getAnnotationMirrors().stream().filter(a -> AnnotationsUtil.hasAnnotationOfType(a.getAnnotationType().asElement(), "javax.inject.Scope")).collect(Collectors.toList());
    }
}

