/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.stream.JsonGenerator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import sting.processor.Binding;
import sting.processor.ComponentGraph;
import sting.processor.Edge;
import sting.processor.FragmentNode;
import sting.processor.ServiceDescriptor;
import sting.processor.vendor.proton.ElementsUtil;

final class Node {
    @Nonnull
    private final ComponentGraph _componentGraph;
    @Nullable
    private final Binding _binding;
    @Nonnull
    private final Map<ServiceDescriptor, Edge> _dependsOn = new LinkedHashMap<ServiceDescriptor, Edge>();
    @Nonnull
    private final Set<Edge> _usedBy = new HashSet<Edge>();
    private boolean _eager;
    private int _depth = Integer.MAX_VALUE;
    @Nullable
    private String _name;
    @Nullable
    private final TypeMirror _type;
    private final boolean _public;
    @Nullable
    private FragmentNode _fragment;

    Node(@Nonnull ComponentGraph componentGraph) {
        this(componentGraph, null, componentGraph.getInjector().getOutputs().toArray(new ServiceDescriptor[0]));
    }

    Node(ComponentGraph componentGraph, @Nonnull Binding binding) {
        this(componentGraph, binding, binding.getDependencies());
    }

    private Node(@Nonnull ComponentGraph componentGraph, @Nullable Binding binding, @Nonnull ServiceDescriptor[] dependencies) {
        this._componentGraph = Objects.requireNonNull(componentGraph);
        this._binding = binding;
        for (ServiceDescriptor dependency : dependencies) {
            this._dependsOn.put(dependency, new Edge(this, dependency));
        }
        if (null != this._binding) {
            Element element = binding.getElement();
            Binding.Kind kind = binding.getKind();
            this._type = Binding.Kind.INPUT == kind ? binding.getPublishedServices().get(0).getCoordinate().getType() : (Binding.Kind.INJECTABLE == kind ? element.getEnclosingElement().asType() : ((ExecutableElement)element).getReturnType());
            this._public = TypeKind.DECLARED != this._type.getKind() || ElementsUtil.isEffectivelyPublic((TypeElement)((DeclaredType)this._type).asElement());
        } else {
            this._type = null;
            this._public = true;
        }
    }

    boolean isFromProvides() {
        return null != this._binding && Binding.Kind.PROVIDES == this._binding.getKind();
    }

    @Nonnull
    String getName() {
        assert (null != this._name);
        return this._name;
    }

    void setName(@Nonnull String name) {
        this._name = Objects.requireNonNull(name);
    }

    @Nonnull
    TypeMirror getType() {
        assert (null != this._type);
        return this._type;
    }

    boolean isPublic() {
        return this._public;
    }

    boolean isEager() {
        return this._eager;
    }

    void markNodeAndUpstreamAsEager() {
        if (!this._eager) {
            this._eager = true;
            for (Edge edge : this._dependsOn.values()) {
                if (edge.getService().getKind().isSupplier()) continue;
                edge.getSatisfiedBy().forEach(Node::markNodeAndUpstreamAsEager);
            }
        }
    }

    boolean hasNoBinding() {
        return null == this._binding;
    }

    @Nonnull
    Binding getBinding() {
        assert (null != this._binding);
        return this._binding;
    }

    @Nonnull
    Collection<Edge> getDependsOn() {
        return this._dependsOn.values();
    }

    @Nonnull
    Set<Edge> getUsedBy() {
        return this._usedBy;
    }

    boolean isDepthNotSet() {
        return Integer.MAX_VALUE == this._depth;
    }

    int getDepth() {
        return this._depth;
    }

    void setDepth(int depth) {
        this._depth = depth;
    }

    void usedBy(@Nonnull Edge edge) {
        assert (!this._usedBy.contains(edge));
        this._usedBy.add(edge);
    }

    void setFragment(@Nonnull FragmentNode fragment) {
        assert (this.isFromProvides());
        assert (null == this._fragment);
        this._fragment = fragment;
    }

    @Nonnull
    FragmentNode getFragment() {
        assert (null != this._fragment);
        return this._fragment;
    }

    @Nonnull
    String describe(@Nonnull String connector) {
        return "  " + this.getTypeLabel() + connector + " " + this.describeBinding();
    }

    @Nonnull
    String getTypeLabel() {
        return null == this._binding ? "[Injector]   " : this._binding.getTypeLabel();
    }

    @Nonnull
    String describeBinding() {
        return null == this._binding ? this._componentGraph.getInjector().getElement().getQualifiedName().toString() : this._binding.describe();
    }

    void write(@Nonnull JsonGenerator g) {
        g.writeStartObject();
        assert (null != this._binding);
        g.write("id", this._binding.getId());
        Binding.Kind kind = this._binding.getKind();
        g.write("kind", kind.name());
        if (this._eager) {
            g.write("eager", true);
        }
        if (!this._dependsOn.isEmpty()) {
            g.writeStartArray("dependencies");
            for (Edge edge : this._dependsOn.values()) {
                g.writeStartObject();
                edge.getService().getService().getCoordinate().write(g);
                g.writeStartArray("supportedBy");
                for (Node node : edge.getSatisfiedBy()) {
                    g.write(node.getBinding().getId());
                }
                g.writeEnd();
                g.writeEnd();
            }
            g.writeEnd();
        }
        g.writeEnd();
    }
}

