/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import sting.processor.Binding;
import sting.processor.ComponentGraph;
import sting.processor.Edge;
import sting.processor.FragmentNode;
import sting.processor.InjectableDescriptor;
import sting.processor.InjectorDescriptor;
import sting.processor.InputDescriptor;
import sting.processor.Node;
import sting.processor.ServiceDescriptor;
import sting.processor.ServiceSpec;
import sting.processor.StingGeneratorUtil;
import sting.processor.StingProcessor;
import sting.processor.vendor.javapoet.ClassName;
import sting.processor.vendor.javapoet.CodeBlock;
import sting.processor.vendor.javapoet.FieldSpec;
import sting.processor.vendor.javapoet.MethodSpec;
import sting.processor.vendor.javapoet.ParameterSpec;
import sting.processor.vendor.javapoet.TypeName;
import sting.processor.vendor.javapoet.TypeSpec;
import sting.processor.vendor.proton.ElementsUtil;
import sting.processor.vendor.proton.GeneratorUtil;
import sting.processor.vendor.proton.SuppressWarningsUtil;

final class InjectorGenerator {
    @Nonnull
    private static final ClassName DO_NOT_INLINE = ClassName.get("javaemul.internal.annotations", "DoNotInline", new String[0]);

    private InjectorGenerator() {
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentGraph graph) {
        InjectorDescriptor injector = graph.getInjector();
        TypeElement element = injector.getElement();
        TypeSpec.Builder builder = TypeSpec.classBuilder(StingGeneratorUtil.getGeneratedClassName(element)).addModifiers(Modifier.FINAL);
        GeneratorUtil.addOriginatingTypes(element, builder);
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)element, builder);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, StingProcessor.class.getName());
        builder.addSuperinterface(TypeName.get(element.asType()));
        InjectorGenerator.emitFragmentFields(processingEnv, builder, graph);
        InjectorGenerator.emitNodeFields(processingEnv, graph, builder);
        InjectorGenerator.emitOutputCollectionFields(graph, builder);
        InjectorGenerator.emitConstructor(graph, builder);
        InjectorGenerator.emitNodeAccessorMethod(processingEnv, graph, builder);
        InjectorGenerator.emitOutputMethods(processingEnv, graph, builder);
        return builder.build();
    }

    private static void emitOutputMethods(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentGraph graph, @Nonnull TypeSpec.Builder builder) {
        for (Edge edge : graph.getRootNode().getDependsOn()) {
            ServiceDescriptor service = edge.getService();
            ExecutableElement element = (ExecutableElement)service.getElement();
            MethodSpec.Builder method = MethodSpec.overriding(element, (DeclaredType)graph.getInjector().getElement().asType(), processingEnv.getTypeUtils());
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)element, method);
            SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, Collections.emptyList(), Collections.singletonList(element.asType()));
            if (service.getKind().isCollection()) {
                String name = InjectorGenerator.getOutputCollectionCacheName(edge);
                CodeBlock.Builder block = CodeBlock.builder();
                block.beginControlFlow("if ( null == $N )", name);
                StringBuilder code = new StringBuilder();
                ArrayList<Object> args = new ArrayList<Object>();
                code.append("$N = ");
                args.add(name);
                InjectorGenerator.emitServiceValue(edge, true, code, args);
                block.addStatement(code.toString(), args.toArray());
                block.endControlFlow();
                method.addCode(block.build());
                method.addStatement("return $N", name);
            } else {
                StringBuilder code = new StringBuilder();
                ArrayList<Object> args = new ArrayList<Object>();
                code.append("return ");
                InjectorGenerator.emitServiceValue(edge, true, code, args);
                method.addStatement(code.toString(), args.toArray());
            }
            builder.addMethod(method.build());
        }
    }

    private static void emitConstructor(@Nonnull ComponentGraph graph, @Nonnull TypeSpec.Builder builder) {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder();
        for (InputDescriptor input : graph.getInjector().getInputs()) {
            ParameterSpec.Builder parameter = ParameterSpec.builder(TypeName.get(input.getService().getCoordinate().getType()), input.getName(), Modifier.FINAL);
            if (!input.getService().getCoordinate().getType().getKind().isPrimitive()) {
                parameter.addAnnotation(input.getService().isOptional() ? GeneratorUtil.NULLABLE_CLASSNAME : GeneratorUtil.NONNULL_CLASSNAME);
            }
            ctor.addParameter(parameter.build());
        }
        for (Node node : graph.getNodes()) {
            if (!node.isEager()) continue;
            Binding binding = node.getBinding();
            if (Binding.Kind.INPUT == binding.getKind()) {
                InputDescriptor input = (InputDescriptor)binding.getOwner();
                ServiceSpec serviceSpec = binding.getPublishedServices().get(0);
                if (serviceSpec.isOptional() || serviceSpec.getCoordinate().getType().getKind().isPrimitive()) {
                    ctor.addStatement("$N = $N", node.getName(), input.getName());
                    continue;
                }
                ctor.addStatement("$N = $T.requireNonNull( $N )", node.getName(), Objects.class, input.getName());
                continue;
            }
            StringBuilder code = new StringBuilder();
            ArrayList<Object> args = new ArrayList<Object>();
            InjectorGenerator.provideAndAssign(node, code, args);
            ctor.addStatement(code.toString(), args.toArray());
        }
        builder.addMethod(ctor.build());
    }

    private static void emitNodeFields(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentGraph graph, @Nonnull TypeSpec.Builder builder) {
        for (Node node : graph.getNodes()) {
            FieldSpec.Builder field = FieldSpec.builder(InjectorGenerator.getPublicTypeName(node), node.getName(), Modifier.PRIVATE);
            if (!node.getType().getKind().isPrimitive()) {
                field.addAnnotation(node.isEager() && node.getBinding().isRequired() ? GeneratorUtil.NONNULL_CLASSNAME : GeneratorUtil.NULLABLE_CLASSNAME);
            }
            if (node.isPublic()) {
                SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.emptyList(), Collections.singletonList(node.getType()));
            }
            if (node.isEager()) {
                field.addModifiers(Modifier.FINAL);
            }
            builder.addField(field.build());
            if (node.isEager() || !node.getBinding().isOptional() && !node.getType().getKind().isPrimitive()) continue;
            builder.addField(FieldSpec.builder(TypeName.BOOLEAN, InjectorGenerator.getFlagFieldName(node), Modifier.PRIVATE).build());
        }
    }

    private static void emitOutputCollectionFields(@Nonnull ComponentGraph graph, @Nonnull TypeSpec.Builder builder) {
        for (Edge edge : graph.getRootNode().getDependsOn()) {
            ServiceDescriptor service = edge.getService();
            if (!service.getKind().isCollection()) continue;
            TypeName serviceType = StingGeneratorUtil.getServiceType(service);
            builder.addField(FieldSpec.builder(serviceType, InjectorGenerator.getOutputCollectionCacheName(edge), Modifier.PRIVATE).build());
        }
    }

    @Nonnull
    private static String getOutputCollectionCacheName(@Nonnull Edge edge) {
        return "$sting$_" + edge.getService().getElement().getSimpleName().toString() + "Cache";
    }

    private static TypeName getPublicTypeName(@Nonnull Node node) {
        return node.isPublic() ? TypeName.get(node.getType()) : TypeName.OBJECT;
    }

    private static void emitNodeAccessorMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentGraph graph, @Nonnull TypeSpec.Builder builder) {
        for (Node node : graph.getNodes()) {
            boolean isNonPrimitive;
            if (node.isEager()) continue;
            MethodSpec.Builder method = MethodSpec.methodBuilder(node.getName()).addModifiers(Modifier.PRIVATE, Modifier.SYNCHRONIZED).returns(InjectorGenerator.getPublicTypeName(node));
            Binding binding = node.getBinding();
            Element element = binding.getElement();
            List<TypeMirror> types = Collections.singletonList(element.getEnclosingElement().asType());
            ArrayList<String> additionalSuppressions = new ArrayList<String>();
            if (ElementsUtil.isElementDeprecated(element)) {
                additionalSuppressions.add("deprecation");
            }
            SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, additionalSuppressions, types);
            boolean isNonnull = binding.isRequired();
            boolean bl = isNonPrimitive = !node.getType().getKind().isPrimitive();
            if (isNonPrimitive) {
                method.addAnnotation(isNonnull ? GeneratorUtil.NONNULL_CLASSNAME : GeneratorUtil.NULLABLE_CLASSNAME);
            }
            if (graph.getInjector().isGwt()) {
                method.addAnnotation(DO_NOT_INLINE);
            }
            CodeBlock.Builder block = CodeBlock.builder();
            if (isNonnull && isNonPrimitive) {
                block.beginControlFlow("if ( null == $N )", node.getName());
            } else {
                String flagName = InjectorGenerator.getFlagFieldName(node);
                block.beginControlFlow("if ( !$N )", flagName);
                block.addStatement("$N = true", flagName);
            }
            StringBuilder code = new StringBuilder();
            ArrayList<Object> args = new ArrayList<Object>();
            InjectorGenerator.provideAndAssign(node, code, args);
            block.addStatement(code.toString(), args.toArray());
            block.endControlFlow();
            method.addCode(block.build());
            if (isNonnull && isNonPrimitive) {
                method.addStatement("assert null != $N", node.getName());
            }
            method.addStatement("return $N", node.getName());
            builder.addMethod(method.build());
        }
    }

    @Nonnull
    private static String getFlagFieldName(@Nonnull Node node) {
        return node.getName() + "_allocated";
    }

    private static void provideAndAssign(@Nonnull Node node, @Nonnull StringBuilder code, @Nonnull List<Object> args) {
        boolean requireNonNull;
        code.append("$N = ");
        args.add(node.getName());
        boolean isNonnull = node.getBinding().isRequired();
        boolean bl = requireNonNull = isNonnull && !node.getType().getKind().isPrimitive();
        if (requireNonNull) {
            code.append("$T.requireNonNull( ");
            args.add(Objects.class);
        }
        if (node.isFromProvides()) {
            code.append("$N.$N");
            args.add(node.getFragment().getName());
            args.add(StingGeneratorUtil.getFragmentProvidesStubName((ExecutableElement)node.getBinding().getElement()));
        } else {
            InjectableDescriptor injectable = (InjectableDescriptor)node.getBinding().getOwner();
            code.append("$T.create");
            args.add(StingGeneratorUtil.getGeneratedClassName(injectable.getElement()));
        }
        code.append('(');
        boolean firstParam = true;
        for (Edge edge : node.getDependsOn()) {
            if (!firstParam) {
                code.append(", ");
            } else {
                firstParam = false;
            }
            InjectorGenerator.emitServiceValue(edge, false, code, args);
        }
        code.append(')');
        if (requireNonNull) {
            code.append(" )");
        }
    }

    private static void emitServiceValue(@Nonnull Edge edge, boolean isOutput, @Nonnull StringBuilder code, @Nonnull List<Object> args) {
        Collection<Node> satisfiedBy = edge.getSatisfiedBy();
        ServiceDescriptor service = edge.getService();
        ServiceDescriptor.Kind kind = service.getKind();
        if (!kind.isCollection()) {
            if (satisfiedBy.isEmpty()) {
                code.append("null");
            } else {
                InjectorGenerator.emitNodeAccessor(service, satisfiedBy.iterator().next(), isOutput, code, args);
            }
        } else {
            int count = satisfiedBy.size();
            if (0 == count) {
                code.append("$T.emptyList()");
                args.add(Collections.class);
            } else if (1 == count) {
                code.append("$T.singletonList( ");
                args.add(Collections.class);
                InjectorGenerator.emitNodeAccessor(service, satisfiedBy.iterator().next(), isOutput, code, args);
                code.append(" )");
            } else {
                code.append("$T.asList( ");
                args.add(Arrays.class);
                Iterator<Node> iterator = satisfiedBy.iterator();
                for (int i = 0; i < count; ++i) {
                    if (0 != i) {
                        code.append(", ");
                    }
                    InjectorGenerator.emitNodeAccessor(service, iterator.next(), isOutput, code, args);
                }
                code.append(" )");
            }
        }
    }

    private static void emitNodeAccessor(@Nonnull ServiceDescriptor service, @Nonnull Node node, boolean isOutput, @Nonnull StringBuilder code, @Nonnull List<Object> args) {
        ServiceDescriptor.Kind kind = service.getKind();
        if (kind.isSupplier()) {
            code.append("() -> ");
        }
        if (isOutput && !service.getService().isPublic() || !node.isPublic() && service.getService().isPublic()) {
            code.append("($T) ");
            args.add(service.getService().getCoordinate().getType());
        }
        code.append(node.isEager() ? "$N" : "$N()");
        args.add(node.getName());
    }

    private static void emitFragmentFields(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder builder, @Nonnull ComponentGraph graph) {
        for (FragmentNode node : graph.getFragments()) {
            ClassName type = StingGeneratorUtil.getGeneratedClassName(node.getFragment().getElement());
            FieldSpec.Builder field = FieldSpec.builder(type, node.getName(), Modifier.PRIVATE, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).initializer("new $T()", type);
            List<TypeMirror> types = Collections.singletonList(node.getFragment().getElement().asType());
            SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.emptyList(), types);
            builder.addField(field.build());
        }
    }
}

