/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import sting.processor.ComponentGraph;
import sting.processor.Coordinate;
import sting.processor.Edge;
import sting.processor.InjectorDescriptor;
import sting.processor.InputDescriptor;
import sting.processor.ServiceDescriptor;
import sting.processor.ServiceSpec;
import sting.processor.StingGeneratorUtil;
import sting.processor.StingProcessor;
import sting.processor.vendor.javapoet.ClassName;
import sting.processor.vendor.javapoet.MethodSpec;
import sting.processor.vendor.javapoet.ParameterSpec;
import sting.processor.vendor.javapoet.TypeName;
import sting.processor.vendor.javapoet.TypeSpec;
import sting.processor.vendor.proton.ElementsUtil;
import sting.processor.vendor.proton.GeneratorUtil;
import sting.processor.vendor.proton.SuppressWarningsUtil;

final class InjectorProviderGenerator {
    private InjectorProviderGenerator() {
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentGraph graph) {
        InjectorDescriptor injector = graph.getInjector();
        TypeElement element = injector.getElement();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder(GeneratorUtil.getGeneratedSimpleClassName(element, "Sting_", "_Provider")).addModifiers(Modifier.PUBLIC);
        GeneratorUtil.addOriginatingTypes(element, builder);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, StingProcessor.class.getName());
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)element, builder);
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, builder, Collections.emptyList(), Collections.singletonList(element.asType()));
        builder.addAnnotation(ClassName.get("sting", "Fragment", new String[0]));
        InjectorProviderGenerator.emitInjectorProvide(graph, builder);
        InjectorProviderGenerator.emitOutputProvides(processingEnv, graph, builder);
        return builder.build();
    }

    private static void emitInjectorProvide(@Nonnull ComponentGraph graph, @Nonnull TypeSpec.Builder builder) {
        InjectorDescriptor injector = graph.getInjector();
        TypeElement element = injector.getElement();
        MethodSpec.Builder method = MethodSpec.methodBuilder("provide").addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).addModifiers(Modifier.PUBLIC, Modifier.DEFAULT).returns(TypeName.get(element.asType()));
        List<InputDescriptor> inputs = graph.getInjector().getInputs();
        for (InputDescriptor input : inputs) {
            ServiceSpec service = input.getService();
            Coordinate coordinate = service.getCoordinate();
            ParameterSpec.Builder parameter = ParameterSpec.builder(TypeName.get(coordinate.getType()), input.getName(), Modifier.FINAL);
            if (!coordinate.getType().getKind().isPrimitive()) {
                parameter.addAnnotation(service.isOptional() ? GeneratorUtil.NULLABLE_CLASSNAME : GeneratorUtil.NONNULL_CLASSNAME);
            }
            method.addParameter(parameter.build());
        }
        method.addStatement("return new $T(" + inputs.stream().map(InputDescriptor::getName).collect(Collectors.joining(", ")) + ")", StingGeneratorUtil.getGeneratedClassName(element));
        builder.addMethod(method.build());
    }

    private static void emitOutputProvides(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentGraph graph, @Nonnull TypeSpec.Builder builder) {
        InjectorDescriptor injector = graph.getInjector();
        TypeElement element = injector.getElement();
        for (Edge edge : graph.getRootNode().getDependsOn()) {
            ServiceDescriptor service = edge.getService();
            if (ServiceDescriptor.Kind.INSTANCE != service.getKind()) continue;
            MethodSpec.Builder method = MethodSpec.methodBuilder(service.getElement().getSimpleName().toString()).addModifiers(Modifier.PUBLIC, Modifier.DEFAULT).returns(TypeName.get(service.getService().getCoordinate().getType())).addParameter(ParameterSpec.builder(TypeName.get(element.asType()), "injector", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)service.getElement(), method);
            ArrayList<String> additionalSuppressions = new ArrayList<String>();
            if (ElementsUtil.isElementDeprecated(service.getElement())) {
                additionalSuppressions.add("deprecation");
            }
            List<TypeMirror> types = Arrays.asList(element.asType(), service.getService().getCoordinate().getType());
            SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, additionalSuppressions, types);
            method.addStatement("return injector.$N()", service.getElement().getSimpleName().toString());
            builder.addMethod(method.build());
        }
    }
}

