/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.json.stream.JsonGenerator;
import sting.processor.Binding;
import sting.processor.ServiceSpec;

final class InputDescriptor {
    @Nonnull
    private final ServiceSpec _service;
    @Nonnull
    private final Binding _binding;
    @Nonnull
    private final String _name;

    InputDescriptor(@Nonnull ServiceSpec service, @Nonnull Binding binding, @Nonnull String name) {
        this._service = Objects.requireNonNull(service);
        this._binding = Objects.requireNonNull(binding);
        this._name = Objects.requireNonNull(name);
        this._binding.setOwner(this);
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    ServiceSpec getService() {
        return this._service;
    }

    @Nonnull
    Binding getBinding() {
        return this._binding;
    }

    void write(@Nonnull JsonGenerator g) {
        g.writeStartObject();
        this._service.write(g);
        g.writeEnd();
    }
}

