/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sting.processor.FragmentDescriptor;
import sting.processor.InjectableDescriptor;
import sting.processor.InjectorDescriptor;

final class Registry {
    @Nonnull
    private final Map<String, InjectableDescriptor> _injectables = new HashMap<String, InjectableDescriptor>();
    @Nonnull
    private final Map<String, FragmentDescriptor> _fragments = new HashMap<String, FragmentDescriptor>();
    @Nonnull
    private final List<InjectorDescriptor> _injectors = new ArrayList<InjectorDescriptor>();

    Registry() {
    }

    void registerInjectable(@Nonnull InjectableDescriptor injectable) {
        this._injectables.put(injectable.getElement().getQualifiedName().toString(), injectable);
    }

    @Nullable
    InjectableDescriptor findInjectableByClassName(@Nonnull String name) {
        return this._injectables.get(name);
    }

    @Nonnull
    InjectableDescriptor getInjectableByClassName(@Nonnull String name) {
        return Objects.requireNonNull(this.findInjectableByClassName(name));
    }

    @Nonnull
    Collection<InjectableDescriptor> getInjectables() {
        return this._injectables.values();
    }

    void registerFragment(@Nonnull FragmentDescriptor fragment) {
        this._fragments.put(fragment.getElement().getQualifiedName().toString(), fragment);
    }

    @Nullable
    FragmentDescriptor findFragmentByClassName(@Nonnull String name) {
        return this._fragments.get(name);
    }

    @Nonnull
    FragmentDescriptor getFragmentByClassName(@Nonnull String name) {
        return Objects.requireNonNull(this.findFragmentByClassName(name));
    }

    @Nonnull
    Collection<FragmentDescriptor> getFragments() {
        return this._fragments.values();
    }

    void registerInjector(@Nonnull InjectorDescriptor injector) {
        this._injectors.add(injector);
    }

    void deregisterInjector(@Nonnull InjectorDescriptor injector) {
        this._injectors.remove(injector);
    }

    @Nonnull
    List<InjectorDescriptor> getInjectors() {
        return this._injectors;
    }

    void clear() {
        this._injectables.clear();
        this._fragments.clear();
        this._injectors.clear();
    }
}

