/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sting.processor.Node;
import sting.processor.ServiceRequest;

final class Edge {
    @Nonnull
    private final Node _node;
    @Nonnull
    private final ServiceRequest _serviceRequest;
    @Nullable
    private Collection<Node> _satisfiedBy;

    Edge(@Nonnull Node node, @Nonnull ServiceRequest serviceRequest) {
        this._node = Objects.requireNonNull(node);
        this._serviceRequest = Objects.requireNonNull(serviceRequest);
    }

    void setSatisfiedBy(@Nonnull Collection<Node> satisfiedBy) {
        assert (!satisfiedBy.isEmpty() || this._serviceRequest.getService().isOptional() || this._serviceRequest.getKind().isCollection());
        this._satisfiedBy = satisfiedBy;
        for (Node node : satisfiedBy) {
            node.usedBy(this);
            node.setDepth(Math.min(this._node.getDepth() + 1, node.getDepth()));
        }
    }

    @Nonnull
    Node getNode() {
        return this._node;
    }

    @Nonnull
    ServiceRequest getServiceRequest() {
        return this._serviceRequest;
    }

    @Nonnull
    Collection<Node> getSatisfiedBy() {
        assert (null != this._satisfiedBy);
        assert (!this._satisfiedBy.isEmpty() || this._serviceRequest.getService().isOptional() || this._serviceRequest.getKind().isCollection());
        return this._satisfiedBy;
    }
}

