/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import sting.processor.AutoFragmentDescriptor;
import sting.processor.StingProcessor;
import sting.processor.vendor.javapoet.AnnotationSpec;
import sting.processor.vendor.javapoet.ClassName;
import sting.processor.vendor.javapoet.TypeSpec;
import sting.processor.vendor.proton.GeneratorUtil;
import sting.processor.vendor.proton.SuppressWarningsUtil;

final class AutoFragmentGenerator {
    private AutoFragmentGenerator() {
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull AutoFragmentDescriptor autoFragment) {
        TypeElement element = autoFragment.getElement();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder(GeneratorUtil.getGeneratedSimpleClassName(element, "Sting_", "_Fragment")).addModifiers(Modifier.PUBLIC);
        GeneratorUtil.addOriginatingTypes(element, builder);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, StingProcessor.class.getName());
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)element, builder);
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, builder, Collections.emptyList(), Collections.singletonList(element.asType()));
        AnnotationSpec.Builder annotation = AnnotationSpec.builder(ClassName.get("sting", "Fragment", new String[0]));
        List contributors = autoFragment.getContributors().stream().sorted(Comparator.comparing(e -> e.getQualifiedName().toString())).collect(Collectors.toList());
        for (TypeElement contributor : contributors) {
            annotation.addMember("includes", "$T.class", contributor.asType());
        }
        builder.addAnnotation(annotation.build());
        return builder.build();
    }
}

