/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import sting.processor.Binding;
import sting.processor.Coordinate;
import sting.processor.FragmentDescriptor;
import sting.processor.IncludeDescriptor;
import sting.processor.InjectableDescriptor;
import sting.processor.ServiceRequest;
import sting.processor.ServiceSpec;
import sting.processor.UnresolvedDeclaredTypeException;

final class DescriptorIO {
    private static final int FILE_HEADER = 8583;
    private static final int FILE_VERSION = 1;
    private static final int INJECTABLE_TAG = 0;
    private static final int FRAGMENT_TAG = 1;
    @Nonnull
    private final Elements _elements;
    @Nonnull
    private final Types _types;

    DescriptorIO(@Nonnull Elements elements, @Nonnull Types types) {
        this._elements = Objects.requireNonNull(elements);
        this._types = Objects.requireNonNull(types);
    }

    @Nonnull
    Object read(@Nonnull DataInputStream dis, @Nonnull String classname) throws IOException {
        Object descriptor;
        int header = dis.readInt();
        if (8583 != header) {
            throw new IOException("Descriptor for " + classname + " is in an incorrect format. Bad header.");
        }
        short version = dis.readShort();
        if (1 != version) {
            throw new IOException("Descriptor for " + classname + " is in an unknown version: " + version);
        }
        TypeElement typeElement = this._elements.getTypeElement(classname);
        assert (null != typeElement);
        byte tag = dis.readByte();
        if (1 == tag) {
            descriptor = this.readFragment(dis, typeElement);
        } else {
            assert (0 == tag);
            descriptor = this.readInjectable(dis, typeElement);
        }
        return descriptor;
    }

    void write(@Nonnull DataOutputStream dos, @Nonnull Object descriptor) throws IOException {
        dos.writeInt(8583);
        dos.writeShort(1);
        if (descriptor instanceof FragmentDescriptor) {
            dos.writeByte(1);
            this.writeFragment(dos, (FragmentDescriptor)descriptor);
        } else {
            assert (descriptor instanceof InjectableDescriptor);
            dos.writeByte(0);
            this.writeInjectable(dos, (InjectableDescriptor)descriptor);
        }
    }

    private void writeFragment(@Nonnull DataOutputStream dos, @Nonnull FragmentDescriptor fragment) throws IOException {
        Collection<IncludeDescriptor> includes = fragment.getIncludes();
        dos.writeShort(includes.size());
        for (IncludeDescriptor include : includes) {
            dos.writeUTF(this.toFieldDescriptor(include.getIncludedType()));
            dos.writeUTF(include.getActualTypeName());
        }
        Collection<Binding> bindings = fragment.getBindings();
        dos.writeShort(bindings.size());
        for (Binding binding : bindings) {
            this.writeBinding(dos, binding);
        }
    }

    @Nonnull
    private FragmentDescriptor readFragment(@Nonnull DataInputStream dis, @Nonnull TypeElement enclosingElement) throws IOException {
        short includeCount = dis.readShort();
        IncludeDescriptor[] types = new IncludeDescriptor[includeCount];
        for (int i = 0; i < types.length; ++i) {
            DeclaredType includedType = this.readDeclaredType(dis.readUTF());
            String actualTypeName = dis.readUTF();
            types[i] = new IncludeDescriptor(includedType, actualTypeName);
        }
        short bindingCount = dis.readShort();
        Binding[] bindings = new Binding[bindingCount];
        for (int i = 0; i < bindings.length; ++i) {
            bindings[i] = this.readBinding(dis, enclosingElement);
        }
        FragmentDescriptor fragment = new FragmentDescriptor(enclosingElement, Arrays.asList(types), Arrays.asList(bindings));
        fragment.markJavaStubAsGenerated();
        return fragment;
    }

    private void writeInjectable(@Nonnull DataOutputStream dos, @Nonnull InjectableDescriptor injectable) throws IOException {
        this.writeBinding(dos, injectable.getBinding());
    }

    @Nonnull
    private InjectableDescriptor readInjectable(@Nonnull DataInputStream dis, @Nonnull TypeElement enclosingElement) throws IOException {
        InjectableDescriptor injectable = new InjectableDescriptor(this.readBinding(dis, enclosingElement));
        injectable.markJavaStubAsGenerated();
        return injectable;
    }

    private void writeBinding(@Nonnull DataOutputStream dos, @Nonnull Binding binding) throws IOException {
        Binding.Kind kind = binding.getKind();
        dos.writeByte(kind.ordinal());
        dos.writeUTF(binding.getId());
        List<ServiceSpec> services = binding.getPublishedServices();
        dos.writeShort(services.size());
        for (ServiceSpec service : services) {
            Coordinate coordinate = service.getCoordinate();
            dos.writeUTF(coordinate.getQualifier());
            dos.writeUTF(this.toFieldDescriptor(coordinate.getType()));
            dos.writeBoolean(service.isOptional());
        }
        dos.writeBoolean(binding.isEager());
        dos.writeUTF(Binding.Kind.PROVIDES == kind ? binding.getElement().getSimpleName().toString() : "");
        ServiceRequest[] dependencies = binding.getDependencies();
        dos.writeShort(dependencies.length);
        for (ServiceRequest dependency : dependencies) {
            this.writeService(dos, dependency);
        }
    }

    @Nonnull
    private Binding readBinding(@Nonnull DataInputStream dis, @Nonnull TypeElement enclosingElement) throws IOException {
        Binding.Kind kind = Binding.Kind.values()[dis.readByte()];
        String id = dis.readUTF();
        int typeCount = dis.readShort();
        ServiceSpec[] specs = new ServiceSpec[typeCount];
        for (int i = 0; i < typeCount; ++i) {
            specs[i] = new ServiceSpec(this.readCoordinate(dis), dis.readBoolean());
        }
        boolean eager = dis.readBoolean();
        String elementName = dis.readUTF();
        assert ("".equals(elementName) || Binding.Kind.INJECTABLE != kind);
        ExecutableElement element = Binding.Kind.INJECTABLE != kind ? (ExecutableElement)enclosingElement.getEnclosedElements().stream().filter(e -> ElementKind.METHOD == e.getKind() && e.getSimpleName().toString().equals(elementName)).map(e -> (ExecutableElement)e).findAny().orElse(null) : (ExecutableElement)enclosingElement.getEnclosedElements().stream().filter(e -> ElementKind.CONSTRUCTOR == e.getKind()).map(e -> (ExecutableElement)e).findAny().orElse(null);
        assert (null != element);
        short dependencyCount = dis.readShort();
        ServiceRequest[] dependencies = new ServiceRequest[dependencyCount];
        for (int i = 0; i < dependencies.length; ++i) {
            dependencies[i] = this.readService(dis, element);
        }
        return new Binding(kind, id, Arrays.asList(specs), eager, element, dependencies);
    }

    private void writeService(@Nonnull DataOutputStream dos, @Nonnull ServiceRequest service) throws IOException {
        dos.writeByte(service.getKind().ordinal());
        this.writeCoordinate(dos, service.getService().getCoordinate());
        dos.writeBoolean(service.getService().isOptional());
        assert (ElementKind.PARAMETER == service.getElement().getKind());
        dos.writeShort(service.getParameterIndex());
    }

    @Nonnull
    private ServiceRequest readService(@Nonnull DataInputStream dis, @Nonnull Element enclosingElement) throws IOException {
        ServiceRequest.Kind type = ServiceRequest.Kind.values()[dis.readByte()];
        Coordinate coordinate = this.readCoordinate(dis);
        boolean optional = dis.readBoolean();
        short parameterIndex = dis.readShort();
        assert (-1 != parameterIndex);
        Element element = ((ExecutableElement)enclosingElement).getParameters().get(parameterIndex);
        assert (null != element);
        return new ServiceRequest(type, new ServiceSpec(coordinate, optional), element, parameterIndex);
    }

    private void writeCoordinate(@Nonnull DataOutputStream dos, @Nonnull Coordinate coordinate) throws IOException {
        dos.writeUTF(coordinate.getQualifier());
        dos.writeUTF(this.toFieldDescriptor(coordinate.getType()));
    }

    @Nonnull
    private Coordinate readCoordinate(@Nonnull DataInputStream dis) throws IOException {
        String qualifier = dis.readUTF();
        String type = dis.readUTF();
        return new Coordinate(qualifier, this.fromFieldDescriptor(type));
    }

    @Nonnull
    private String toFieldDescriptor(@Nonnull TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        switch (kind) {
            case BOOLEAN: {
                return "Z";
            }
            case CHAR: {
                return "C";
            }
            case BYTE: {
                return "B";
            }
            case SHORT: {
                return "S";
            }
            case INT: {
                return "I";
            }
            case LONG: {
                return "J";
            }
            case FLOAT: {
                return "F";
            }
            case DOUBLE: {
                return "D";
            }
        }
        assert (TypeKind.DECLARED == kind);
        return "L" + this._elements.getBinaryName((TypeElement)this._types.asElement(typeMirror)) + ";";
    }

    @Nonnull
    private TypeMirror fromFieldDescriptor(@Nonnull String descriptor) throws IOException {
        switch (descriptor) {
            case "Z": {
                return this._types.getPrimitiveType(TypeKind.BOOLEAN);
            }
            case "C": {
                return this._types.getPrimitiveType(TypeKind.CHAR);
            }
            case "B": {
                return this._types.getPrimitiveType(TypeKind.BYTE);
            }
            case "S": {
                return this._types.getPrimitiveType(TypeKind.SHORT);
            }
            case "I": {
                return this._types.getPrimitiveType(TypeKind.INT);
            }
            case "J": {
                return this._types.getPrimitiveType(TypeKind.LONG);
            }
            case "F": {
                return this._types.getPrimitiveType(TypeKind.FLOAT);
            }
            case "D": {
                return this._types.getPrimitiveType(TypeKind.DOUBLE);
            }
        }
        return this.readDeclaredType(descriptor);
    }

    @Nonnull
    private DeclaredType readDeclaredType(@Nonnull String descriptor) throws IOException {
        assert (descriptor.startsWith("L"));
        assert (descriptor.endsWith(";"));
        String classname = descriptor.substring(1, descriptor.length() - 1).replace("$", ".");
        TypeElement typeElement = this._elements.getTypeElement(classname);
        if (null == typeElement) {
            throw new UnresolvedDeclaredTypeException("Descriptor references declared type " + descriptor + " but that type is not on the classpath or has not yet been compiled");
        }
        return (DeclaredType)typeElement.asType();
    }
}

