/*
 * Decompiled with CFR 0.152.
 */
package sting.processor.vendor.proton;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import sting.processor.vendor.javapoet.AnnotationSpec;
import sting.processor.vendor.javapoet.FieldSpec;
import sting.processor.vendor.javapoet.MethodSpec;
import sting.processor.vendor.javapoet.ParameterSpec;
import sting.processor.vendor.javapoet.TypeSpec;
import sting.processor.vendor.proton.ElementsUtil;

public final class SuppressWarningsUtil {
    private SuppressWarningsUtil() {
    }

    @Nonnull
    public static AnnotationSpec suppressWarningsAnnotation(String ... warnings) {
        return Objects.requireNonNull(SuppressWarningsUtil.maybeSuppressWarningsAnnotation(warnings));
    }

    @Nullable
    public static AnnotationSpec maybeSuppressWarningsAnnotation(String ... warnings) {
        List<String> actualWarnings = Arrays.stream(warnings).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (actualWarnings.isEmpty()) {
            return null;
        }
        AnnotationSpec.Builder builder = AnnotationSpec.builder(SuppressWarnings.class);
        actualWarnings.forEach(w -> builder.addMember("value", "$S", w));
        return builder.build();
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder method, @Nonnull TypeMirror type) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, Collections.singleton(type));
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder method, @Nonnull Collection<TypeMirror> types) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, Collections.emptyList(), types);
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder method, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        AnnotationSpec suppress = SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, additionalSuppressions, types);
        if (null != suppress) {
            method.addAnnotation(suppress);
        }
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull MethodSpec.Builder method, @Nonnull TypeMirror type) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, Collections.singleton(type));
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull MethodSpec.Builder method, @Nonnull Collection<TypeMirror> types) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, Collections.emptyList(), types);
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull MethodSpec.Builder method, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        AnnotationSpec suppress = SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, additionalSuppressions, types);
        if (null != suppress) {
            method.addAnnotation(suppress);
        }
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull FieldSpec.Builder field, @Nonnull TypeMirror type) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.singleton(type));
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull FieldSpec.Builder field, @Nonnull Collection<TypeMirror> types) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.emptyList(), types);
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull FieldSpec.Builder field, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        AnnotationSpec suppress = SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, additionalSuppressions, types);
        if (null != suppress) {
            field.addAnnotation(suppress);
        }
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ParameterSpec.Builder field, @Nonnull TypeMirror type) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.singleton(type));
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ParameterSpec.Builder field, @Nonnull Collection<TypeMirror> types) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.emptyList(), types);
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ParameterSpec.Builder field, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        AnnotationSpec suppress = SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, additionalSuppressions, types);
        if (null != suppress) {
            field.addAnnotation(suppress);
        }
    }

    @Nullable
    public static AnnotationSpec maybeSuppressWarningsAnnotation(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Collection<TypeMirror> types) {
        return SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, Collections.emptyList(), types);
    }

    @Nullable
    public static AnnotationSpec maybeSuppressWarningsAnnotation(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        boolean hasDeprecatedTypes;
        boolean hasRawTypes = additionalSuppressions.contains("rawtypes") || types.stream().anyMatch(t -> SuppressWarningsUtil.hasRawTypes(processingEnv, t));
        boolean bl = hasDeprecatedTypes = additionalSuppressions.contains("deprecation") || types.stream().anyMatch(t -> SuppressWarningsUtil.hasDeprecatedTypes(processingEnv, t));
        if (hasRawTypes || hasDeprecatedTypes || !additionalSuppressions.isEmpty()) {
            ArrayList<String> suppressions = new ArrayList<String>(additionalSuppressions);
            if (hasRawTypes) {
                suppressions.add("rawtypes");
            }
            if (hasDeprecatedTypes) {
                suppressions.add("deprecation");
            }
            return SuppressWarningsUtil.suppressWarningsAnnotation((String[])suppressions.stream().sorted().distinct().toArray(String[]::new));
        }
        return null;
    }

    private static boolean hasDeprecatedTypes(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeMirror type) {
        TypeKind kind = type.getKind();
        if (TypeKind.TYPEVAR == kind) {
            TypeVariable typeVariable = (TypeVariable)type;
            return SuppressWarningsUtil.hasDeprecatedTypes(processingEnv, typeVariable.getLowerBound()) || SuppressWarningsUtil.hasDeprecatedTypes(processingEnv, typeVariable.getUpperBound());
        }
        if (TypeKind.ARRAY == kind) {
            return SuppressWarningsUtil.hasDeprecatedTypes(processingEnv, ((ArrayType)type).getComponentType());
        }
        if (TypeKind.DECLARED == kind) {
            if (SuppressWarningsUtil.isElementDeprecated(processingEnv, type)) {
                return true;
            }
            DeclaredType declaredType = (DeclaredType)type;
            return declaredType.getTypeArguments().stream().anyMatch(t -> SuppressWarningsUtil.hasDeprecatedTypes(processingEnv, t));
        }
        if (TypeKind.EXECUTABLE == kind) {
            ExecutableType executableType = (ExecutableType)type;
            return SuppressWarningsUtil.isElementDeprecated(processingEnv, executableType) || SuppressWarningsUtil.hasDeprecatedTypes(processingEnv, executableType.getReturnType()) || executableType.getTypeVariables().stream().anyMatch(t -> SuppressWarningsUtil.hasDeprecatedTypes(processingEnv, t)) || executableType.getThrownTypes().stream().anyMatch(t -> SuppressWarningsUtil.hasDeprecatedTypes(processingEnv, t)) || executableType.getParameterTypes().stream().anyMatch(t -> SuppressWarningsUtil.hasDeprecatedTypes(processingEnv, t));
        }
        return false;
    }

    private static boolean isElementDeprecated(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeMirror type) {
        Element element = processingEnv.getTypeUtils().asElement(type);
        return null != element && SuppressWarningsUtil.isElementDeprecated(element);
    }

    private static boolean isElementDeprecated(@Nonnull Element element) {
        if (ElementsUtil.isElementDeprecated(element)) {
            return true;
        }
        if ((element.getKind().isClass() || element.getKind().isInterface()) && ElementKind.PACKAGE != element.getEnclosingElement().getKind()) {
            return SuppressWarningsUtil.isElementDeprecated(element.getEnclosingElement());
        }
        return false;
    }

    private static boolean hasRawTypes(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeMirror type) {
        TypeKind kind = type.getKind();
        if (TypeKind.TYPEVAR == kind) {
            TypeVariable typeVariable = (TypeVariable)type;
            return SuppressWarningsUtil.hasRawTypes(processingEnv, typeVariable.getLowerBound()) || SuppressWarningsUtil.hasRawTypes(processingEnv, typeVariable.getUpperBound());
        }
        if (TypeKind.ARRAY == kind) {
            return SuppressWarningsUtil.hasRawTypes(processingEnv, ((ArrayType)type).getComponentType());
        }
        if (TypeKind.DECLARED == kind) {
            TypeElement typeElement;
            DeclaredType declaredType = (DeclaredType)type;
            int typeArgumentCount = declaredType.getTypeArguments().size();
            if (typeArgumentCount != (typeElement = (TypeElement)processingEnv.getTypeUtils().asElement(type)).getTypeParameters().size()) {
                return true;
            }
            return declaredType.getTypeArguments().stream().anyMatch(t -> SuppressWarningsUtil.hasRawTypes(processingEnv, t));
        }
        if (TypeKind.EXECUTABLE == kind) {
            ExecutableType executableType = (ExecutableType)type;
            return SuppressWarningsUtil.hasRawTypes(processingEnv, executableType.getReturnType()) || executableType.getTypeVariables().stream().anyMatch(t -> SuppressWarningsUtil.hasRawTypes(processingEnv, t)) || executableType.getThrownTypes().stream().anyMatch(t -> SuppressWarningsUtil.hasRawTypes(processingEnv, t)) || executableType.getParameterTypes().stream().anyMatch(t -> SuppressWarningsUtil.hasRawTypes(processingEnv, t));
        }
        return false;
    }
}

