/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sting.processor.ComponentGraph;
import sting.processor.Edge;
import sting.processor.Node;
import sting.processor.PathEntry;
import sting.processor.vendor.proton.ProcessorException;

final class CircularDependencyChecker {
    private CircularDependencyChecker() {
    }

    static void verifyNoCircularDependencyLoops(@Nonnull ComponentGraph graph) {
        HashSet<Node> completed = new HashSet<Node>();
        CircularDependencyChecker.verifyNoCircularDependenciesForRootNode(graph, graph.getRootNode(), completed);
        for (Node node : graph.getNodes()) {
            if (!node.getUsedBy().isEmpty()) continue;
            CircularDependencyChecker.verifyNoCircularDependenciesForRootNode(graph, node, completed);
        }
    }

    private static void verifyNoCircularDependenciesForRootNode(@Nonnull ComponentGraph graph, @Nonnull Node node, @Nonnull Set<Node> completed) {
        Stack<PathEntry> stack = new Stack<PathEntry>();
        PathEntry entry = new PathEntry(node, null);
        CircularDependencyChecker.verifyNoCircularDependenciesForNode(graph, entry, stack, completed);
        assert (stack.isEmpty());
    }

    private static void verifyNoCircularDependenciesForNode(@Nonnull ComponentGraph graph, @Nonnull PathEntry entry, @Nonnull Stack<PathEntry> stack, @Nonnull Set<Node> completed) {
        stack.add(entry);
        for (Edge edge : entry.getNode().getDependsOn()) {
            for (Node node : edge.getSatisfiedBy()) {
                int indexOfMatching;
                PathEntry childEntry = new PathEntry(node, edge);
                int n = indexOfMatching = CircularDependencyChecker.doesEdgeBreakDependencyChain(edge) ? -1 : CircularDependencyChecker.detectCircularDependency(stack, node);
                if (-1 != indexOfMatching) {
                    throw new ProcessorException("Injector contains a circular dependency.\nPath:\n" + CircularDependencyChecker.describeCircularDependencyPath(stack, childEntry), graph.getInjector().getElement());
                }
                if (completed.contains(node)) continue;
                completed.add(entry.getNode());
                int size = stack.size();
                CircularDependencyChecker.verifyNoCircularDependenciesForNode(graph, childEntry, stack, completed);
                assert (size == stack.size());
            }
        }
        stack.pop();
    }

    private static int detectCircularDependency(@Nonnull Stack<PathEntry> stack, @Nonnull Node node) {
        for (int index = stack.size() - 1; index > 0; --index) {
            PathEntry entry = (PathEntry)stack.get(index);
            if (CircularDependencyChecker.doesEdgeBreakDependencyChain(entry.getEdge())) {
                return -1;
            }
            if (entry.getNode() != node) continue;
            return index - 1;
        }
        return -1;
    }

    private static boolean doesEdgeBreakDependencyChain(@Nullable Edge edge) {
        return null == edge || edge.getServiceRequest().getKind().isSupplier();
    }

    @Nonnull
    private static String describeCircularDependencyPath(@Nonnull Stack<PathEntry> stack, @Nonnull PathEntry badEntry) {
        StringBuilder sb = new StringBuilder();
        boolean matched = false;
        for (PathEntry entry : stack) {
            String connector;
            Node node = entry.getNode();
            if (node == badEntry.getNode()) {
                connector = "+-<";
                matched = true;
            } else {
                connector = matched ? "|  " : "   ";
            }
            sb.append(node.describe(connector));
            sb.append("\n");
        }
        sb.append(badEntry.getNode().describe("+->"));
        sb.append("\n");
        return sb.toString();
    }
}

