/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.json.stream.JsonGenerator;
import javax.lang.model.element.TypeElement;
import sting.processor.Binding;
import sting.processor.Coordinate;

final class InjectableDescriptor {
    @Nonnull
    private final Binding _binding;
    private boolean _javaStubGenerated;

    InjectableDescriptor(@Nonnull Binding binding) {
        this._binding = Objects.requireNonNull(binding);
        this._binding.setOwner(this);
    }

    boolean isAutoDiscoverable() {
        if (1 != this._binding.getPublishedServices().size()) {
            return false;
        }
        Coordinate coordinate = this._binding.getPublishedServices().get(0).getCoordinate();
        return coordinate.getQualifier().isEmpty() && coordinate.getType().toString().equals(this.getElement().asType().toString());
    }

    @Nonnull
    TypeElement getElement() {
        return (TypeElement)this._binding.getElement().getEnclosingElement();
    }

    @Nonnull
    Binding getBinding() {
        return this._binding;
    }

    boolean isJavaStubGenerated() {
        return this._javaStubGenerated;
    }

    void markJavaStubAsGenerated() {
        this._javaStubGenerated = true;
    }

    void write(@Nonnull JsonGenerator g) {
        g.writeStartObject();
        g.write("schema", "injectable/1");
        this._binding.write(g);
        g.writeEnd();
    }
}

