/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Objects;
import java.util.Stack;
import javax.annotation.Nonnull;
import sting.processor.Node;
import sting.processor.PathEntry;

final class WorkEntry {
    @Nonnull
    private final PathEntry _entry;
    @Nonnull
    private final Stack<PathEntry> _stack;

    WorkEntry(@Nonnull PathEntry entry, @Nonnull Stack<PathEntry> stack) {
        this._entry = Objects.requireNonNull(entry);
        this._stack = Objects.requireNonNull(stack);
    }

    @Nonnull
    PathEntry getEntry() {
        return this._entry;
    }

    @Nonnull
    Stack<PathEntry> getStack() {
        return this._stack;
    }

    @Nonnull
    String describePathFromRoot() {
        StringBuilder sb = new StringBuilder();
        int size = this._stack.size();
        for (int i = 0; i < size; ++i) {
            PathEntry entry = (PathEntry)this._stack.get(i);
            Node node = entry.getNode();
            String connector = node.hasNoBinding() ? "   " : (size - 1 == i ? " * " : "   ");
            sb.append(node.describe(connector));
            sb.append("\n");
        }
        return sb.toString();
    }
}

