/*
 * Decompiled with CFR 0.152.
 */
package sting.processor.vendor.proton;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import sting.processor.vendor.javapoet.TypeSpec;
import sting.processor.vendor.proton.DeferredElementSet;
import sting.processor.vendor.proton.ElementsUtil;
import sting.processor.vendor.proton.GeneratorUtil;
import sting.processor.vendor.proton.ProcessorException;
import sting.processor.vendor.proton.SuperficialValidation;

public abstract class AbstractStandardProcessor
extends AbstractProcessor {
    private boolean _verboseOutOfRoundErrors;
    private boolean _deferErrors;
    private boolean _deferUnresolved;
    private boolean _debug;
    private int _invalidTypeCount;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this._verboseOutOfRoundErrors = this.readBooleanOption("verbose_out_of_round.errors", true);
        this._deferErrors = this.readBooleanOption("defer.errors", true);
        this._deferUnresolved = this.readBooleanOption("defer.unresolved", true);
        this._debug = this.readBooleanOption("debug", false);
    }

    protected final void processTypeElements(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env, @Nonnull String annotationClassname, @Nonnull DeferredElementSet deferredTypes, @Nonnull Action<TypeElement> action) {
        Collection<TypeElement> newElementsToProcess = this.getNewTypeElementsToProcess(annotations, env, annotationClassname);
        if (!deferredTypes.getDeferred().isEmpty() || !newElementsToProcess.isEmpty()) {
            this.processTypeElements(env, deferredTypes, newElementsToProcess, action);
        }
    }

    protected final Collection<TypeElement> getNewTypeElementsToProcess(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env, @Nonnull String annotationClassname) {
        return annotations.stream().filter(a -> a.getQualifiedName().toString().equals(annotationClassname)).findAny().map(a -> env.getElementsAnnotatedWith((TypeElement)a)).orElse(Collections.emptyList());
    }

    private void processTypeElements(@Nonnull RoundEnvironment env, @Nonnull DeferredElementSet deferredSet, @Nonnull Collection<TypeElement> elements, @Nonnull Action<TypeElement> action) {
        if (this.shouldDeferUnresolved()) {
            Collection<TypeElement> elementsToProcess = this.deriveElementsToProcess(deferredSet, elements);
            this.doProcessTypeElements(env, elementsToProcess, action);
            this.errorIfProcessingOverAndDeferredTypesUnprocessed(env, deferredSet);
        } else {
            this.doProcessTypeElements(env, new ArrayList<TypeElement>(elements), action);
        }
    }

    private void errorIfProcessingOverAndDeferredTypesUnprocessed(@Nonnull RoundEnvironment env, @Nonnull DeferredElementSet deferredSet) {
        Set<TypeElement> deferred = deferredSet.getDeferred();
        if ((env.processingOver() || env.errorRaised()) && !deferred.isEmpty()) {
            deferred.forEach(e -> this.processingErrorMessage(env, (TypeElement)e));
            deferredSet.clear();
        }
    }

    protected final void errorIfProcessingOverAndInvalidTypesDetected(@Nonnull RoundEnvironment env) {
        if (env.processingOver()) {
            if (0 != this._invalidTypeCount) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getSimpleName() + " failed to process " + this._invalidTypeCount + " types. See earlier warnings for further details.");
            }
            this._invalidTypeCount = 0;
        }
    }

    protected boolean shouldDeferUnresolved() {
        return this._deferUnresolved;
    }

    @Nonnull
    protected abstract String getIssueTrackerURL();

    @Nonnull
    protected abstract String getOptionPrefix();

    private void processingErrorMessage(@Nonnull RoundEnvironment env, @Nonnull TypeElement target) {
        this.reportError(env, this.getClass().getSimpleName() + " unable to process " + target.getQualifiedName() + " because not all of its dependencies could be resolved. Check for compilation errors or a circular dependency with generated code.", target);
    }

    protected final void reportError(@Nonnull RoundEnvironment env, @Nonnull String message, @Nullable Element element) {
        this.reportError(env, message, element, null, null);
    }

    protected final void reportError(@Nonnull RoundEnvironment env, @Nonnull String message, @Nullable Element element, @Nullable AnnotationMirror annotation, @Nullable AnnotationValue annotationValue) {
        Diagnostic.Kind kind;
        ++this._invalidTypeCount;
        Diagnostic.Kind kind2 = kind = !this._deferErrors || env.errorRaised() || env.processingOver() ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
        if (null != annotationValue) {
            this.processingEnv.getMessager().printMessage(kind, message, element, annotation, annotationValue);
        } else if (null != annotation) {
            this.processingEnv.getMessager().printMessage(kind, message, element, annotation);
        } else {
            this.processingEnv.getMessager().printMessage(kind, message, element);
        }
    }

    private void doProcessTypeElements(@Nonnull RoundEnvironment env, @Nonnull Collection<TypeElement> elements, @Nonnull Action<TypeElement> action) {
        for (TypeElement element : elements) {
            this.performAction(env, action, element);
        }
    }

    protected final <E extends Element> void performAction(@Nonnull RoundEnvironment env, @Nonnull Action<E> action, @Nonnull E element) {
        this.debug(() -> "Performing processing action on element " + element);
        try {
            action.process(element);
        }
        catch (IOException ioe) {
            String message = "IO error running the " + this.getClass().getName() + " processor. This has resulted in a failure to process the code and has left the compiler in an invalid state.\n\n\n" + this.printStackTrace(ioe);
            this.reportError(env, message, element);
        }
        catch (ProcessorException e) {
            Element errorLocation = e.getElement();
            if (this._verboseOutOfRoundErrors) {
                Element outerElement = ElementsUtil.getTopLevelElement(errorLocation);
                if (!env.getRootElements().contains(outerElement)) {
                    String location;
                    if (errorLocation instanceof ExecutableElement) {
                        ExecutableElement executableElement = (ExecutableElement)errorLocation;
                        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
                        location = typeElement.getQualifiedName() + "." + executableElement.getSimpleName();
                    } else if (errorLocation instanceof VariableElement) {
                        VariableElement variableElement = (VariableElement)errorLocation;
                        Element enclosingElement = variableElement.getEnclosingElement();
                        if (enclosingElement instanceof TypeElement) {
                            TypeElement typeElement = (TypeElement)enclosingElement;
                            location = typeElement.getQualifiedName() + "." + variableElement.getSimpleName();
                        } else {
                            ExecutableElement executableElement = (ExecutableElement)enclosingElement;
                            TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
                            location = typeElement.getQualifiedName() + "." + executableElement.getSimpleName() + "(..." + variableElement.getSimpleName() + "...)";
                        }
                    } else {
                        assert (errorLocation instanceof TypeElement);
                        TypeElement typeElement = (TypeElement)errorLocation;
                        location = typeElement.getQualifiedName().toString();
                    }
                    StringWriter sw = new StringWriter();
                    this.processingEnv.getElementUtils().printElements(sw, errorLocation);
                    sw.flush();
                    String message = "An error was generated processing the element " + element.getSimpleName() + " but the error was triggered by code not currently being compiled but inherited or implemented by the element and may not be highlighted by your tooling or IDE. The error occurred at " + location + " and may look like:\n" + sw.toString();
                    this.reportError(env, message, element);
                }
            }
            this.reportError(env, e.getMessage(), e.getElement(), e.getAnnotation(), e.getAnnotationValue());
        }
        catch (Throwable e) {
            String message = "There was an unexpected error running the " + this.getClass().getName() + " processor. This has resulted in a failure to process the code and has left the compiler in an invalid state. If you believe this is an error with the " + this.getClass().getName() + " processor then please report the failure to the developers so that it can be fixed.\n Report the error at: " + this.getIssueTrackerURL() + "\n\n\n" + this.printStackTrace(e);
            this.reportError(env, message, element);
        }
    }

    @Nonnull
    private String printStackTrace(@Nonnull Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sw.flush();
        return sw.toString();
    }

    @Nonnull
    private Collection<TypeElement> deriveElementsToProcess(@Nonnull DeferredElementSet deferredSet, @Nonnull Collection<TypeElement> elements) {
        List<TypeElement> deferred = deferredSet.extractDeferred(this.processingEnv);
        ArrayList<TypeElement> elementsToProcess = new ArrayList<TypeElement>();
        this.collectElementsToProcess(elements, deferredSet, elementsToProcess);
        int scheduledFromThisRound = elementsToProcess.size();
        int deferredFromThisRound = deferredSet.getDeferred().size();
        this.debug(() -> scheduledFromThisRound + " elements from this round scheduled for processing, " + deferredFromThisRound + " elements from this round deferred for processing in a later round");
        this.collectElementsToProcess(deferred, deferredSet, elementsToProcess);
        int scheduledFromPreviousRounds = elementsToProcess.size() - scheduledFromThisRound;
        int deferredFromPreviousRounds = deferredSet.getDeferred().size() - deferredFromThisRound;
        this.debug(() -> scheduledFromPreviousRounds + " elements from previous rounds scheduled for processing, " + deferredFromPreviousRounds + " elements from previous rounds deferred for processing in a later round");
        return elementsToProcess;
    }

    private void collectElementsToProcess(@Nonnull Collection<TypeElement> elements, @Nonnull DeferredElementSet deferredSet, @Nonnull List<TypeElement> elementsToProcess) {
        for (TypeElement element : elements) {
            if (SuperficialValidation.validateElement(this.processingEnv, element)) {
                this.debug(() -> "Scheduling element " + element + " for processing");
                elementsToProcess.add(element);
                continue;
            }
            this.debug(() -> "Deferring element " + element + " for processing in a later round as it failed superficial validation");
            deferredSet.deferElement(element);
        }
    }

    protected final boolean isDebugEnabled() {
        return this._debug;
    }

    protected final void debug(@Nonnull Supplier<String> messageSupplier) {
        if (this.isDebugEnabled()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, messageSupplier.get());
        }
    }

    protected final void emitTypeSpec(@Nonnull String packageName, @Nonnull TypeSpec typeSpec) throws IOException {
        GeneratorUtil.emitJavaType(packageName, typeSpec, this.processingEnv.getFiler());
    }

    protected final boolean readBooleanOption(@Nonnull String relativeKey, boolean defaultValue) {
        String optionValue = this.processingEnv.getOptions().get(this.getOptionPrefix() + "." + relativeKey);
        return null == optionValue ? defaultValue : "true".equals(optionValue);
    }

    @FunctionalInterface
    public static interface Action<E extends Element> {
        public void process(@Nonnull E var1) throws Exception;
    }
}

