/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import sting.processor.Binding;
import sting.processor.FragmentDescriptor;
import sting.processor.StingGeneratorUtil;
import sting.processor.StingProcessor;
import sting.processor.vendor.javapoet.MethodSpec;
import sting.processor.vendor.javapoet.TypeName;
import sting.processor.vendor.javapoet.TypeSpec;
import sting.processor.vendor.proton.ElementsUtil;
import sting.processor.vendor.proton.GeneratorUtil;
import sting.processor.vendor.proton.SuppressWarningsUtil;

final class FragmentGenerator {
    private FragmentGenerator() {
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull FragmentDescriptor fragment) {
        TypeElement element = fragment.getElement();
        TypeSpec.Builder builder = TypeSpec.classBuilder(StingGeneratorUtil.getGeneratedClassName(element)).addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        GeneratorUtil.addOriginatingTypes(element, builder);
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)element, builder);
        TypeMirror type = element.asType();
        builder.addSuperinterface(TypeName.get(type));
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, StingProcessor.class.getName());
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, builder, Collections.emptyList(), Collections.singletonList(type));
        for (Binding binding : fragment.getBindings()) {
            builder.addMethod(FragmentGenerator.buildProvidesStub(processingEnv, binding));
        }
        return builder.build();
    }

    @Nonnull
    private static MethodSpec buildProvidesStub(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Binding binding) {
        ExecutableElement element = (ExecutableElement)binding.getElement();
        TypeMirror returnType = element.getReturnType();
        boolean isPublic = TypeKind.DECLARED != returnType.getKind() || ElementsUtil.isEffectivelyPublic((TypeElement)((DeclaredType)returnType).asElement());
        MethodSpec.Builder method = MethodSpec.methodBuilder(StingGeneratorUtil.getFragmentProvidesStubName(element)).addModifiers(Modifier.PUBLIC).returns(isPublic ? TypeName.get(returnType) : TypeName.OBJECT);
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)element, method);
        StringBuilder code = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        code.append("return $N");
        args.add(element.getSimpleName().toString());
        return StingGeneratorUtil.buildBindingCreator(processingEnv, method, code, args, returnType, binding);
    }
}

