/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.json.stream.JsonGenerator;
import javax.lang.model.type.TypeMirror;

final class Coordinate {
    @Nonnull
    private final String _qualifier;
    @Nonnull
    private final TypeMirror _type;

    Coordinate(@Nonnull String qualifier, @Nonnull TypeMirror type) {
        this._qualifier = Objects.requireNonNull(qualifier);
        this._type = Objects.requireNonNull(type);
    }

    @Nonnull
    String getQualifier() {
        return this._qualifier;
    }

    @Nonnull
    TypeMirror getType() {
        return this._type;
    }

    void write(@Nonnull JsonGenerator g) {
        if (!this._qualifier.isEmpty()) {
            g.write("qualifier", this._qualifier);
        }
        g.write("type", this._type.toString());
    }

    public String toString() {
        return "[" + this._type + (this._qualifier.isEmpty() ? "" : ";qualifier='" + this._qualifier + "'") + "]";
    }

    public boolean equals(Object o) {
        assert (o instanceof Coordinate);
        Coordinate coordinate = (Coordinate)o;
        return this._qualifier.equals(coordinate._qualifier) && this._type.toString().equals(coordinate._type.toString());
    }

    public int hashCode() {
        return Objects.hash(this._qualifier, this._type.toString());
    }
}

