/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.json.stream.JsonGenerator;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import sting.processor.Coordinate;
import sting.processor.vendor.proton.ElementsUtil;

final class ServiceSpec {
    @Nonnull
    private final Coordinate _coordinate;
    private final boolean _optional;

    ServiceSpec(@Nonnull Coordinate coordinate, boolean optional) {
        this._coordinate = Objects.requireNonNull(coordinate);
        this._optional = optional;
    }

    @Nonnull
    Coordinate getCoordinate() {
        return this._coordinate;
    }

    boolean isOptional() {
        return this._optional;
    }

    boolean isRequired() {
        return !this.isOptional();
    }

    boolean isPublic() {
        TypeMirror type = this._coordinate.getType();
        return TypeKind.DECLARED != type.getKind() || ElementsUtil.isEffectivelyPublic((TypeElement)((DeclaredType)type).asElement());
    }

    void write(@Nonnull JsonGenerator g) {
        this._coordinate.write(g);
        if (this._optional) {
            g.write("optional", true);
        }
    }

    public String toString() {
        return this._coordinate.toString() + (this._optional ? "?" : "");
    }
}

