/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import sting.processor.Binding;
import sting.processor.ServiceRequest;
import sting.processor.vendor.javapoet.ClassName;
import sting.processor.vendor.javapoet.MethodSpec;
import sting.processor.vendor.javapoet.ParameterSpec;
import sting.processor.vendor.javapoet.ParameterizedTypeName;
import sting.processor.vendor.javapoet.TypeName;
import sting.processor.vendor.proton.ElementsUtil;
import sting.processor.vendor.proton.GeneratorUtil;
import sting.processor.vendor.proton.SuppressWarningsUtil;

final class StingGeneratorUtil {
    @Nonnull
    static final String FRAMEWORK_PREFIX = "$sting$_";
    @Nonnull
    private static final ClassName COLLECTION = ClassName.get(Collection.class);
    @Nonnull
    private static final ClassName SUPPLIER = ClassName.get(Supplier.class);

    private StingGeneratorUtil() {
    }

    static TypeName getServiceType(@Nonnull ServiceRequest serviceRequest) {
        ServiceRequest.Kind kind = serviceRequest.getKind();
        TypeName baseType = TypeName.get(serviceRequest.getService().getCoordinate().getType());
        if (ServiceRequest.Kind.INSTANCE == kind) {
            return baseType;
        }
        if (ServiceRequest.Kind.SUPPLIER == kind) {
            return ParameterizedTypeName.get(SUPPLIER, baseType);
        }
        if (ServiceRequest.Kind.COLLECTION == kind) {
            return ParameterizedTypeName.get(COLLECTION, baseType);
        }
        assert (ServiceRequest.Kind.SUPPLIER_COLLECTION == kind);
        return ParameterizedTypeName.get(COLLECTION, ParameterizedTypeName.get(SUPPLIER, baseType));
    }

    @Nonnull
    static MethodSpec buildBindingCreator(@Nonnull ProcessingEnvironment processingEnv, @Nonnull MethodSpec.Builder method, @Nonnull StringBuilder code, @Nonnull List<Object> args, @Nonnull TypeMirror typeProduced, @Nonnull Binding binding) {
        ServiceRequest[] dependencies = binding.getDependencies();
        ArrayList<TypeMirror> typesProcessed = new ArrayList<TypeMirror>();
        typesProcessed.add(typeProduced);
        code.append("(");
        if (0 != dependencies.length) {
            code.append(' ');
        }
        boolean allPublic = true;
        boolean anyNonPublicNonInstance = false;
        boolean firstParam = true;
        for (ServiceRequest service : dependencies) {
            boolean requireNonNull;
            TypeName paramType;
            VariableElement parameter = (VariableElement)service.getElement();
            String paramName = parameter.getSimpleName().toString();
            typesProcessed.add(service.getService().getCoordinate().getType());
            boolean isPublic = service.getService().isPublic();
            allPublic &= isPublic;
            TypeName actualTypeName = StingGeneratorUtil.getServiceType(service);
            ServiceRequest.Kind kind = service.getKind();
            if (isPublic) {
                paramType = actualTypeName;
            } else if (ServiceRequest.Kind.INSTANCE == kind) {
                paramType = TypeName.OBJECT;
            } else if (ServiceRequest.Kind.SUPPLIER == kind) {
                anyNonPublicNonInstance = true;
                paramType = SUPPLIER;
            } else if (ServiceRequest.Kind.COLLECTION == kind) {
                anyNonPublicNonInstance = true;
                paramType = COLLECTION;
            } else {
                assert (ServiceRequest.Kind.SUPPLIER_COLLECTION == kind);
                anyNonPublicNonInstance = true;
                paramType = COLLECTION;
            }
            ParameterSpec.Builder param = ParameterSpec.builder(paramType, paramName, Modifier.FINAL);
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)parameter, param);
            method.addParameter(param.build());
            if (!firstParam) {
                code.append(", ");
            }
            firstParam = false;
            boolean bl = requireNonNull = !service.getService().isOptional() && !typeProduced.getKind().isPrimitive();
            if (requireNonNull) {
                code.append("$T.requireNonNull( ");
                args.add(Objects.class);
            }
            if (!isPublic) {
                code.append("($T) ");
                args.add(actualTypeName);
            }
            code.append("$N");
            args.add(paramName);
            if (!requireNonNull) continue;
            code.append(" )");
        }
        if (0 != dependencies.length) {
            code.append(' ');
        }
        code.append(")");
        method.addStatement(code.toString(), args.toArray());
        ArrayList<String> additionalSuppressions = new ArrayList<String>();
        if (!allPublic) {
            additionalSuppressions.add("unchecked");
        }
        if (anyNonPublicNonInstance) {
            additionalSuppressions.add("rawtypes");
        }
        if (ElementsUtil.isDeprecated(binding.getElement())) {
            additionalSuppressions.add("deprecation");
        }
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, additionalSuppressions, typesProcessed);
        return method.build();
    }

    @Nonnull
    static ClassName getGeneratedClassName(@Nonnull TypeElement element) {
        return GeneratorUtil.getGeneratedClassName(element, "Sting_", "");
    }

    @Nonnull
    static String getFragmentProvidesStubName(@Nonnull ExecutableElement element) {
        return FRAMEWORK_PREFIX + element.getSimpleName().toString();
    }
}

