/*
 * Decompiled with CFR 0.152.
 */
package sting.processor.vendor.proton;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.lang.model.element.Element;
import sting.processor.vendor.proton.ResourceUtil;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static void writeJsonResource(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Element element, @Nonnull String filename, @Nonnull Consumer<JsonGenerator> action) throws IOException {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(properties);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator g = generatorFactory.createGenerator((OutputStream)baos);
        action.accept(g);
        g.close();
        ResourceUtil.writeResource(processingEnv, filename, JsonUtil.formatJson(baos.toString()), element);
    }

    @Nonnull
    public static String formatJson(@Nonnull String input) {
        return input.replaceAll("(?m)^ {4}([^ ])", "  $1").replaceAll("(?m)^ {8}([^ ])", "    $1").replaceAll("(?m)^ {12}([^ ])", "      $1").replaceAll("(?m)^ {16}([^ ])", "        $1").replaceAll("(?m)^ {20}([^ ])", "          $1").replaceAll("(?m)^ {24}([^ ])", "            $1").replaceAll("(?m)^ {28}([^ ])", "              $1").replaceAll("(?m)^ {32}([^ ])", "                $1").replaceAll("(?m)^\n\\[\n", "[\n").replaceAll("(?m)^\n\\{\n", "{\n") + "\n";
    }
}

