/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import sting.processor.ComponentGraph;
import sting.processor.Coordinate;
import sting.processor.Edge;
import sting.processor.Node;
import sting.processor.ServiceRequest;
import sting.processor.ServiceSpec;

final class InjectorDotReportGenerator {
    private InjectorDotReportGenerator() {
    }

    @Nonnull
    static String buildDotReport(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentGraph graph) {
        Map<String, Set<String>> types = InjectorDotReportGenerator.buildTypeMap(graph);
        StringBuilder sb = new StringBuilder();
        String injectorName = InjectorDotReportGenerator.extractShortestUniqueName(types, graph.getInjector().getElement().asType().toString());
        sb.append("digraph \"").append(injectorName).append("\" {\n").append("  overlap = false\n").append("  splines = true\n");
        sb.append("  injector [label=\"").append(injectorName).append("\",color=green];\n");
        for (Node node : graph.getRawNodeCollection()) {
            String qualifier;
            sb.append("  ").append(node.getName()).append(" [label=\"").append(InjectorDotReportGenerator.extractShortestUniqueName(types, node.getType().toString()));
            List<ServiceSpec> services = node.getBinding().getPublishedServices();
            if (!services.isEmpty() && !"".equals(qualifier = services.get(0).getCoordinate().getQualifier())) {
                sb.append("/").append(qualifier);
            }
            sb.append("\"");
            if (node.isEager()) {
                sb.append(",color=blue");
            }
            sb.append("];\n");
        }
        InjectorDotReportGenerator.emitDependencyLinks(processingEnv, types, sb, graph.getRootNode(), "injector");
        for (Node node : graph.getRawNodeCollection()) {
            InjectorDotReportGenerator.emitDependencyLinks(processingEnv, types, sb, node, node.getName());
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static void emitDependencyLinks(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Map<String, Set<String>> types, @Nonnull StringBuilder sb, @Nonnull Node node, @Nonnull String fromName) {
        for (Edge edge : node.getDependsOn()) {
            InjectorDotReportGenerator.emitNodeLinks(processingEnv, types, sb, edge, fromName);
        }
    }

    private static void emitNodeLinks(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Map<String, Set<String>> types, @Nonnull StringBuilder sb, @Nonnull Edge edge, @Nonnull String fromName) {
        for (Node other : edge.getSatisfiedBy()) {
            InjectorDotReportGenerator.emitNodeLink(processingEnv, types, sb, edge, other, fromName);
        }
    }

    private static void emitNodeLink(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Map<String, Set<String>> types, @Nonnull StringBuilder sb, @Nonnull Edge edge, @Nonnull Node toNode, @Nonnull String fromName) {
        ServiceRequest.Kind kind;
        sb.append("  ").append(fromName).append(" -> ").append(toNode.getName()).append(" [");
        boolean hasAttributes = false;
        ServiceRequest serviceRequest = edge.getServiceRequest();
        ServiceSpec service = serviceRequest.getService();
        Coordinate coordinate = service.getCoordinate();
        TypeMirror serviceType = coordinate.getType();
        if (!processingEnv.getTypeUtils().isSameType(serviceType, toNode.getType())) {
            sb.append("label=\"").append(InjectorDotReportGenerator.extractShortestUniqueName(types, serviceType.toString()));
            String qualifier = coordinate.getQualifier();
            if (!"".equals(qualifier)) {
                sb.append("/").append(qualifier);
            }
            sb.append("\"");
            hasAttributes = true;
        }
        if (service.isOptional()) {
            if (hasAttributes) {
                sb.append(",");
            }
            sb.append("style=dotted");
            hasAttributes = true;
        }
        if ((kind = serviceRequest.getKind()).isCollection() && kind.isSupplier()) {
            if (hasAttributes) {
                sb.append(",");
            }
            sb.append("dir=both, arrowtail=odot, arrowhead=crow");
            hasAttributes = true;
        } else if (kind.isCollection()) {
            if (hasAttributes) {
                sb.append(",");
            }
            sb.append("dir=both, arrowtail=normal, arrowhead=crow");
            hasAttributes = true;
        } else if (kind.isSupplier()) {
            if (hasAttributes) {
                sb.append(",");
            }
            sb.append("arrowhead=odot");
            hasAttributes = true;
        }
        sb.append("];\n");
    }

    @Nonnull
    private static Map<String, Set<String>> buildTypeMap(@Nonnull ComponentGraph graph) {
        HashMap<String, Set<String>> types = new HashMap<String, Set<String>>();
        for (Node node : graph.getRawNodeCollection()) {
            InjectorDotReportGenerator.recordType(types, node.getType().toString());
            InjectorDotReportGenerator.recordDependencyTypes(types, node);
        }
        InjectorDotReportGenerator.recordType(types, graph.getInjector().getElement().asType().toString());
        InjectorDotReportGenerator.recordDependencyTypes(types, graph.getRootNode());
        return types;
    }

    private static void recordDependencyTypes(@Nonnull Map<String, Set<String>> types, @Nonnull Node node) {
        for (Edge edge : node.getDependsOn()) {
            InjectorDotReportGenerator.recordType(types, edge.getServiceRequest().getService().getCoordinate().getType().toString());
        }
    }

    private static void recordType(@Nonnull Map<String, Set<String>> types, @Nonnull String type) {
        types.computeIfAbsent(InjectorDotReportGenerator.extractSimpleName(type), v -> new HashSet()).add(type);
    }

    @Nonnull
    private static String extractShortestUniqueName(@Nonnull Map<String, Set<String>> types, @Nonnull String typeName) {
        String simpleName = InjectorDotReportGenerator.extractSimpleName(typeName);
        Set<String> matches = types.get(simpleName);
        if (1 == matches.size()) {
            return simpleName;
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(simpleName);
        boolean matched = true;
        int offset = 1;
        while (matched) {
            String match = null;
            for (String type : matches) {
                String[] typeParts = type.split("\\.");
                if (typeParts.length <= offset) {
                    match = null;
                    matched = false;
                    break;
                }
                if (null == match) {
                    match = typeParts[typeParts.length - 1 - offset];
                    continue;
                }
                if (match.equals(typeParts[typeParts.length - 1 - offset])) continue;
                match = null;
                matched = false;
                break;
            }
            if (null == match) continue;
            parts.add(0, match);
            ++offset;
        }
        String[] typeParts = typeName.split("\\.");
        parts.add(0, typeParts[typeParts.length - 1 - offset]);
        return "..." + String.join((CharSequence)".", parts);
    }

    @Nonnull
    private static String extractSimpleName(@Nonnull String type) {
        String[] parts = type.split("\\.");
        return parts[parts.length - 1];
    }
}

