/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.json.stream.JsonGenerator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import sting.processor.FragmentDescriptor;
import sting.processor.InjectableDescriptor;
import sting.processor.InputDescriptor;
import sting.processor.ServiceRequest;
import sting.processor.ServiceSpec;

final class Binding {
    @Nonnull
    private final Kind _kind;
    @Nonnull
    private final String _id;
    private final boolean _eager;
    @Nonnull
    private final Element _element;
    @Nonnull
    private final ServiceRequest[] _dependencies;
    @Nonnull
    private final List<ServiceSpec> _publishedServices;
    private final boolean _optional;
    private Object _owner;

    Binding(@Nonnull Kind kind, @Nonnull String id, @Nonnull List<ServiceSpec> publishedServices, boolean eager, @Nonnull Element element, @Nonnull ServiceRequest[] dependencies) {
        assert (Kind.INPUT == kind && ElementKind.INTERFACE == element.getKind() || Kind.INJECTABLE == kind && ElementKind.CONSTRUCTOR == element.getKind() || Kind.PROVIDES == kind && ElementKind.METHOD == element.getKind());
        this._kind = Objects.requireNonNull(kind);
        this._id = Objects.requireNonNull(id);
        this._publishedServices = Objects.requireNonNull(publishedServices);
        this._eager = eager;
        this._element = Objects.requireNonNull(element);
        this._dependencies = Objects.requireNonNull(dependencies);
        this._optional = this._publishedServices.stream().anyMatch(ServiceSpec::isOptional);
        assert (this._optional && this._publishedServices.stream().allMatch(ServiceSpec::isOptional) || !this._optional && this._publishedServices.stream().allMatch(ServiceSpec::isRequired));
        assert (Kind.INJECTABLE != kind || this._publishedServices.stream().allMatch(ServiceSpec::isRequired));
    }

    @Nonnull
    Object getOwner() {
        assert (null != this._owner);
        return this._owner;
    }

    @Nonnull
    Kind getKind() {
        return this._kind;
    }

    @Nonnull
    String getId() {
        return this._id;
    }

    @Nonnull
    List<ServiceSpec> getPublishedServices() {
        return this._publishedServices;
    }

    boolean isEager() {
        return this._eager;
    }

    boolean isOptional() {
        return this._optional;
    }

    boolean isRequired() {
        return !this.isOptional();
    }

    @Nonnull
    Element getElement() {
        return this._element;
    }

    @Nonnull
    ServiceRequest[] getDependencies() {
        return this._dependencies;
    }

    void write(@Nonnull JsonGenerator g) {
        g.write("id", this._id);
        if (!this._publishedServices.isEmpty()) {
            g.writeStartArray("publishedServices");
            for (ServiceSpec service : this._publishedServices) {
                g.writeStartObject();
                service.write(g);
                g.writeEnd();
            }
            g.writeEnd();
        }
        if (this._eager) {
            g.write("eager", this._eager);
        }
        if (this._dependencies.length > 0) {
            g.writeStartArray("dependencies");
            for (ServiceRequest dependency : this._dependencies) {
                dependency.write(g);
            }
            g.writeEnd();
        }
    }

    void setOwner(@Nonnull Object owner) {
        assert (null == this._owner);
        assert (owner instanceof InputDescriptor && Kind.INPUT == this._kind || owner instanceof InjectableDescriptor && Kind.INJECTABLE == this._kind || owner instanceof FragmentDescriptor && Kind.PROVIDES == this._kind);
        this._owner = owner;
    }

    @Nonnull
    String describe() {
        if (Kind.INPUT == this._kind) {
            InputDescriptor input = (InputDescriptor)this._owner;
            return ((TypeElement)this._element).getQualifiedName().toString() + "." + input.getName() + "/" + input.getService();
        }
        if (Kind.INJECTABLE == this._kind) {
            return ((TypeElement)this._element.getEnclosingElement()).getQualifiedName().toString();
        }
        assert (Kind.PROVIDES == this._kind);
        return ((TypeElement)this._element.getEnclosingElement()).getQualifiedName().toString() + "." + this._element.getSimpleName();
    }

    @Nonnull
    String getTypeLabel() {
        if (Kind.INPUT == this._kind) {
            return "[Input]      ";
        }
        if (Kind.INJECTABLE == this._kind) {
            return "[Injectable] ";
        }
        assert (Kind.PROVIDES == this._kind);
        return "[Provides]   ";
    }

    static enum Kind {
        INPUT,
        INJECTABLE,
        PROVIDES;

    }
}

