/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import sting.processor.AutoFragmentDescriptor;
import sting.processor.AutoFragmentGenerator;
import sting.processor.Binding;
import sting.processor.CircularDependencyChecker;
import sting.processor.ComponentGraph;
import sting.processor.ContributorDescriptor;
import sting.processor.Coordinate;
import sting.processor.DescriptorIO;
import sting.processor.Edge;
import sting.processor.FragmentDescriptor;
import sting.processor.FragmentGenerator;
import sting.processor.IncludeDescriptor;
import sting.processor.InjectableDescriptor;
import sting.processor.InjectableGenerator;
import sting.processor.InjectorDescriptor;
import sting.processor.InjectorDotReportGenerator;
import sting.processor.InjectorGenerator;
import sting.processor.InjectorProviderGenerator;
import sting.processor.InputDescriptor;
import sting.processor.Node;
import sting.processor.PathEntry;
import sting.processor.ProviderEntry;
import sting.processor.Registry;
import sting.processor.ResolveType;
import sting.processor.ServiceRequest;
import sting.processor.ServiceSpec;
import sting.processor.UnresolvedDeclaredTypeException;
import sting.processor.WorkEntry;
import sting.processor.vendor.proton.AbstractStandardProcessor;
import sting.processor.vendor.proton.AnnotationsUtil;
import sting.processor.vendor.proton.DeferredElementSet;
import sting.processor.vendor.proton.ElementsUtil;
import sting.processor.vendor.proton.GeneratorUtil;
import sting.processor.vendor.proton.IOUtil;
import sting.processor.vendor.proton.JsonUtil;
import sting.processor.vendor.proton.MemberChecks;
import sting.processor.vendor.proton.ProcessorException;
import sting.processor.vendor.proton.ResourceUtil;
import sting.processor.vendor.proton.StopWatch;
import sting.processor.vendor.proton.SuperficialValidation;
import sting.processor.vendor.proton.TypesUtil;

@SupportedAnnotationTypes(value={"sting.Injector", "sting.InjectorFragment", "sting.Injectable", "sting.Fragment", "sting.Eager", "sting.Typed", "sting.Named", "sting.AutoFragment", "sting.ContributeTo"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"sting.defer.unresolved", "sting.defer.errors", "sting.debug", "sting.profile", "sting.emit_json_descriptors", "sting.emit_dot_reports", "sting.verbose_out_of_round.errors", "sting.verify_descriptors"})
public final class StingProcessor
extends AbstractStandardProcessor {
    static final String JSON_SUFFIX = ".sting.json";
    static final String DOT_SUFFIX = ".gv";
    static final String SUFFIX = ".sbf";
    static final String GRAPH_SUFFIX = "__ObjectGraph.sting.json";
    @Nonnull
    private final Registry _registry = new Registry();
    @Nonnull
    private final DeferredElementSet _deferredInjectableTypes = new DeferredElementSet();
    @Nonnull
    private final DeferredElementSet _deferredFragmentTypes = new DeferredElementSet();
    @Nonnull
    private final DeferredElementSet _deferredInjectorTypes = new DeferredElementSet();
    @Nonnull
    private final DeferredElementSet _deferredInjectorFragmentTypes = new DeferredElementSet();
    @Nonnull
    private final StopWatch _analyzeInjectableStopWatch = new StopWatch("Analyze Injectable");
    @Nonnull
    private final StopWatch _analyzeFragmentStopWatch = new StopWatch("Analyze Fragment");
    @Nonnull
    private final StopWatch _analyzeInjectorFragmentStopWatch = new StopWatch("Analyze Injector Fragment");
    @Nonnull
    private final StopWatch _analyzeInjectorStopWatch = new StopWatch("Analyze Injector");
    @Nonnull
    private final StopWatch _analyzeAutoFragmentStopWatch = new StopWatch("Analyze Auto-Fragment");
    @Nonnull
    private final StopWatch _analyzeContributeToStopWatch = new StopWatch("Analyze ContributeTo");
    @Nonnull
    private final StopWatch _generateAutoFragmentImplStopWatch = new StopWatch("Generate AutoFragment Impl");
    @Nonnull
    private final StopWatch _generateInjectableStubStopWatch = new StopWatch("Generate Injectable Stub");
    @Nonnull
    private final StopWatch _generateFragmentStubStopWatch = new StopWatch("Generate Fragment Stub");
    @Nonnull
    private final StopWatch _generateInjectorImplStopWatch = new StopWatch("Generate Injector Impl");
    private boolean _emitJsonDescriptors;
    private boolean _verifyDescriptors;
    private DescriptorIO _descriptorIO;
    private boolean _emitDotReports;

    @Override
    @Nonnull
    protected String getIssueTrackerURL() {
        return "https://github.com/sting-ioc/sting/issues";
    }

    @Override
    @Nonnull
    protected String getOptionPrefix() {
        return "sting";
    }

    @Override
    public synchronized void init(@Nonnull ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this._descriptorIO = new DescriptorIO(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
        this._emitJsonDescriptors = this.readBooleanOption("emit_json_descriptors", false);
        this._emitDotReports = this.readBooleanOption("emit_dot_reports", false);
        this._verifyDescriptors = this.readBooleanOption("verify_descriptors", false);
    }

    @Override
    protected void collectStopWatches(@Nonnull Collection<StopWatch> stopWatches) {
        stopWatches.add(this._analyzeInjectableStopWatch);
        stopWatches.add(this._analyzeFragmentStopWatch);
        stopWatches.add(this._analyzeInjectorFragmentStopWatch);
        stopWatches.add(this._analyzeInjectorStopWatch);
        stopWatches.add(this._analyzeAutoFragmentStopWatch);
        stopWatches.add(this._analyzeContributeToStopWatch);
        stopWatches.add(this._generateAutoFragmentImplStopWatch);
        stopWatches.add(this._generateInjectableStubStopWatch);
        stopWatches.add(this._generateFragmentStubStopWatch);
        stopWatches.add(this._generateInjectorImplStopWatch);
    }

    @Override
    public boolean process(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env) {
        this.debugAnnotationProcessingRootElements(env);
        this.collectRootTypeNames(env);
        this._registry.getAutoFragments().forEach(AutoFragmentDescriptor::resetModified);
        this.processAutoFragments(annotations, env);
        this.processTypeElements(annotations, env, "sting.Injectable", this._deferredInjectableTypes, "Analyze Injectable", this::processInjectable, this._analyzeInjectableStopWatch);
        this.processTypeElements(annotations, env, "sting.Fragment", this._deferredFragmentTypes, "Analyze Fragment", this::processFragment, this._analyzeFragmentStopWatch);
        this.processContributeTos(annotations, env);
        annotations.stream().filter(a -> a.getQualifiedName().toString().equals("sting.Named")).findAny().ifPresent(a -> this.verifyNamedElements(env, env.getElementsAnnotatedWith((TypeElement)a)));
        annotations.stream().filter(a -> a.getQualifiedName().toString().equals("sting.Typed")).findAny().ifPresent(a -> this.verifyTypedElements(env, env.getElementsAnnotatedWith((TypeElement)a)));
        annotations.stream().filter(a -> a.getQualifiedName().toString().equals("sting.Eager")).findAny().ifPresent(a -> this.verifyEagerElements(env, env.getElementsAnnotatedWith((TypeElement)a)));
        this.processTypeElements(annotations, env, "sting.InjectorFragment", this._deferredInjectorFragmentTypes, "Analyze Injector Fragment", this::processInjectorFragment, this._analyzeInjectorFragmentStopWatch);
        this.processTypeElements(annotations, env, "sting.Injector", this._deferredInjectorTypes, "Analyze Injector", this::processInjector, this._analyzeInjectorStopWatch);
        this.processUnmodifiedAutoFragment(env);
        this.processResolvedInjectables(env);
        this.processResolvedFragments(env);
        this.processResolvedInjectors(env);
        this.errorIfProcessingOverAndInvalidTypesDetected(env);
        this.errorIfProcessingOverAndUnprocessedInjectorDetected(env);
        this.errorIfProcessingOverAndUnprocessedAutoFragmentsDetected(env);
        this.errorIfProcessingOverAndUnprocessedContributeTosDetected(env);
        if (env.processingOver() || env.errorRaised()) {
            this._registry.clear();
        }
        this.clearRootTypeNamesIfProcessingOver(env);
        this.reportProfilerTimings();
        return true;
    }

    private void processAutoFragments(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env) {
        Collection<TypeElement> autoFragments = this.getNewTypeElementsToProcess(annotations, env, "sting.AutoFragment");
        for (TypeElement element : autoFragments) {
            this.performAction(env, "Analyze Auto-Fragment", this::processAutoFragment, element, this._analyzeAutoFragmentStopWatch);
        }
    }

    private void processContributeTos(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env) {
        Collection<TypeElement> contributeTos = this.getNewTypeElementsToProcess(annotations, env, "sting.ContributeTo");
        for (TypeElement element : contributeTos) {
            this.performAction(env, "Analyze ContributeTo", this::processContributeTo, element, this._analyzeContributeToStopWatch);
        }
    }

    private void errorIfProcessingOverAndUnprocessedAutoFragmentsDetected(@Nonnull RoundEnvironment env) {
        Collection autoFragments;
        if (env.processingOver() && !env.errorRaised() && !(autoFragments = (Collection)this._registry.getAutoFragments().stream().filter(a -> !a.isFragmentGenerated()).collect(Collectors.toList())).isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getSimpleName() + " failed to process " + autoFragments.size() + " @AutoFragment annotated types as the fragments either contained no contributors or only had contributors added in the last annotation processor round which is not supported by the @AutoFragment annotation. If the problem is not obvious, consider passing the annotation option sting.debug=true");
            for (AutoFragmentDescriptor autoFragment : autoFragments) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to process the " + autoFragment.getElement().getQualifiedName() + " @AutoFragment as 0 @ContributeTo annotations reference the @AutoFragment");
            }
        }
    }

    private void errorIfProcessingOverAndUnprocessedContributeTosDetected(@Nonnull RoundEnvironment env) {
        Collection contributorKeys;
        if (env.processingOver() && !env.errorRaised() && !(contributorKeys = (Collection)this._registry.getContributorKeys().stream().filter(key -> null == this._registry.findAutoFragmentByKey((String)key)).collect(Collectors.toList())).isEmpty()) {
            for (String contributorKey : contributorKeys) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to process the @ContributeTo contributors for key '" + contributorKey + "' as no associated @AutoFragment is on the class path. Impacted contributors included: " + this._registry.getContributorsByKey(contributorKey).stream().map(c -> c.getElement().getQualifiedName()).collect(Collectors.joining(", ")));
            }
        }
    }

    private void errorIfProcessingOverAndUnprocessedInjectorDetected(@Nonnull RoundEnvironment env) {
        List<InjectorDescriptor> injectors;
        if (env.processingOver() && !env.errorRaised() && !(injectors = this._registry.getInjectors()).isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getSimpleName() + " failed to process " + injectors.size() + " injectors as not all of their dependencies could be resolved. The java code resolved but the descriptors were missing or in the incorrect format. Ensure that the included typed have been compiled with a compatible version of Sting and that the .sbf descriptors have been packaged with the .class files. If the problem is not obvious, consider passing the annotation option sting.debug=true");
            for (InjectorDescriptor injector : injectors) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to process the " + injector.getElement().getQualifiedName() + " injector.");
            }
        }
    }

    private void processUnmodifiedAutoFragment(@Nonnull RoundEnvironment env) {
        for (AutoFragmentDescriptor autoFragment : new ArrayList<AutoFragmentDescriptor>(this._registry.getAutoFragments())) {
            if (autoFragment.isModified() || autoFragment.getContributors().isEmpty()) {
                this.debug(() -> "Defer generation for the auto-fragment " + autoFragment.getElement().getQualifiedName() + " as it " + (autoFragment.isModified() ? "has been modified in the current round" : "has zero contributors"));
                continue;
            }
            if (autoFragment.isFragmentGenerated()) continue;
            this.performAction(env, "Generate AutoFragment Impl", e -> {
                autoFragment.markFragmentGenerated();
                boolean autoDiscoverableContributors = autoFragment.getContributors().stream().map(ContributorDescriptor::getElement).map(c -> this._registry.findInjectableByClassName(c.getQualifiedName().toString())).filter(Objects::nonNull).anyMatch(c -> !c.getBinding().isEager() && c.isAutoDiscoverable());
                if (autoDiscoverableContributors) {
                    autoFragment.markAsAutoDiscoverableContributors();
                }
                this.debug(() -> "Emitting AutoFragment implementation for " + autoFragment.getElement().getQualifiedName());
                String packageName = GeneratorUtil.getQualifiedPackageName(autoFragment.getElement());
                this.emitTypeSpec(packageName, AutoFragmentGenerator.buildType(this.processingEnv, autoFragment));
            }, autoFragment.getElement(), this._generateAutoFragmentImplStopWatch);
        }
    }

    private void processResolvedInjectables(@Nonnull RoundEnvironment env) {
        for (InjectableDescriptor injectable : new ArrayList<InjectableDescriptor>(this._registry.getInjectables())) {
            if (injectable.isJavaStubGenerated()) continue;
            this.performAction(env, "Generate Injectable Stub", e -> {
                injectable.markJavaStubAsGenerated();
                this.writeBinaryDescriptor(injectable.getElement(), injectable);
                this.emitInjectableJsonDescriptor(injectable);
                this.emitInjectableStub(injectable);
            }, injectable.getElement(), this._generateInjectableStubStopWatch);
        }
    }

    private void emitInjectableStub(@Nonnull InjectableDescriptor injectable) throws IOException {
        this.debug(() -> "Emitting injectable stub for the injectable " + injectable.getElement().getQualifiedName());
        String packageName = GeneratorUtil.getQualifiedPackageName(injectable.getElement());
        this.emitTypeSpec(packageName, InjectableGenerator.buildType(this.processingEnv, injectable));
    }

    private void processResolvedFragments(@Nonnull RoundEnvironment env) {
        ArrayList deferred = new ArrayList();
        ArrayList<FragmentDescriptor> current = new ArrayList<FragmentDescriptor>(this._registry.getFragments());
        AtomicBoolean resolvedType = new AtomicBoolean();
        while (!current.isEmpty()) {
            for (FragmentDescriptor fragment : current) {
                if (fragment.isJavaStubGenerated() || fragment.containsError()) continue;
                this.performAction(env, "Generate Fragment Stub", e -> {
                    ResolveType resolveType = this.isFragmentResolved(env, fragment);
                    if (ResolveType.RESOLVED == resolveType) {
                        fragment.markJavaStubAsGenerated();
                        this.writeBinaryDescriptor(fragment.getElement(), fragment);
                        this.emitFragmentJsonDescriptor(fragment);
                        this.emitFragmentStub(fragment);
                    } else if (ResolveType.MAYBE_UNRESOLVED == resolveType) {
                        this.debug(() -> "The fragment " + fragment.getElement().getQualifiedName() + " has resolved java types but unresolved descriptors. Deferring processing until later in the round");
                        deferred.add(fragment);
                    } else {
                        this.debug(() -> "Defer generation for the fragment " + fragment.getElement().getQualifiedName() + " as it is not yet resolved");
                    }
                }, fragment.getElement(), this._generateFragmentStubStopWatch);
            }
            current.clear();
            if (!resolvedType.get()) break;
            current.addAll(deferred);
            deferred.clear();
        }
    }

    @Nonnull
    private ResolveType isFragmentReady(@Nonnull RoundEnvironment env, @Nonnull FragmentDescriptor fragment) {
        if (fragment.containsError()) {
            return ResolveType.UNRESOLVED;
        }
        return this.isFragmentResolved(env, fragment);
    }

    private void emitFragmentStub(@Nonnull FragmentDescriptor fragment) throws IOException {
        this.debug(() -> "Emitting fragment stub for the fragment " + fragment.getElement().getQualifiedName());
        String packageName = GeneratorUtil.getQualifiedPackageName(fragment.getElement());
        this.emitTypeSpec(packageName, FragmentGenerator.buildType(this.processingEnv, fragment));
    }

    private void processResolvedInjectors(@Nonnull RoundEnvironment env) {
        ArrayList deferred = new ArrayList();
        ArrayList<InjectorDescriptor> current = new ArrayList<InjectorDescriptor>(this._registry.getInjectors());
        AtomicBoolean resolvedType = new AtomicBoolean();
        while (!current.isEmpty()) {
            for (InjectorDescriptor injector : current) {
                if (injector.containsError()) continue;
                this.performAction(env, "Generate Injector Impl", e -> {
                    ResolveType resolveType = this.isInjectorResolved(env, injector);
                    if (ResolveType.RESOLVED == resolveType) {
                        this._registry.deregisterInjector(injector);
                        this.buildAndEmitObjectGraph(injector);
                        resolvedType.set(true);
                    } else if (ResolveType.MAYBE_UNRESOLVED == resolveType) {
                        this.debug(() -> "The injector " + injector.getElement().getQualifiedName() + " has resolved java types but unresolved descriptors. Deferring processing until later in the round");
                        deferred.add(injector);
                    } else {
                        this.debug(() -> "Defer generation for the injector " + injector.getElement().getQualifiedName() + " as it is not yet resolved");
                    }
                }, injector.getElement(), this._generateInjectorImplStopWatch);
            }
            current.clear();
            if (!resolvedType.get()) break;
            resolvedType.set(false);
            current.addAll(deferred);
            deferred.clear();
        }
    }

    private void buildAndEmitObjectGraph(@Nonnull InjectorDescriptor injector) throws Exception {
        this.debug(() -> "Preparing to build component graph for the injector " + injector.getElement().getQualifiedName());
        ComponentGraph graph = new ComponentGraph(injector);
        this.registerIncludesComponents(graph);
        this.registerInputs(graph);
        this.debug(() -> "Building component graph for the injector " + injector.getElement().getQualifiedName());
        this.buildObjectGraphNodes(graph);
        if (graph.getNodes().isEmpty() && graph.getRootNode().getDependsOn().isEmpty()) {
            throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector") + " target produced an empty object graph. This means that there are no eager nodes in the includes and there are no dependencies or only unsatisfied optional dependencies defined by the injector", graph.getInjector().getElement());
        }
        this.debug(() -> "Propagating eager-ness for the injector " + injector.getElement().getQualifiedName());
        this.propagateEagerFlagUpstream(graph);
        this.debug(() -> "Verifying no circular dependencies for the injector " + injector.getElement().getQualifiedName());
        CircularDependencyChecker.verifyNoCircularDependencyLoops(graph);
        Set actualBindings = graph.getNodes().stream().map(Node::getBinding).collect(Collectors.toSet());
        for (Map.Entry<IncludeDescriptor, Set<Binding>> entry : graph.getIncludeRootToBindingMap().entrySet()) {
            if (!entry.getValue().stream().noneMatch(actualBindings::contains)) continue;
            IncludeDescriptor includeRoot = entry.getKey();
            throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector") + " must not include type " + includeRoot.getIncludedType() + " when the type is not used within the graph", graph.getInjector().getElement());
        }
        this.emitObjectGraphJsonDescriptor(graph);
        String packageName = GeneratorUtil.getQualifiedPackageName(graph.getInjector().getElement());
        this.debug(() -> "Emitting injector implementation for the injector " + graph.getInjector().getElement().getQualifiedName());
        this.emitTypeSpec(packageName, InjectorGenerator.buildType(this.processingEnv, graph));
        if (injector.isInjectable()) {
            this.debug(() -> "Emitting injector provider for the injector " + graph.getInjector().getElement().getQualifiedName());
            this.emitTypeSpec(packageName, InjectorProviderGenerator.buildType(this.processingEnv, graph));
        }
        this.emitDotReport(graph);
    }

    private void emitDotReport(@Nonnull ComponentGraph graph) throws IOException {
        if (this._emitDotReports) {
            TypeElement element = graph.getInjector().getElement();
            String filename = this.toFilename(element) + DOT_SUFFIX;
            this.debug(() -> "Emitting .dot report for the injector " + graph.getInjector().getElement().getQualifiedName());
            String report = InjectorDotReportGenerator.buildDotReport(this.processingEnv, graph);
            ResourceUtil.writeResource(this.processingEnv, filename, report, element);
        }
    }

    private void registerInputs(@Nonnull ComponentGraph graph) {
        for (InputDescriptor input : graph.getInjector().getInputs()) {
            graph.registerInput(input);
        }
    }

    private void propagateEagerFlagUpstream(@Nonnull ComponentGraph graph) {
        graph.getNodes().stream().filter(n -> n.getBinding().isEager()).forEach(Node::markNodeAndUpstreamAsEager);
    }

    private void registerIncludesComponents(@Nonnull ComponentGraph graph) {
        this.registerIncludes(graph, null, graph.getInjector().getIncludes());
    }

    private void registerIncludes(@Nonnull ComponentGraph graph, @Nullable IncludeDescriptor includeRoot, @Nonnull Collection<IncludeDescriptor> includes) {
        for (IncludeDescriptor include : includes) {
            String classname = include.getActualTypeName();
            if (this.isDebugEnabled() && include.isProvider()) {
                this.debug(() -> "Registering include " + classname + " via provider " + include.getIncludedType() + " into graph " + graph.getInjector().getElement().getQualifiedName());
            } else {
                this.debug(() -> "Registering include " + classname + " into graph " + graph.getInjector().getElement().getQualifiedName());
            }
            IncludeDescriptor root = null == includeRoot ? include : includeRoot;
            TypeElement element = this.processingEnv.getElementUtils().getTypeElement(classname);
            assert (null != element);
            String qualifiedName = element.getQualifiedName().toString();
            if (AnnotationsUtil.hasAnnotationOfType(element, "sting.Fragment")) {
                FragmentDescriptor fragment = this._registry.getFragmentByClassName(qualifiedName);
                this.registerIncludes(graph, root, fragment.getIncludes());
                graph.registerFragment(root, fragment);
                continue;
            }
            assert (AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable"));
            InjectableDescriptor injectable = this._registry.getInjectableByClassName(qualifiedName);
            graph.registerInjectable(root, injectable);
        }
    }

    private void buildObjectGraphNodes(@Nonnull ComponentGraph graph) {
        HashSet<Node> completed = new HashSet<Node>();
        Stack<WorkEntry> workList = new Stack<WorkEntry>();
        ArrayList<Node> eagerNodes = new ArrayList<Node>(graph.getRawNodeCollection());
        Node rootNode = graph.getRootNode();
        rootNode.setDepth(0);
        this.addDependsOnToWorkList(workList, rootNode, null);
        this.processWorkList(graph, completed, workList);
        for (Node node : eagerNodes) {
            if (!node.isDepthNotSet()) continue;
            node.setDepth(0);
            this.addDependsOnToWorkList(workList, node, null);
            this.processWorkList(graph, completed, workList);
        }
        graph.complete();
    }

    private void processWorkList(@Nonnull ComponentGraph graph, @Nonnull Set<Node> completed, @Nonnull Stack<WorkEntry> workList) {
        InjectorDescriptor injector = graph.getInjector();
        while (!workList.isEmpty()) {
            String message;
            WorkEntry workEntry = workList.pop();
            Edge edge = workEntry.getEntry().getEdge();
            assert (null != edge);
            ServiceRequest serviceRequest = edge.getServiceRequest();
            Coordinate coordinate = serviceRequest.getService().getCoordinate();
            ArrayList<Binding> bindings = new ArrayList<Binding>(graph.findAllBindingsByCoordinate(coordinate));
            if (bindings.isEmpty() && coordinate.getQualifier().isEmpty()) {
                String typename = coordinate.getType().toString();
                InjectableDescriptor injectable = this._registry.findInjectableByClassName(typename);
                if (null != injectable && injectable.isAutoDiscoverable()) {
                    bindings.add(injectable.getBinding());
                }
                if (bindings.isEmpty()) {
                    byte[] data;
                    TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(typename);
                    byte[] byArray = data = null != typeElement ? this.tryLoadDescriptorData(typeElement) : null;
                    if (null != data) {
                        InjectableDescriptor candidate;
                        Object owner;
                        Node node = edge.getNode();
                        Object object = owner = node.hasNoBinding() ? null : node.getBinding().getOwner();
                        TypeElement ownerElement = owner instanceof FragmentDescriptor ? ((FragmentDescriptor)owner).getElement() : (owner instanceof InjectableDescriptor ? ((InjectableDescriptor)owner).getElement() : injector.getElement());
                        Object descriptor = this.loadDescriptor(ownerElement, typename, data);
                        if (descriptor instanceof InjectableDescriptor && (candidate = (InjectableDescriptor)descriptor).isAutoDiscoverable()) {
                            assert (coordinate.equals(candidate.getBinding().getPublishedServices().get(0).getCoordinate()));
                            this._registry.registerInjectable(candidate);
                            bindings.add(candidate.getBinding());
                        }
                    }
                }
            }
            List<Binding> nullableProviders = bindings.stream().filter(b -> b.getPublishedServices().stream().anyMatch(ServiceSpec::isOptional)).collect(Collectors.toList());
            if (!serviceRequest.getService().isOptional() && !nullableProviders.isEmpty()) {
                message = MemberChecks.mustNot("sting.Injector", "contain an optional provider method or optional injector input and a non-optional service request for the coordinate " + coordinate + "\nDependency Path:\n" + workEntry.describePathFromRoot() + "\nBinding" + (nullableProviders.size() > 1 ? "s" : "") + ":\n" + this.bindingsToString(nullableProviders));
                throw new ProcessorException(message, serviceRequest.getElement());
            }
            if (bindings.isEmpty()) {
                if (serviceRequest.getService().isOptional() || serviceRequest.getKind().isCollection()) {
                    edge.setSatisfiedBy(Collections.emptyList());
                    continue;
                }
                message = MemberChecks.mustNot("sting.Injector", "contain a non-optional dependency " + coordinate + " that can not be satisfied.\nDependency Path:\n" + workEntry.describePathFromRoot());
                throw new ProcessorException(message, serviceRequest.getElement());
            }
            ServiceRequest.Kind kind = serviceRequest.getKind();
            if (1 == bindings.size() || kind.isCollection()) {
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (Binding binding : bindings) {
                    Node node = graph.findOrCreateNode(binding);
                    nodes.add(node);
                    if (completed.contains(node)) continue;
                    completed.add(node);
                    this.addDependsOnToWorkList(workList, node, workEntry);
                }
                edge.setSatisfiedBy(nodes);
                continue;
            }
            assert (bindings.size() > 1 && !kind.isCollection());
            String message2 = MemberChecks.mustNot("sting.Injector", "contain a non-collection dependency " + coordinate + " that can be satisfied by multiple nodes.\nDependency Path:\n" + workEntry.describePathFromRoot() + "\nCandidate Nodes:\n" + this.bindingsToString(bindings));
            throw new ProcessorException(message2, serviceRequest.getElement());
        }
    }

    @Nonnull
    private String bindingsToString(@Nonnull List<Binding> bindings) {
        return bindings.stream().map(b -> "  " + b.getTypeLabel() + "    " + b.describe()).collect(Collectors.joining("\n"));
    }

    private void addDependsOnToWorkList(@Nonnull Stack<WorkEntry> workList, @Nonnull Node node, @Nullable WorkEntry parent) {
        for (Edge e : node.getDependsOn()) {
            Stack<PathEntry> stack = new Stack<PathEntry>();
            if (null != parent) {
                stack.addAll(parent.getStack());
            }
            PathEntry entry = new PathEntry(node, e);
            stack.add(entry);
            workList.add(new WorkEntry(entry, stack));
        }
    }

    private void emitObjectGraphJsonDescriptor(@Nonnull ComponentGraph graph) throws IOException {
        if (this._emitJsonDescriptors) {
            TypeElement element = graph.getInjector().getElement();
            String filename = this.toFilename(element) + GRAPH_SUFFIX;
            this.debug(() -> "Emitting json descriptor for the injector " + graph.getInjector().getElement().getQualifiedName());
            JsonUtil.writeJsonResource(this.processingEnv, element, filename, graph::write);
        }
    }

    @Nonnull
    private ResolveType isFragmentResolved(@Nonnull RoundEnvironment env, @Nonnull FragmentDescriptor fragment) {
        if (fragment.isResolved()) {
            return ResolveType.RESOLVED;
        }
        ResolveType resolveType = this.isResolved(env, fragment, fragment.getElement(), fragment.getIncludes());
        if (resolveType == ResolveType.RESOLVED) {
            fragment.markAsResolved();
        }
        return resolveType;
    }

    @Nonnull
    private ResolveType isInjectorResolved(@Nonnull RoundEnvironment env, @Nonnull InjectorDescriptor injector) {
        return this.isResolved(env, injector, injector.getElement(), injector.getIncludes());
    }

    @Nonnull
    private <T> ResolveType isResolved(@Nonnull RoundEnvironment env, @Nonnull T descriptor, @Nonnull TypeElement originator, @Nonnull Collection<IncludeDescriptor> includes) {
        for (IncludeDescriptor include : includes) {
            ResolveType resolveType = this.isIncludeResolved(env, descriptor, originator, include);
            if (ResolveType.RESOLVED == resolveType) continue;
            return resolveType;
        }
        return ResolveType.RESOLVED;
    }

    @Nonnull
    private ResolveType isIncludeResolved(@Nonnull RoundEnvironment env, @Nonnull Object descriptor, @Nonnull TypeElement originator, @Nonnull IncludeDescriptor include) {
        boolean isFragment;
        String annotationClassname;
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(originator, "sting.Injector");
        String string = annotationClassname = null != annotation ? "sting.Injector" : "sting.Fragment";
        if (null == annotation) {
            annotation = AnnotationsUtil.getAnnotationByType(originator, "sting.Fragment");
        }
        String classname = include.getActualTypeName();
        TypeElement element = this.processingEnv.getElementUtils().getTypeElement(classname);
        if (null == element) {
            assert (include.isProvider());
            if (env.processingOver()) {
                if (descriptor instanceof FragmentDescriptor) {
                    ((FragmentDescriptor)descriptor).markAsContainsError();
                } else {
                    ((InjectorDescriptor)descriptor).markAsContainsError();
                }
                String message = MemberChecks.toSimpleName(annotationClassname) + " target has an parameter named 'includes' containing the value " + include.getIncludedType() + " and that type is annotated by the @StingProvider annotation. The provider annotation expects a provider class named " + include.getActualTypeName() + " but no such class exists. The type needs to be removed from the includes or the provider class needs to be present.";
                this.reportError(env, message, originator, annotation, null);
            }
            return ResolveType.UNRESOLVED;
        }
        boolean isInjectable = AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable");
        boolean bl = isFragment = !isInjectable && AnnotationsUtil.hasAnnotationOfType(element, "sting.Fragment");
        if (include.isProvider() && !isInjectable && !isFragment) {
            if (descriptor instanceof FragmentDescriptor) {
                ((FragmentDescriptor)descriptor).markAsContainsError();
            } else {
                ((InjectorDescriptor)descriptor).markAsContainsError();
            }
            String message = MemberChecks.toSimpleName(annotationClassname) + " target has an parameter named 'includes' containing the value " + include.getIncludedType() + " and that type is annotated by the @StingProvider annotation. The provider annotation expects a provider class named " + include.getActualTypeName() + " but that class is not annotated with either " + MemberChecks.toSimpleName("sting.Injector") + " or " + MemberChecks.toSimpleName("sting.Fragment");
            throw new ProcessorException(message, originator, annotation);
        }
        if (isFragment) {
            FragmentDescriptor fragment = this._registry.findFragmentByClassName(classname);
            if (null == fragment) {
                byte[] data = this.tryLoadDescriptorData(element);
                if (null == data) {
                    this.debug(() -> "The fragment " + classname + " is compiled to a .class file but no descriptor is present. Marking " + originator.getQualifiedName() + " as unresolved");
                    return ResolveType.MAYBE_UNRESOLVED;
                }
                Object loadedDescriptor = this.loadDescriptor(originator, classname, data);
                if (loadedDescriptor instanceof FragmentDescriptor) {
                    fragment = (FragmentDescriptor)loadedDescriptor;
                    this._registry.registerFragment(fragment);
                } else {
                    if (null == loadedDescriptor) {
                        this.debug(() -> "The fragment " + classname + " is compiled to a .class file no descriptor is present. Marking " + originator.getQualifiedName() + " as unresolved");
                        return ResolveType.MAYBE_UNRESOLVED;
                    }
                    this.debug(() -> "The fragment " + classname + " is compiled to a .class file but an invalid descriptor is present. Marking " + originator.getQualifiedName() + " as unresolved");
                    return ResolveType.MAYBE_UNRESOLVED;
                }
            }
            if (ResolveType.RESOLVED != this.isFragmentReady(env, fragment)) {
                this.debug(() -> "Fragment include " + classname + " is present but not yet resolved. Marking " + originator.getQualifiedName() + " as unresolved");
                return ResolveType.UNRESOLVED;
            }
        } else {
            InjectableDescriptor injectable = this._registry.findInjectableByClassName(classname);
            if (null == injectable) {
                byte[] data = this.tryLoadDescriptorData(element);
                if (null == data) {
                    this.debug(() -> "The injectable " + classname + " is compiled to a .class file but no descriptor is present.Marking " + originator.getQualifiedName() + " as unresolved");
                    return ResolveType.MAYBE_UNRESOLVED;
                }
                Object loadedDescriptor = this.loadDescriptor(originator, classname, data);
                if (loadedDescriptor instanceof InjectableDescriptor) {
                    injectable = (InjectableDescriptor)loadedDescriptor;
                    this._registry.registerInjectable(injectable);
                } else {
                    this.debug(() -> "The injectable " + classname + " is compiled to a .class file but an invalid descriptor is present. Marking " + originator.getQualifiedName() + " as unresolved");
                    return ResolveType.MAYBE_UNRESOLVED;
                }
            }
            if (!SuperficialValidation.validateElement(this.processingEnv, injectable.getElement())) {
                this.debug(() -> "Injectable include " + classname + " is not yet resolved. Marking " + originator.getQualifiedName() + " as unresolved");
                return ResolveType.UNRESOLVED;
            }
            if (!include.isAuto() && !injectable.getBinding().isEager() && injectable.isAutoDiscoverable() && ElementsUtil.isWarningNotSuppressed(originator, "Sting:AutoDiscoverableIncluded")) {
                String message = MemberChecks.shouldNot(annotationClassname, "include an auto-discoverable type " + classname + ". " + MemberChecks.suppressedBy("Sting:AutoDiscoverableIncluded"));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, originator);
            }
        }
        return ResolveType.RESOLVED;
    }

    private void processInjectorFragment(@Nonnull TypeElement element) {
        this.debug(() -> "Processing Injector Fragment: " + element);
        ElementKind kind = element.getKind();
        if (ElementKind.INTERFACE != kind) {
            throw new ProcessorException(MemberChecks.must("sting.InjectorFragment", "be an interface"), element);
        }
        List<ExecutableElement> methods = ElementsUtil.getMethods(element, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        for (ExecutableElement method : methods) {
            if (method.getModifiers().contains((Object)Modifier.DEFAULT)) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.InjectorFragment") + " target must not include default methods", method);
            }
            if (!method.getModifiers().contains((Object)Modifier.STATIC)) continue;
            throw new ProcessorException(MemberChecks.toSimpleName("sting.InjectorFragment") + " target must not include static methods", method);
        }
    }

    private void processInjector(@Nonnull TypeElement element) throws Exception {
        this.debug(() -> "Processing Injector: " + element);
        ElementKind kind = element.getKind();
        if (ElementKind.INTERFACE != kind) {
            throw new ProcessorException(MemberChecks.must("sting.Injector", "be an interface"), element);
        }
        if (!element.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "have type parameters"), element);
        }
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(element);
        if (!scopedAnnotations.isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "be annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations), element);
        }
        boolean gwt = this.isGwtEnabled(element);
        boolean injectable = (Boolean)AnnotationsUtil.getAnnotationValue(element, "sting.Injector", "injectable").getValue();
        List<IncludeDescriptor> includes = this.extractIncludes(element, "sting.Injector");
        List<InputDescriptor> inputs = this.extractInputs(element);
        ArrayList<ServiceRequest> outputs = new ArrayList<ServiceRequest>();
        List<ExecutableElement> methods = ElementsUtil.getMethods(element, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        for (ExecutableElement executableElement : methods) {
            if (executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.processInjectorOutputMethod(outputs, executableElement);
                continue;
            }
            if (!executableElement.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
            throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector") + " target must not include default methods", executableElement);
        }
        for (Element element2 : element.getEnclosedElements()) {
            DeclaredType type;
            ElementKind enclosedElementKind = element2.getKind();
            if (ElementKind.INTERFACE == enclosedElementKind && AnnotationsUtil.hasAnnotationOfType(element2, "sting.Fragment")) {
                type = (DeclaredType)element2.asType();
                if (includes.stream().noneMatch(d -> Objects.equals(d.getIncludedType(), type))) {
                    includes.add(new IncludeDescriptor(type, type.toString(), true));
                    continue;
                }
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector") + " target must not include a " + MemberChecks.toSimpleName("sting.Fragment") + " annotated type that is auto-included as it is enclosed within the injector type", element);
            }
            if (ElementKind.CLASS == enclosedElementKind && AnnotationsUtil.hasAnnotationOfType(element2, "sting.Injectable")) {
                type = (DeclaredType)element2.asType();
                if (includes.stream().noneMatch(d -> Objects.equals(d.getIncludedType(), type))) {
                    includes.add(new IncludeDescriptor(type, type.toString(), true));
                    continue;
                }
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector") + " target must not include an " + MemberChecks.toSimpleName("sting.Injectable") + " annotated type that is auto-included as it is enclosed within the injector type", element);
            }
            if (!enclosedElementKind.isClass() && !enclosedElementKind.isInterface()) continue;
            throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector") + " target must not contain a type that is not annotated by either " + MemberChecks.toSimpleName("sting.Injectable") + " or " + MemberChecks.toSimpleName("sting.Fragment"), element);
        }
        InjectorDescriptor injector = new InjectorDescriptor(element, gwt, injectable, includes, inputs, outputs);
        this._registry.registerInjector(injector);
        this.emitInjectorJsonDescriptor(injector);
    }

    private boolean isGwtEnabled(@Nonnull TypeElement element) {
        String value = AnnotationsUtil.getEnumAnnotationParameter(element, "sting.Injector", "gwt");
        return "ENABLE".equals(value) || "AUTODETECT".equals(value) && null != this.processingEnv.getElementUtils().getTypeElement("javaemul.internal.annotations.DoNotInline");
    }

    private void emitInjectorJsonDescriptor(@Nonnull InjectorDescriptor injector) throws IOException {
        if (this._emitJsonDescriptors) {
            TypeElement element = injector.getElement();
            String filename = this.toFilename(element) + JSON_SUFFIX;
            JsonUtil.writeJsonResource(this.processingEnv, element, filename, injector::write);
        }
    }

    private void processInjectorOutputMethod(@Nonnull List<ServiceRequest> outputs, @Nonnull ExecutableElement method) {
        assert (method.getModifiers().contains((Object)Modifier.ABSTRACT));
        if (TypeKind.VOID == method.getReturnType().getKind()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that has a void return value"), method);
        }
        if (!method.getParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that has parameters"), method);
        }
        if (!method.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that has any type parameters"), method);
        }
        if (!method.getThrownTypes().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that throws any exceptions"), method);
        }
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(method);
        if (!scopedAnnotations.isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method that is annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations), method);
        }
        outputs.add(this.processOutputMethod(method));
    }

    @Nonnull
    private ServiceRequest processOutputMethod(@Nonnull ExecutableElement method) {
        TypeMirror type = method.getReturnType();
        if (TypesUtil.containsArrayType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method with a return type that contains an array type"), method);
        }
        if (TypesUtil.containsWildcard(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method with a return type that contains a wildcard type parameter"), method);
        }
        if (TypesUtil.containsRawType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method with a return type that contains a raw type"), method);
        }
        TypeMirror dependencyType = null;
        ServiceRequest.Kind kind = null;
        for (ServiceRequest.Kind candidate : ServiceRequest.Kind.values()) {
            dependencyType = candidate.extractType(type);
            if (null == dependencyType) continue;
            kind = candidate;
            break;
        }
        if (null == kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method with a return type that contains an unexpected parameterized type. Only parameterized types known to the framework are supported"), method);
        }
        boolean optional = AnnotationsUtil.hasNullableAnnotation(method);
        if (optional && ServiceRequest.Kind.INSTANCE != kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method annotated with " + MemberChecks.toSimpleName("javax.annotation.Nullable") + " that is not an instance dependency kind"), method);
        }
        String qualifier = this.getQualifier(method);
        if (AnnotationsUtil.hasAnnotationOfType(method, "javax.inject.Named")) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injector", "contain a method annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead"), method);
        }
        Coordinate coordinate = new Coordinate(qualifier, dependencyType);
        ServiceSpec service = new ServiceSpec(coordinate, optional);
        return new ServiceRequest(kind, service, method, -1);
    }

    private void verifyNamedElements(@Nonnull RoundEnvironment env, @Nonnull Set<? extends Element> elements) {
        for (Element element : elements) {
            if (ElementKind.PARAMETER == element.getKind()) {
                boolean isActAsStingComponent;
                Element executableElement = element.getEnclosingElement();
                boolean injectableType = AnnotationsUtil.hasAnnotationOfType(executableElement.getEnclosingElement(), "sting.Injectable");
                boolean isFragmentType = !injectableType && AnnotationsUtil.hasAnnotationOfType(executableElement.getEnclosingElement(), "sting.Fragment");
                ElementKind executableKind = executableElement.getKind();
                boolean isProvider = !injectableType && !isFragmentType && this.hasStingProvider(executableElement.getEnclosingElement());
                boolean bl = isActAsStingComponent = !injectableType && !isFragmentType && !isProvider && this.hasActAsStingComponent(executableElement.getEnclosingElement());
                if (!(injectableType || ElementKind.CONSTRUCTOR != executableKind || isProvider || isActAsStingComponent)) {
                    this.reportError(env, MemberChecks.must("sting.Named", "only be present on a constructor parameter if the constructor is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Injectable") + " or the type is annotated with an annotation annotated by @ActAsStringComponent or @StingProvider"), element);
                    continue;
                }
                if (!isFragmentType && ElementKind.METHOD == executableKind) {
                    this.reportError(env, MemberChecks.must("sting.Named", "only be present on a method parameter if the method is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Fragment")), element);
                    continue;
                }
                assert (injectableType && ElementKind.CONSTRUCTOR == executableKind || isProvider && ElementKind.CONSTRUCTOR == executableKind || isActAsStingComponent && ElementKind.CONSTRUCTOR == executableKind || isFragmentType && ElementKind.METHOD == executableKind);
                continue;
            }
            if (ElementKind.CLASS == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable") || this.hasStingProvider(element) || this.hasActAsStingComponent(element)) continue;
                this.reportError(env, MemberChecks.must("sting.Named", "only be present on a type if the type is annotated with " + MemberChecks.toSimpleName("sting.Injectable") + " or the type is annotated with an annotation annotated by @ActAsStringComponent or @StingProvider"), element);
                continue;
            }
            if (ElementKind.METHOD == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Fragment") || AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Injector") || AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.InjectorFragment")) continue;
                this.reportError(env, MemberChecks.mustNot("sting.Named", "be a method unless the method is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Fragment") + ", " + MemberChecks.toSimpleName("sting.Injector") + " or " + MemberChecks.toSimpleName("sting.InjectorFragment")), element);
                continue;
            }
            this.reportError(env, MemberChecks.toSimpleName("sting.Named") + " target is not valid", element);
        }
    }

    private boolean hasStingProvider(@Nonnull Element element) {
        return this.hasAnnotationWithAnnotationMatching(element, ca -> ca.getAnnotationType().asElement().getSimpleName().contentEquals("StingProvider"));
    }

    private boolean hasActAsStingComponent(@Nonnull Element element) {
        return this.hasAnnotationWithAnnotationMatching(element, ca -> ca.getAnnotationType().asElement().getSimpleName().contentEquals("ActAsStingComponent"));
    }

    private boolean hasAnnotationWithAnnotationMatching(@Nonnull AnnotatedConstruct element, @Nonnull Predicate<? super AnnotationMirror> predicate) {
        return element.getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().asElement().getAnnotationMirrors().stream().anyMatch(predicate));
    }

    private void verifyTypedElements(@Nonnull RoundEnvironment env, @Nonnull Set<? extends Element> elements) {
        for (Element element : elements) {
            if (ElementKind.CLASS == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable") || this.hasStingProvider(element)) continue;
                this.reportError(env, MemberChecks.must("sting.Typed", "only be present on a type if the type is annotated with " + MemberChecks.toSimpleName("sting.Injectable") + " or the type is annotated with an annotation annotated by @StingProvider"), element);
                continue;
            }
            if (ElementKind.METHOD == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Fragment") || AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Injector")) continue;
                this.reportError(env, MemberChecks.mustNot("sting.Typed", "be a method unless the method is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Fragment") + " or " + MemberChecks.toSimpleName("sting.Injector")), element);
                continue;
            }
            this.reportError(env, MemberChecks.toSimpleName("sting.Typed") + " target is not valid", element);
        }
    }

    private void verifyEagerElements(@Nonnull RoundEnvironment env, @Nonnull Set<? extends Element> elements) {
        for (Element element : elements) {
            if (ElementKind.CLASS == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable") || this.hasStingProvider(element)) continue;
                this.reportError(env, MemberChecks.must("sting.Eager", "only be present on a type if the type is annotated with " + MemberChecks.toSimpleName("sting.Injectable") + " or the type is annotated with an annotation annotated by @StingProvider"), element);
                continue;
            }
            if (ElementKind.METHOD == element.getKind()) {
                if (AnnotationsUtil.hasAnnotationOfType(element.getEnclosingElement(), "sting.Fragment")) continue;
                this.reportError(env, MemberChecks.must("sting.Eager", "only be present on a method if the method is enclosed in a type annotated with " + MemberChecks.toSimpleName("sting.Fragment")), element);
                continue;
            }
            this.reportError(env, MemberChecks.toSimpleName("sting.Eager") + " target is not valid", element);
        }
    }

    private void processFragment(@Nonnull TypeElement element) {
        this.debug(() -> "Processing Fragment: " + element);
        if (ElementKind.INTERFACE != element.getKind()) {
            throw new ProcessorException(MemberChecks.must("sting.Fragment", "be an interface"), element);
        }
        if (!element.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "have type parameters"), element);
        }
        if (!element.getInterfaces().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "extend any interfaces"), element);
        }
        List<IncludeDescriptor> includes = this.extractIncludes(element, "sting.Fragment");
        LinkedHashMap<ExecutableElement, Binding> bindings = new LinkedHashMap<ExecutableElement, Binding>();
        for (Element element2 : element.getEnclosedElements()) {
            ElementKind enclosedElementKind = element2.getKind();
            if (ElementKind.METHOD == enclosedElementKind) {
                this.processProvidesMethod(element, bindings, (ExecutableElement)element2);
            }
            if (!enclosedElementKind.isClass() && !enclosedElementKind.isInterface()) continue;
            throw new ProcessorException(MemberChecks.toSimpleName("sting.Fragment") + " target must not contain any types", element);
        }
        if (bindings.isEmpty() && includes.isEmpty()) {
            throw new ProcessorException(MemberChecks.must("sting.Fragment", "contain one or more methods or one or more includes"), element);
        }
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(element);
        if (!scopedAnnotations.isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "be annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations), element);
        }
        this._registry.registerFragment(new FragmentDescriptor(element, includes, bindings.values()));
    }

    private void processAutoFragment(@Nonnull TypeElement element) {
        this.debug(() -> "Processing Auto-Fragment: " + element);
        if (ElementKind.INTERFACE != element.getKind()) {
            throw new ProcessorException(MemberChecks.must("sting.AutoFragment", "be an interface"), element);
        }
        if (!element.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.AutoFragment", "have type parameters"), element);
        }
        if (!element.getInterfaces().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.AutoFragment", "extend any interfaces"), element);
        }
        if (!element.getEnclosedElements().isEmpty()) {
            Element enclosedElement = element.getEnclosedElements().get(0);
            ElementKind kind = enclosedElement.getKind();
            if (kind.isField()) {
                throw new ProcessorException(MemberChecks.mustNot("sting.AutoFragment", "contain any fields"), element);
            }
            if (ElementKind.METHOD == kind) {
                throw new ProcessorException(MemberChecks.mustNot("sting.AutoFragment", "contain any methods"), element);
            }
            assert (kind.isClass() || kind.isInterface());
            throw new ProcessorException(MemberChecks.mustNot("sting.AutoFragment", "contain any types"), element);
        }
        String key = (String)AnnotationsUtil.getAnnotationValue(element, "sting.AutoFragment", "value").getValue();
        AutoFragmentDescriptor existing = this._registry.findAutoFragmentByKey(key);
        if (null != existing) {
            throw new ProcessorException(MemberChecks.mustNot("sting.AutoFragment", "have the same key as an existing AutoFragment of type " + existing.getElement().getQualifiedName()), element);
        }
        this._registry.registerAutoFragment(new AutoFragmentDescriptor(key, element));
    }

    private void processContributeTo(@Nonnull TypeElement element) {
        this.debug(() -> "Processing ContributeTo: " + element);
        if (!(AnnotationsUtil.hasAnnotationOfType(element, "sting.Fragment") || AnnotationsUtil.hasAnnotationOfType(element, "sting.Injectable") || this.hasStingProvider(element))) {
            if (this.hasActAsStingComponent(element)) {
                this.debug(() -> "ContributeTo Element skipped due to @ActAsStringComponent: " + element);
                return;
            }
            throw new ProcessorException(MemberChecks.must("sting.ContributeTo", "be annotated with " + MemberChecks.toSimpleName("sting.Injectable") + ", " + MemberChecks.toSimpleName("sting.Fragment") + " or be annotated with an annotation annotated by @ActAsStringComponent or @StingProvider"), element);
        }
        String key = (String)AnnotationsUtil.getAnnotationValue(element, "sting.ContributeTo", "value").getValue();
        AutoFragmentDescriptor autoFragment = this._registry.findAutoFragmentByKey(key);
        if (null != autoFragment && autoFragment.isFragmentGenerated()) {
            throw new ProcessorException(MemberChecks.toSimpleName("sting.ContributeTo") + " target attempted to be added to the " + MemberChecks.toSimpleName("sting.AutoFragment") + " annotated type " + autoFragment.getElement().getQualifiedName() + " but the " + MemberChecks.toSimpleName("sting.AutoFragment") + " annotated type has already generated fragment", element);
        }
        boolean autoDiscoverable = false;
        InjectableDescriptor injectable = this._registry.findInjectableByClassName(element.getQualifiedName().toString());
        if (null != injectable && !injectable.getBinding().isEager() && injectable.isAutoDiscoverable()) {
            autoDiscoverable = true;
            if (ElementsUtil.isWarningNotSuppressed(element, "Sting:AutoDiscoverableContributed")) {
                String message = MemberChecks.shouldNot("sting.ContributeTo", "be an auto-discoverable type. " + MemberChecks.suppressedBy("Sting:AutoDiscoverableContributed"));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
            }
        }
        ContributorDescriptor contributor = new ContributorDescriptor(key, element, autoDiscoverable);
        this._registry.registerContributor(contributor);
        if (null != autoFragment) {
            autoFragment.markAsModified();
            autoFragment.getContributors().add(contributor);
        }
    }

    @Nonnull
    private List<InputDescriptor> extractInputs(@Nonnull TypeElement element) {
        ArrayList<InputDescriptor> results = new ArrayList<InputDescriptor>();
        AnnotationMirror annotation = AnnotationsUtil.getAnnotationByType(element, "sting.Injector");
        AnnotationValue inputsAnnotationValue = AnnotationsUtil.findAnnotationValue(annotation, "inputs");
        assert (null != inputsAnnotationValue);
        List inputs = (List)inputsAnnotationValue.getValue();
        int size = inputs.size();
        for (int i = 0; i < size; ++i) {
            AnnotationMirror input = (AnnotationMirror)inputs.get(i);
            String qualifier = (String)AnnotationsUtil.getAnnotationValueValue(input, "qualifier");
            AnnotationValue typeAnnotationValue = AnnotationsUtil.getAnnotationValue(input, "type");
            TypeMirror type = (TypeMirror)typeAnnotationValue.getValue();
            if (TypeKind.ARRAY == type.getKind()) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector.Input") + " must not specify an array type for the type parameter", element, input, typeAnnotationValue);
            }
            if (TypeKind.VOID == type.getKind()) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector.Input") + " must specify a non-void type for the type parameter", element, input, typeAnnotationValue);
            }
            if (TypeKind.DECLARED == type.getKind() && !((TypeElement)((DeclaredType)type).asElement()).getTypeParameters().isEmpty()) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Injector.Input") + " must not specify a parameterized type for the type parameter", element, input, typeAnnotationValue);
            }
            Coordinate coordinate = new Coordinate(qualifier, type);
            boolean optional = (Boolean)AnnotationsUtil.getAnnotationValueValue(input, "optional");
            ServiceSpec service = new ServiceSpec(coordinate, optional);
            Binding binding = new Binding(Binding.Kind.INPUT, element.getQualifiedName() + "#" + i, Collections.singletonList(service), true, element, new ServiceRequest[0]);
            results.add(new InputDescriptor(service, binding, "input" + (i + 1)));
        }
        return results;
    }

    @Nonnull
    private List<IncludeDescriptor> extractIncludes(@Nonnull TypeElement element, @Nonnull String annotationClassname) {
        ArrayList<IncludeDescriptor> results = new ArrayList<IncludeDescriptor>();
        List<TypeMirror> includes = AnnotationsUtil.getTypeMirrorsAnnotationParameter(element, annotationClassname, "includes");
        HashSet<String> included = new HashSet<String>();
        for (TypeMirror include : includes) {
            if (this.processingEnv.getTypeUtils().isSameType(include, element.asType())) {
                throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target must not include self", element);
            }
            if (include.getKind().isPrimitive()) {
                throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target must not include a primitive in the includes parameter", element);
            }
            Element includeElement = this.processingEnv.getTypeUtils().asElement(include);
            if (AnnotationsUtil.hasAnnotationOfType(includeElement, "sting.Fragment") || AnnotationsUtil.hasAnnotationOfType(includeElement, "sting.Injectable")) {
                results.add(new IncludeDescriptor((DeclaredType)include, include.toString(), false));
            } else {
                ElementKind kind = includeElement.getKind();
                if (ElementKind.CLASS == kind || ElementKind.INTERFACE == kind) {
                    List providers = includeElement.getAnnotationMirrors().stream().map(a -> {
                        AnnotationMirror provider = this.getStingProvider(element, annotationClassname, (TypeElement)includeElement, (AnnotationMirror)a);
                        return null != provider ? new ProviderEntry((AnnotationMirror)a, provider) : null;
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    if (providers.size() > 1) {
                        String message = MemberChecks.toSimpleName(annotationClassname) + " target has an 'includes' parameter containing the value " + includeElement.asType() + " that is annotated by multiple @StingProvider annotations. Matching annotations:\n" + providers.stream().map(a -> ((TypeElement)a.getAnnotation().getAnnotationType().asElement()).getQualifiedName()).map(a -> "  " + a).collect(Collectors.joining("\n"));
                        throw new ProcessorException(message, element);
                    }
                    if (!providers.isEmpty()) {
                        ProviderEntry entry = (ProviderEntry)providers.get(0);
                        AnnotationMirror providerAnnotation = entry.getProvider();
                        String namePattern = (String)AnnotationsUtil.getAnnotationValueValue(providerAnnotation, "value");
                        String targetCompoundType = namePattern.replace("[SimpleName]", includeElement.getSimpleName().toString()).replace("[CompoundName]", this.getComponentName((TypeElement)includeElement)).replace("[EnclosingName]", this.getEnclosingName((TypeElement)includeElement)).replace("[FlatEnclosingName]", this.getEnclosingName((TypeElement)includeElement).replace('.', '_'));
                        String targetQualifiedName = ElementsUtil.getPackageElement(includeElement).getQualifiedName().toString() + "." + targetCompoundType;
                        results.add(new IncludeDescriptor((DeclaredType)include, targetQualifiedName, false));
                    } else {
                        throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target has an includes parameter containing the value " + include + " that is not a type annotated by either " + MemberChecks.toSimpleName("sting.Fragment") + " or " + MemberChecks.toSimpleName("sting.Injectable") + " and the type does not declare a provider", element);
                    }
                }
            }
            String includedType = include.toString();
            if (included.contains(includedType)) {
                throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target has an includes parameter containing duplicate includes with the type " + includedType, element);
            }
            included.add(includedType);
        }
        return results;
    }

    @Nullable
    private AnnotationMirror getStingProvider(@Nonnull TypeElement element, @Nonnull String annotationClassname, @Nonnull TypeElement includeElement, @Nonnull AnnotationMirror annotation) {
        return annotation.getAnnotationType().asElement().getAnnotationMirrors().stream().filter(ca -> this.isStingProvider(element, annotationClassname, includeElement, (AnnotationMirror)ca)).findAny().orElse(null);
    }

    @Nonnull
    private String getComponentName(@Nonnull TypeElement element) {
        return this.getEnclosingName(element) + element.getSimpleName();
    }

    @Nonnull
    private String getEnclosingName(@Nonnull TypeElement element) {
        Element enclosingElement = element.getEnclosingElement();
        ArrayList<String> nameParts = new ArrayList<String>();
        while (ElementKind.PACKAGE != enclosingElement.getKind()) {
            nameParts.add(enclosingElement.getSimpleName().toString());
            enclosingElement = enclosingElement.getEnclosingElement();
        }
        if (nameParts.isEmpty()) {
            return "";
        }
        Collections.reverse(nameParts);
        return String.join((CharSequence)".", nameParts) + ".";
    }

    private boolean isStingProvider(@Nonnull TypeElement element, @Nonnull String annotationClassname, @Nonnull Element includeElement, @Nonnull AnnotationMirror annotation) {
        if (!annotation.getAnnotationType().asElement().getSimpleName().contentEquals("StingProvider")) {
            return false;
        }
        boolean nameMatched = annotation.getElementValues().entrySet().stream().anyMatch(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value") && ((AnnotationValue)e.getValue()).getValue() instanceof String);
        if (nameMatched) {
            return true;
        }
        String message = MemberChecks.toSimpleName(annotationClassname) + " target has an 'includes' parameter containing the value " + includeElement.asType() + " that is annotated by " + annotation + " that is annotated by an invalid @StingProvider annotation missing a 'value' parameter of type string.";
        throw new ProcessorException(message, element);
    }

    private void emitFragmentJsonDescriptor(@Nonnull FragmentDescriptor fragment) throws IOException {
        if (this._emitJsonDescriptors) {
            TypeElement element = fragment.getElement();
            String filename = this.toFilename(element) + JSON_SUFFIX;
            JsonUtil.writeJsonResource(this.processingEnv, element, filename, fragment::write);
        }
    }

    private void processProvidesMethod(@Nonnull TypeElement element, @Nonnull Map<ExecutableElement, Binding> bindings, @Nonnull ExecutableElement method) {
        if (TypeKind.VOID == method.getReturnType().getKind()) {
            throw new ProcessorException(MemberChecks.must("sting.Fragment", "only contain methods that return a value"), method);
        }
        if (!method.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain methods with a type parameter"), method);
        }
        if (!method.getModifiers().contains((Object)Modifier.DEFAULT)) {
            throw new ProcessorException(MemberChecks.must("sting.Fragment", "only contain methods with a default modifier"), method);
        }
        boolean nullablePresent = AnnotationsUtil.hasNullableAnnotation(method);
        if (nullablePresent && method.getReturnType().getKind().isPrimitive()) {
            throw new ProcessorException(MemberChecks.toSimpleName("sting.Fragment") + " contains a method that is incorrectly annotated with " + MemberChecks.toSimpleName("javax.annotation.Nullable") + " as the return type is a primitive value", method);
        }
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(method);
        if (!scopedAnnotations.isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method that is annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations), method);
        }
        boolean eager = AnnotationsUtil.hasAnnotationOfType(method, "sting.Eager");
        ArrayList<ServiceRequest> dependencies = new ArrayList<ServiceRequest>();
        int index = 0;
        List<? extends TypeMirror> parameterTypes = ((ExecutableType)method.asType()).getParameterTypes();
        for (VariableElement variableElement : method.getParameters()) {
            dependencies.add(this.processFragmentServiceParameter(variableElement, parameterTypes.get(index), index));
            ++index;
        }
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(method, "sting.Typed");
        AnnotationValue annotationValue = null != annotation ? AnnotationsUtil.findAnnotationValue(annotation, "value") : null;
        String qualifier = this.getQualifier(method);
        if (AnnotationsUtil.hasAnnotationOfType(method, "javax.inject.Named")) {
            String message = MemberChecks.mustNot("sting.Fragment", "contain a method annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead");
            throw new ProcessorException(message, method);
        }
        if (AnnotationsUtil.hasAnnotationOfType(method, "javax.enterprise.inject.Typed")) {
            String message = MemberChecks.mustNot("sting.Fragment", "contain a method annotated with the javax.enterprise.inject.Typed annotation. Use the sting.Typed annotation instead");
            throw new ProcessorException(message, method);
        }
        List<TypeMirror> types = null == annotationValue ? Collections.singletonList(method.getReturnType()) : ((List)annotationValue.getValue()).stream().map(v -> (TypeMirror)v.getValue()).collect(Collectors.toList());
        ServiceSpec[] specs = new ServiceSpec[types.size()];
        for (int i = 0; i < specs.length; ++i) {
            TypeMirror type = types.get(i);
            if (!this.processingEnv.getTypeUtils().isAssignable(method.getReturnType(), type)) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Typed") + " specified a type that is not assignable to the return type of the method", element, annotation, annotationValue);
            }
            if (TypeKind.DECLARED == type.getKind() && this.isParameterized((DeclaredType)type)) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Typed") + " specified a type that is a a parameterized type", element, annotation, annotationValue);
            }
            specs[i] = new ServiceSpec(new Coordinate(qualifier, type), nullablePresent);
        }
        if (0 == specs.length && !eager) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain methods that specify zero types with the " + MemberChecks.toSimpleName("sting.Typed") + " annotation and are not annotated with the " + MemberChecks.toSimpleName("sting.Eager") + " annotation otherwise the component can not be created by the injector"), element);
        }
        if (0 == specs.length && !"".equals(qualifier)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain methods that specify zero types with the " + MemberChecks.toSimpleName("sting.Typed") + " annotation and specify a qualifier with the " + MemberChecks.toSimpleName("sting.Named") + " annotation as the qualifier is meaningless"), element);
        }
        Binding binding = new Binding(Binding.Kind.PROVIDES, element.getQualifiedName() + "#" + method.getSimpleName(), Arrays.asList(specs), eager, method, dependencies.toArray(new ServiceRequest[0]));
        bindings.put(method, binding);
    }

    @Nonnull
    private ServiceRequest processFragmentServiceParameter(@Nonnull VariableElement parameter, @Nonnull TypeMirror type, int parameterIndex) {
        if (TypesUtil.containsArrayType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter that contains an array type"), parameter);
        }
        if (TypesUtil.containsWildcard(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter that contains a wildcard type parameter"), parameter);
        }
        if (TypesUtil.containsRawType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter that contains a raw type"), parameter);
        }
        TypeMirror dependencyType = null;
        ServiceRequest.Kind kind = null;
        for (ServiceRequest.Kind candidate : ServiceRequest.Kind.values()) {
            dependencyType = candidate.extractType(type);
            if (null == dependencyType) continue;
            kind = candidate;
            break;
        }
        if (null == kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter that contains an unexpected parameterized type. Only parameterized types known to the framework are supported"), parameter);
        }
        boolean optional = AnnotationsUtil.hasNullableAnnotation(parameter);
        if (optional && ServiceRequest.Kind.INSTANCE != kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter annotated with the " + MemberChecks.toSimpleName("javax.annotation.Nullable") + " annotation that is not an instance dependency kind"), parameter);
        }
        String qualifier = this.getQualifier(parameter);
        if (AnnotationsUtil.hasAnnotationOfType(parameter, "javax.inject.Named")) {
            String message = MemberChecks.mustNot("sting.Fragment", "contain a method with a parameter annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead");
            throw new ProcessorException(message, parameter);
        }
        Coordinate coordinate = new Coordinate(qualifier, dependencyType);
        ServiceSpec service = new ServiceSpec(coordinate, optional);
        return new ServiceRequest(kind, service, parameter, parameterIndex);
    }

    private void processInjectable(@Nonnull TypeElement element) {
        String message;
        this.debug(() -> "Processing Injectable: " + element);
        if (ElementKind.CLASS != element.getKind()) {
            throw new ProcessorException(MemberChecks.must("sting.Injectable", "be a class"), element);
        }
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "be abstract"), element);
        }
        if (ElementsUtil.isNonStaticNestedClass(element)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "be a non-static nested class"), element);
        }
        if (!element.getTypeParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "have type parameters"), element);
        }
        List<ExecutableElement> constructors = ElementsUtil.getConstructors(element);
        ExecutableElement constructor = constructors.get(0);
        if (constructors.size() > 1) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "have multiple constructors"), element);
        }
        this.injectableConstructorShouldNotBeProtected(constructor);
        this.injectableConstructorShouldNotBePublic(constructor);
        this.injectableShouldNotHaveScopedAnnotation(element);
        boolean eager = AnnotationsUtil.hasAnnotationOfType(element, "sting.Eager");
        ArrayList<ServiceRequest> dependencies = new ArrayList<ServiceRequest>();
        int index = 0;
        List<? extends TypeMirror> parameterTypes = ((ExecutableType)constructor.asType()).getParameterTypes();
        for (VariableElement variableElement : constructor.getParameters()) {
            dependencies.add(this.handleConstructorParameter(variableElement, parameterTypes.get(index), index));
            ++index;
        }
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(element, "sting.Typed");
        AnnotationValue annotationValue = null != annotation ? AnnotationsUtil.findAnnotationValue(annotation, "value") : null;
        String qualifier = this.getQualifier(element);
        if (AnnotationsUtil.hasAnnotationOfType(element, "javax.inject.Named") && ElementsUtil.isWarningNotSuppressed(element, "Sting:Jsr330NamedPresent")) {
            message = MemberChecks.mustNot("sting.Injectable", "be annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead. " + MemberChecks.suppressedBy("Sting:Jsr330NamedPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
        }
        if (AnnotationsUtil.hasAnnotationOfType(element, "javax.enterprise.inject.Typed") && ElementsUtil.isWarningNotSuppressed(element, "Sting:CdiTypedPresent")) {
            message = MemberChecks.mustNot("sting.Injectable", "be annotated with the javax.enterprise.inject.Typed annotation. Use the sting.Typed annotation instead. " + MemberChecks.suppressedBy("Sting:CdiTypedPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
        }
        if (AnnotationsUtil.hasAnnotationOfType(constructor, "javax.inject.Inject") && ElementsUtil.isWarningNotSuppressed(constructor, "Sting:Jsr330InjectPresent")) {
            message = MemberChecks.mustNot("sting.Injectable", "be annotated with the javax.inject.Inject annotation. " + MemberChecks.suppressedBy("Sting:Jsr330InjectPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, constructor);
        }
        List<TypeMirror> types = null == annotationValue ? Collections.singletonList(element.asType()) : ((List)annotationValue.getValue()).stream().map(v -> (TypeMirror)v.getValue()).collect(Collectors.toList());
        ServiceSpec[] specs = new ServiceSpec[types.size()];
        for (int i = 0; i < specs.length; ++i) {
            TypeMirror type = types.get(i);
            if (!this.processingEnv.getTypeUtils().isAssignable(element.asType(), type)) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Typed") + " specified a type that is not assignable to the declaring type", element, annotation, annotationValue);
            }
            if (TypeKind.DECLARED == type.getKind() && this.isParameterized((DeclaredType)type)) {
                throw new ProcessorException(MemberChecks.toSimpleName("sting.Typed") + " specified a type that is a a parameterized type", element, annotation, annotationValue);
            }
            specs[i] = new ServiceSpec(new Coordinate(qualifier, type), false);
        }
        if (0 == specs.length && !eager) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "specify zero types with the " + MemberChecks.toSimpleName("sting.Typed") + " annotation or must be annotated with the " + MemberChecks.toSimpleName("sting.Eager") + " annotation otherwise the component can not be created by the injector"), element);
        }
        if (0 == specs.length && !"".equals(qualifier)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "specify zero types with the " + MemberChecks.toSimpleName("sting.Typed") + " annotation and specify a qualifier with the " + MemberChecks.toSimpleName("sting.Named") + " annotation as the qualifier is meaningless"), element);
        }
        Binding binding = new Binding(Binding.Kind.INJECTABLE, element.getQualifiedName().toString(), Arrays.asList(specs), eager, constructor, dependencies.toArray(new ServiceRequest[0]));
        InjectableDescriptor injectable = new InjectableDescriptor(binding);
        this._registry.registerInjectable(injectable);
    }

    private void writeBinaryDescriptor(@Nonnull TypeElement element, @Nonnull Object descriptor) throws IOException {
        this.debug(() -> "Emitting binary descriptor for " + element.getQualifiedName());
        String[] nameParts = this.extractNameParts(element);
        FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, nameParts[0], nameParts[1], element);
        try (OutputStream out = resource.openOutputStream();
             DataOutputStream dos = new DataOutputStream(out);){
            this._descriptorIO.write(dos, descriptor);
        }
        if (this._verifyDescriptors) {
            this.verifyDescriptor(element, descriptor);
        }
    }

    @Nonnull
    private String[] extractNameParts(@Nonnull TypeElement element) {
        String binaryName = this.processingEnv.getElementUtils().getBinaryName(element).toString();
        int lastIndex = binaryName.lastIndexOf(".");
        String packageName = -1 == lastIndex ? "" : binaryName.substring(0, lastIndex);
        String relativeName = binaryName.substring(-1 == lastIndex ? 0 : lastIndex + 1) + SUFFIX;
        return new String[]{packageName, relativeName};
    }

    private void verifyDescriptor(@Nonnull TypeElement element, @Nonnull Object descriptor) throws IOException {
        Object newDescriptor;
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos1);){
            this._descriptorIO.write(dos, descriptor);
        }
        try (DataInputStream dos = new DataInputStream(new ByteArrayInputStream(baos1.toByteArray()));){
            newDescriptor = this._descriptorIO.read(dos, element.getQualifiedName().toString());
        }
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos2);){
            this._descriptorIO.write(dos, newDescriptor);
        }
        if (!Arrays.equals(baos1.toByteArray(), baos2.toByteArray())) {
            throw new ProcessorException("Failed to emit valid binary descriptor for " + element.getQualifiedName() + ". Reading the emitted descriptor did not produce an equivalent descriptor.", element);
        }
    }

    private void emitInjectableJsonDescriptor(@Nonnull InjectableDescriptor injectable) throws IOException {
        if (this._emitJsonDescriptors) {
            TypeElement element = injectable.getElement();
            String filename = this.toFilename(element) + JSON_SUFFIX;
            JsonUtil.writeJsonResource(this.processingEnv, element, filename, injectable::write);
        }
    }

    @Nonnull
    private String toFilename(@Nonnull TypeElement typeElement) {
        return GeneratorUtil.getGeneratedClassName(typeElement, "", "").toString().replace(".", "/");
    }

    @Nonnull
    private ServiceRequest handleConstructorParameter(@Nonnull VariableElement parameter, @Nonnull TypeMirror type, int parameterIndex) {
        if (TypesUtil.containsArrayType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter that contains an array type"), parameter);
        }
        if (TypesUtil.containsWildcard(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter that contains a wildcard type parameter"), parameter);
        }
        if (TypesUtil.containsRawType(type)) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter that contains a raw type"), parameter);
        }
        TypeMirror dependencyType = null;
        ServiceRequest.Kind kind = null;
        for (ServiceRequest.Kind candidate : ServiceRequest.Kind.values()) {
            dependencyType = candidate.extractType(type);
            if (null == dependencyType) continue;
            kind = candidate;
            break;
        }
        if (null == kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter that contains an unexpected parameterized type. Only parameterized types known to the framework are supported"), parameter);
        }
        boolean optional = AnnotationsUtil.hasNullableAnnotation(parameter);
        if (optional && ServiceRequest.Kind.INSTANCE != kind) {
            throw new ProcessorException(MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter annotated with " + MemberChecks.toSimpleName("javax.annotation.Nullable") + " that is not an instance dependency kind"), parameter);
        }
        String qualifier = this.getQualifier(parameter);
        if (AnnotationsUtil.hasAnnotationOfType(parameter, "javax.inject.Named") && ElementsUtil.isWarningNotSuppressed(parameter, "Sting:Jsr330NamedPresent")) {
            String message = MemberChecks.mustNot("sting.Injectable", "contain a constructor with a parameter annotated with the javax.inject.Named annotation. Use the sting.Named annotation instead. " + MemberChecks.suppressedBy("Sting:Jsr330NamedPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, parameter);
        }
        Coordinate coordinate = new Coordinate(qualifier, dependencyType);
        ServiceSpec service = new ServiceSpec(coordinate, optional);
        return new ServiceRequest(kind, service, parameter, parameterIndex);
    }

    @Nonnull
    private String getQualifier(@Nonnull Element element) {
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(element, "sting.Named");
        return null == annotation ? "" : (String)AnnotationsUtil.getAnnotationValueValue(annotation, "value");
    }

    private void injectableShouldNotHaveScopedAnnotation(@Nonnull TypeElement element) {
        List<? extends AnnotationMirror> scopedAnnotations = this.getScopedAnnotations(element);
        if (!scopedAnnotations.isEmpty() && ElementsUtil.isWarningNotSuppressed(element, "Sting:Jsr330ScopedPresent")) {
            String message = MemberChecks.shouldNot("sting.Injectable", "be annotated with an annotation that is annotated with the javax.inject.Scope annotation such as " + scopedAnnotations + ". " + MemberChecks.suppressedBy("Sting:Jsr330ScopedPresent"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
        }
    }

    private void injectableConstructorShouldNotBePublic(@Nonnull ExecutableElement constructor) {
        if (ElementsUtil.isNotSynthetic(constructor) && constructor.getModifiers().contains((Object)Modifier.PUBLIC) && ElementsUtil.isWarningNotSuppressed(constructor, "Sting:PublicConstructor")) {
            String message = MemberChecks.shouldNot("sting.Injectable", "have a public constructor. The type is instantiated by the injector and should have a package-access constructor. " + MemberChecks.suppressedBy("Sting:PublicConstructor"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, constructor);
        }
    }

    private void injectableConstructorShouldNotBeProtected(@Nonnull ExecutableElement constructor) {
        if (constructor.getModifiers().contains((Object)Modifier.PROTECTED) && ElementsUtil.isWarningNotSuppressed(constructor, "Sting:ProtectedConstructor")) {
            String message = MemberChecks.shouldNot("sting.Injectable", "have a protected constructor. The type is instantiated by the injector and should have a package-access constructor. " + MemberChecks.suppressedBy("Sting:ProtectedConstructor"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, constructor);
        }
    }

    @Nullable
    private Object loadDescriptor(@Nonnull Element originator, @Nonnull String classname, @Nonnull byte[] data) {
        this.debug(() -> "Loading binary descriptor for " + classname);
        try {
            return this._descriptorIO.read(new DataInputStream(new ByteArrayInputStream(data)), classname);
        }
        catch (UnresolvedDeclaredTypeException e) {
            return null;
        }
        catch (IOException e) {
            throw new ProcessorException("Failed to read the Sting descriptor for the type " + classname + ". Error: " + e, originator);
        }
    }

    @Nullable
    private byte[] tryLoadDescriptorData(@Nonnull TypeElement element) {
        byte[] data = this.tryLoadDescriptorData(StandardLocation.CLASS_PATH, element);
        data = null != data ? data : this.tryLoadDescriptorData(StandardLocation.CLASS_OUTPUT, element);
        return null != data ? data : this.tryLoadDescriptorData(StandardLocation.PLATFORM_CLASS_PATH, element);
    }

    @Nullable
    private byte[] tryLoadDescriptorData(@Nonnull JavaFileManager.Location location, @Nonnull TypeElement element) {
        String[] nameParts = this.extractNameParts(element);
        try {
            return IOUtil.readFully(this.processingEnv.getFiler().getResource(location, nameParts[0], nameParts[1]));
        }
        catch (IOException ignored) {
            return null;
        }
        catch (RuntimeException e) {
            if (e.getClass().getCanonicalName().equals("com.sun.tools.javac.util.ClientCodeException") && e.getCause() instanceof NullPointerException) {
                return null;
            }
            throw e;
        }
    }

    private boolean isParameterized(@Nonnull DeclaredType nestedParameterType) {
        return !((TypeElement)nestedParameterType.asElement()).getTypeParameters().isEmpty();
    }

    @Nonnull
    private List<? extends AnnotationMirror> getScopedAnnotations(@Nonnull Element element) {
        return element.getAnnotationMirrors().stream().filter(a -> AnnotationsUtil.hasAnnotationOfType(a.getAnnotationType().asElement(), "javax.inject.Scope")).collect(Collectors.toList());
    }
}

