/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import sting.processor.ContributorDescriptor;

final class AutoFragmentDescriptor {
    @Nonnull
    private final String _key;
    @Nonnull
    private final TypeElement _element;
    @Nonnull
    private final Collection<ContributorDescriptor> _contributors = new HashSet<ContributorDescriptor>();
    private boolean _fragmentGenerated;
    private boolean _modified;
    private boolean _autoDiscoverableContributors;

    AutoFragmentDescriptor(@Nonnull String key, @Nonnull TypeElement element) {
        this._key = Objects.requireNonNull(key);
        assert (ElementKind.INTERFACE == element.getKind());
        this._element = Objects.requireNonNull(element);
    }

    @Nonnull
    String getKey() {
        return this._key;
    }

    @Nonnull
    TypeElement getElement() {
        return this._element;
    }

    @Nonnull
    Collection<ContributorDescriptor> getContributors() {
        return this._contributors;
    }

    boolean isModified() {
        return this._modified;
    }

    void resetModified() {
        this._modified = false;
    }

    void markAsModified() {
        this._modified = true;
    }

    boolean isFragmentGenerated() {
        return this._fragmentGenerated;
    }

    void markFragmentGenerated() {
        this._fragmentGenerated = true;
    }

    boolean hasAutoDiscoverableContributors() {
        return this._autoDiscoverableContributors;
    }

    void markAsAutoDiscoverableContributors() {
        this._autoDiscoverableContributors = true;
    }
}

