/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.stream.JsonGenerator;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import sting.processor.ServiceSpec;

final class ServiceRequest {
    @Nonnull
    private final Kind _kind;
    @Nonnull
    private final ServiceSpec _service;
    @Nonnull
    private final Element _element;
    private final int _parameterIndex;

    ServiceRequest(@Nonnull Kind kind, @Nonnull ServiceSpec service, @Nonnull Element element, int parameterIndex) {
        this._kind = Objects.requireNonNull(kind);
        this._service = Objects.requireNonNull(service);
        this._element = Objects.requireNonNull(element);
        this._parameterIndex = parameterIndex;
    }

    @Nonnull
    Kind getKind() {
        return this._kind;
    }

    @Nonnull
    ServiceSpec getService() {
        return this._service;
    }

    @Nonnull
    Element getElement() {
        return this._element;
    }

    int getParameterIndex() {
        return this._parameterIndex;
    }

    void write(@Nonnull JsonGenerator g) {
        g.writeStartObject();
        if (Kind.INSTANCE != this._kind) {
            g.write("kind", this._kind.name());
        }
        this._service.write(g);
        g.writeEnd();
    }

    static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind INSTANCE = new Kind(false, false);
        public static final /* enum */ Kind SUPPLIER = new Kind(true, false);
        public static final /* enum */ Kind COLLECTION = new Kind(false, true);
        public static final /* enum */ Kind SUPPLIER_COLLECTION = new Kind(true, true);
        private final boolean _supplier;
        private final boolean _collection;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        private Kind(boolean supplier, boolean collection) {
            this._supplier = supplier;
            this._collection = collection;
        }

        boolean isSupplier() {
            return this._supplier;
        }

        boolean isCollection() {
            return this._collection;
        }

        @Nullable
        TypeMirror extractType(@Nonnull TypeMirror type) {
            if (TypeKind.DECLARED != type.getKind()) {
                return !this._collection && !this._supplier ? type : null;
            }
            DeclaredType declaredTypeL1 = (DeclaredType)type;
            String classnameL1 = this.getClassname(declaredTypeL1);
            List<? extends TypeMirror> typeArgumentsL1 = declaredTypeL1.getTypeArguments();
            if (Collection.class.getName().equals(classnameL1)) {
                if (!this._collection) {
                    return null;
                }
                TypeMirror typeL2 = typeArgumentsL1.get(0);
                assert (TypeKind.DECLARED == typeL2.getKind());
                DeclaredType declaredTypeL2 = (DeclaredType)typeL2;
                String classnameL2 = this.getClassname(declaredTypeL2);
                if (Supplier.class.getName().equals(classnameL2)) {
                    return this._supplier ? this.extractDependencyType(declaredTypeL2.getTypeArguments().get(0)) : null;
                }
                return this.extractDependencyType(typeL2);
            }
            if (Supplier.class.getName().equals(classnameL1)) {
                if (this._collection || !this._supplier) {
                    return null;
                }
                return this.extractDependencyType(typeArgumentsL1.get(0));
            }
            return this.extractDependencyType(declaredTypeL1);
        }

        @Nullable
        private TypeMirror extractDependencyType(@Nonnull TypeMirror type) {
            return TypeKind.DECLARED == type.getKind() && !((DeclaredType)type).getTypeArguments().isEmpty() ? null : type;
        }

        @Nonnull
        private String getClassname(@Nonnull DeclaredType declaredType) {
            return ((TypeElement)declaredType.asElement()).getQualifiedName().toString();
        }

        private static /* synthetic */ Kind[] $values() {
            return new Kind[]{INSTANCE, SUPPLIER, COLLECTION, SUPPLIER_COLLECTION};
        }

        static {
            $VALUES = Kind.$values();
        }
    }
}

