/*
 * Decompiled with CFR 0.152.
 */
package sting.processor.vendor.proton;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import sting.processor.vendor.proton.MemberChecks;
import sting.processor.vendor.proton.ProcessorException;

public final class AnnotationsUtil {
    @Nonnull
    public static final String NULLABLE_CLASSNAME = "javax.annotation.Nullable";
    @Nonnull
    public static final String NONNULL_CLASSNAME = "javax.annotation.Nonnull";

    private AnnotationsUtil() {
    }

    @Nonnull
    public static List<AnnotationMirror> getRepeatingAnnotations(@Nonnull Element typeElement, @Nonnull String containerClassName, @Nonnull String annotationClassName) {
        AnnotationValue annotationValue = AnnotationsUtil.findAnnotationValue(typeElement, containerClassName, "value");
        if (null != annotationValue) {
            return ((List)annotationValue.getValue()).stream().map(v -> (AnnotationMirror)v.getValue()).collect(Collectors.toList());
        }
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(typeElement, annotationClassName);
        return null != annotation ? Collections.singletonList(annotation) : Collections.emptyList();
    }

    @Nonnull
    public static List<TypeMirror> getTypeMirrorsAnnotationParameter(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        return ((List)AnnotationsUtil.getAnnotationValue(annotated, annotationClassName, parameterName).getValue()).stream().map(v -> (TypeMirror)v.getValue()).collect(Collectors.toList());
    }

    @Nonnull
    public static List<TypeElement> getTypeElementsAnnotationParameter(@Nonnull ProcessingEnvironment processingEnv, @Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        return AnnotationsUtil.getTypeMirrorsAnnotationParameter(annotated, annotationClassName, parameterName).stream().map(typeMirror -> (TypeElement)processingEnv.getTypeUtils().asElement((TypeMirror)typeMirror)).collect(Collectors.toList());
    }

    @Nonnull
    public static String getEnumAnnotationParameter(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassname, @Nonnull String parameterName) {
        VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(annotated, annotationClassname, parameterName).getValue();
        return parameter.getSimpleName().toString();
    }

    @Nonnull
    public static AnnotationValue getAnnotationValue(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        AnnotationValue value = AnnotationsUtil.findAnnotationValue(annotated, annotationClassName, parameterName);
        assert (null != value);
        return value;
    }

    @Nullable
    public static AnnotationValue findAnnotationValue(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(annotated, annotationClassName);
        return null == annotation ? null : AnnotationsUtil.findAnnotationValue(annotation, parameterName);
    }

    @Nullable
    public static AnnotationValue findAnnotationValue(@Nonnull AnnotationMirror annotation, @Nonnull String parameterName) {
        Map<ExecutableElement, AnnotationValue> values = AnnotationsUtil.getAnnotationValuesWithDefaults(annotation);
        ExecutableElement annotationKey = values.keySet().stream().filter(k -> parameterName.equals(k.getSimpleName().toString())).findFirst().orElse(null);
        return values.get(annotationKey);
    }

    @Nonnull
    public static Map<ExecutableElement, AnnotationValue> getAnnotationValuesWithDefaults(@Nonnull AnnotationMirror annotation) {
        LinkedHashMap<ExecutableElement, AnnotationValue> values = new LinkedHashMap<ExecutableElement, AnnotationValue>();
        Map<? extends ExecutableElement, ? extends AnnotationValue> declaredValues = annotation.getElementValues();
        List<? extends Element> enclosedElements = annotation.getAnnotationType().asElement().getEnclosedElements();
        for (Element element : enclosedElements) {
            if (ElementKind.METHOD != element.getKind()) continue;
            ExecutableElement method = (ExecutableElement)element;
            if (declaredValues.containsKey(method)) {
                values.put(method, declaredValues.get(method));
                continue;
            }
            AnnotationValue defaultValue = method.getDefaultValue();
            assert (null != defaultValue);
            values.put(method, defaultValue);
        }
        return values;
    }

    @Nullable
    public static AnnotationValue findAnnotationValueNoDefaults(@Nonnull AnnotationMirror annotation, @Nonnull String parameterName) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        ExecutableElement annotationKey = values.keySet().stream().filter(k -> parameterName.equals(k.getSimpleName().toString())).findFirst().orElse(null);
        return values.get(annotationKey);
    }

    @Nonnull
    public static AnnotationValue getAnnotationValue(@Nonnull AnnotationMirror annotation, @Nonnull String parameterName) {
        AnnotationValue value = AnnotationsUtil.findAnnotationValue(annotation, parameterName);
        assert (null != value);
        return value;
    }

    @Nonnull
    public static <T> T getAnnotationValueValue(@Nonnull AnnotationMirror annotation, @Nonnull String parameterName) {
        return (T)AnnotationsUtil.getAnnotationValue(annotation, parameterName).getValue();
    }

    @Nonnull
    public static AnnotationMirror getAnnotationByType(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName) {
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(annotated, annotationClassName);
        assert (null != annotation);
        return annotation;
    }

    @Nullable
    public static AnnotationMirror findAnnotationByType(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName) {
        return annotated.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(annotationClassName)).findFirst().orElse(null);
    }

    public static boolean hasAnnotationOfType(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName) {
        return null != AnnotationsUtil.findAnnotationByType(annotated, annotationClassName);
    }

    @Nonnull
    public static String extractName(@Nonnull ExecutableElement method, @Nonnull Function<ExecutableElement, String> defaultExtractor, @Nonnull String annotationClassname, @Nonnull String parameterName, @Nonnull String sentinelValue) {
        String declaredName = (String)AnnotationsUtil.getAnnotationValue(method, annotationClassname, parameterName).getValue();
        if (sentinelValue.equals(declaredName)) {
            String defaultValue = defaultExtractor.apply(method);
            if (null == defaultValue) {
                throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target did not specify the parameter " + parameterName + " and the default value could not be derived", method);
            }
            return defaultValue;
        }
        if (!SourceVersion.isIdentifier(declaredName)) {
            throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target specified an invalid value '" + declaredName + "' for the parameter " + parameterName + ". The value must be a valid java identifier", method);
        }
        if (SourceVersion.isKeyword(declaredName)) {
            throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target specified an invalid value '" + declaredName + "' for the parameter " + parameterName + ". The value must not be a java keyword", method);
        }
        return declaredName;
    }

    public static boolean hasNonnullAnnotation(@Nonnull Element element) {
        return AnnotationsUtil.hasAnnotationOfType(element, NONNULL_CLASSNAME);
    }

    public static boolean hasNullableAnnotation(@Nonnull Element element) {
        return AnnotationsUtil.hasAnnotationOfType(element, NULLABLE_CLASSNAME);
    }
}

