/*
 * Decompiled with CFR 0.152.
 */
package zifnab.hdf;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import zifnab.hdf.DataElement;
import zifnab.hdf.DataNode;
import zifnab.hdf.SourceLocation;

public final class DataComment
extends DataNode {
    @Nullable
    private final DataElement _parent;
    @Nonnull
    private final String _comment;

    DataComment(@Nullable SourceLocation location, @Nullable DataElement parent, @Nonnull String comment) {
        super(location);
        assert (!comment.contains("\n"));
        this._parent = parent;
        this._comment = Objects.requireNonNull(comment);
        if (null != this._parent) {
            this._parent.append(this);
        }
    }

    @Nullable
    public DataElement getParent() {
        return this._parent;
    }

    @Nonnull
    public String getComment() {
        return this._comment;
    }

    @Override
    void write(@Nonnull Writer writer, int depth) throws IOException {
        this.writeIndent(writer, depth);
        if (this._comment.isEmpty()) {
            writer.write("#\n");
        } else {
            writer.write("# ");
            writer.write(this._comment);
            writer.write(10);
        }
    }
}

