/*
 * Decompiled with CFR 0.152.
 */
package zifnab.hdf;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import zifnab.hdf.DataComment;
import zifnab.hdf.DataElement;
import zifnab.hdf.DataNode;
import zifnab.hdf.SourceLocation;

public final class DataDocument {
    @Nullable
    private List<DataNode> _children;

    @Nonnull
    public List<DataNode> getChildren() {
        return null == this._children ? Collections.emptyList() : Collections.unmodifiableList(this._children);
    }

    @Nonnull
    public List<DataElement> getChildElements() {
        return null == this._children ? Collections.emptyList() : Collections.unmodifiableList(this._children.stream().filter(e -> e instanceof DataElement).map(e -> (DataElement)e).collect(Collectors.toList()));
    }

    @Nonnull
    public DataElement element(String ... tokens) {
        return this.element((SourceLocation)null, tokens);
    }

    @Nonnull
    public DataElement element(@Nullable SourceLocation location, String ... tokens) {
        DataElement element = new DataElement(location, null, tokens);
        this.append(element);
        return element;
    }

    @Nonnull
    public DataComment comment(@Nonnull String comment) {
        return this.comment(null, comment);
    }

    @Nonnull
    public DataComment comment(@Nullable SourceLocation location, @Nonnull String comment) {
        DataComment node = new DataComment(location, null, comment);
        this.append(node);
        return node;
    }

    private void append(@Nonnull DataNode child) {
        if (null == this._children) {
            this._children = new ArrayList<DataNode>();
        }
        this._children.add(Objects.requireNonNull(child));
    }

    void write(@Nonnull Writer writer) throws IOException {
        int lastLineNumber = -1;
        boolean lastChildWasAnElement = false;
        for (DataNode child : this.getChildren()) {
            int lineNumber;
            SourceLocation location = child.getLocation();
            int n = lineNumber = null == location ? -1 : location.getLineNumber();
            if (lastChildWasAnElement || -1 != lastLineNumber && -1 != lineNumber && lastLineNumber != lineNumber - 1) {
                writer.write("\n");
            }
            child.write(writer, 0);
            lastChildWasAnElement = child instanceof DataElement;
            lastLineNumber = null == location ? -1 : location.getLineNumber();
        }
    }
}

