/*
 * Decompiled with CFR 0.152.
 */
package zifnab.hdf;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import zifnab.hdf.DataAccessException;
import zifnab.hdf.DataComment;
import zifnab.hdf.DataNode;
import zifnab.hdf.SourceLocation;

public final class DataElement
extends DataNode {
    @Nullable
    private final DataElement _parent;
    @Nonnull
    private final List<String> _tokens;
    @Nullable
    private List<DataNode> _children;

    DataElement(@Nullable SourceLocation location, @Nullable DataElement parent, String ... tokens) {
        super(location);
        this._parent = parent;
        this._tokens = Collections.unmodifiableList(Arrays.asList((Object[])Objects.requireNonNull(tokens)));
        assert (!this._tokens.isEmpty());
        assert (this._tokens.stream().noneMatch(line -> line.contains("\n")));
        if (null != this._parent) {
            this._parent.append(this);
        }
    }

    @Nullable
    public DataElement getParent() {
        return this._parent;
    }

    @Nonnull
    public String getName() {
        return Objects.requireNonNull(this._tokens.get(0));
    }

    @Nonnull
    public List<String> getTokens() {
        return Collections.unmodifiableList(this._tokens);
    }

    public int getTokenCount() {
        return this._tokens.size();
    }

    public void assertLeafNode() {
        int childCount = this.getChildElements().size();
        if (0 != childCount) {
            String message = "Data element named '" + this.getName() + "' expected to have 0 children but has " + childCount + " children";
            throw new DataAccessException(message, this.getLocation());
        }
    }

    public void assertTokenName(@Nonnull String name) {
        if (!name.equals(this.getName())) {
            String message = "Data element named '" + this.getName() + "' expected to be named '" + name + "'";
            throw new DataAccessException(message, this.getLocation());
        }
    }

    public void assertTokenCount(int length) {
        int size = this.getTokenCount();
        if (length != size) {
            String message = "Data element named '" + this.getName() + "' expected to contain " + length + " tokens but contains " + size + " tokens";
            throw new DataAccessException(message, this.getLocation());
        }
    }

    public void assertTokenCounts(Integer ... tokenCounts) {
        int size = this.getTokenCount();
        Integer[] integerArray = tokenCounts;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int tokenCount = integerArray[i];
            if (size != tokenCount) continue;
            return;
        }
        String message = "Data element named '" + this.getName() + "' expected to contain tokens with a count matching one of " + Arrays.asList(tokenCounts) + " but contains " + size + " tokens";
        throw new DataAccessException(message, this.getLocation());
    }

    public void assertTokenCountRange(int minLength, int maxLength) {
        int size = this.getTokenCount();
        if (size < minLength || size > maxLength) {
            String message = "Data element named '" + this.getName() + "' expected to contain between " + minLength + " and " + maxLength + " tokens but contains " + size + " tokens";
            throw new DataAccessException(message, this.getLocation());
        }
    }

    @Nonnull
    public String getStringAt(int index) {
        if (index >= this.getTokenCount()) {
            String message = "Data element named '" + this.getName() + "' does not contain a token at index " + index;
            throw new DataAccessException(message, this.getLocation());
        }
        return Objects.requireNonNull(this._tokens.get(index));
    }

    public int getIntAt(int index) {
        String token = this.getStringAt(index);
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new DataAccessException("Token at index " + index + " for data element named '" + this.getName() + "' has value '" + token + "' which is not an integer", this.getLocation());
        }
    }

    public int getIntAt(int index, int min) {
        int value = this.getIntAt(index);
        if (min > value) {
            throw new DataAccessException("Token at index " + index + " for data element named '" + this.getName() + "' has value '" + value + "' which is below the expected minimum value " + min, this.getLocation());
        }
        return value;
    }

    public double getDoubleAt(int index) {
        String token = this.getStringAt(index);
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException e) {
            throw new DataAccessException("Token at index " + index + " for data element named '" + this.getName() + "' has value '" + token + "' which is not an double", this.getLocation());
        }
    }

    public double getDoubleAt(int index, double min) {
        double value = this.getDoubleAt(index);
        if (min > value) {
            throw new DataAccessException("Token at index " + index + " for data element named '" + this.getName() + "' has value '" + value + "' which is below the expected minimum value " + min, this.getLocation());
        }
        return value;
    }

    public double getDoubleAt(int index, double min, double max) {
        double value = this.getDoubleAt(index, min);
        if (max < value) {
            throw new DataAccessException("Token at index " + index + " for data element named '" + this.getName() + "' has value '" + value + "' which is above the expected maximum value " + min, this.getLocation());
        }
        return value;
    }

    @Nonnull
    public List<DataNode> getChildren() {
        return null == this._children ? Collections.emptyList() : Collections.unmodifiableList(this._children);
    }

    @Nonnull
    public List<DataElement> getChildElements() {
        return null == this._children ? Collections.emptyList() : Collections.unmodifiableList(this._children.stream().filter(e -> e instanceof DataElement).map(e -> (DataElement)e).collect(Collectors.toList()));
    }

    @Nonnull
    public DataElement element(String ... tokens) {
        return this.element((SourceLocation)null, tokens);
    }

    @Nonnull
    public DataElement element(@Nullable SourceLocation location, String ... tokens) {
        return new DataElement(location, this, tokens);
    }

    @Nonnull
    public DataComment comment(@Nonnull String comment) {
        return this.comment(null, comment);
    }

    @Nonnull
    public DataComment comment(@Nullable SourceLocation location, @Nonnull String comment) {
        return new DataComment(location, this, comment);
    }

    void append(@Nonnull DataNode child) {
        if (null == this._children) {
            this._children = new ArrayList<DataNode>();
        }
        this._children.add(Objects.requireNonNull(child));
    }

    @Override
    void write(@Nonnull Writer writer, int depth) throws IOException {
        this.writeSelf(writer, depth);
        this.writeChildren(writer, depth);
    }

    private void writeSelf(@Nonnull Writer writer, int depth) throws IOException {
        this.writeIndent(writer, depth);
        this.writeTokens(writer);
    }

    private void writeChildren(@Nonnull Writer writer, int depth) throws IOException {
        for (DataNode child : this.getChildren()) {
            child.write(writer, depth + 1);
        }
    }

    private void writeTokens(@Nonnull Writer writer) throws IOException {
        List<String> tokens = this.getTokens();
        assert (!tokens.isEmpty());
        boolean first = true;
        for (String token : tokens) {
            if (!first) {
                writer.write(32);
            }
            first = false;
            this.writeToken(writer, token);
        }
        writer.write(10);
    }

    private void writeToken(@Nonnull Writer writer, @Nonnull String token) throws IOException {
        if (token.isEmpty()) {
            writer.write("\"\"");
        } else {
            boolean tokenContainsQuote = token.contains("\"");
            if (tokenContainsQuote) {
                writer.write(96);
                writer.write(token);
                writer.write(96);
            } else {
                boolean tokenContainsSpace;
                boolean bl = tokenContainsSpace = token.contains(" ") || token.contains("\t");
                if (tokenContainsSpace) {
                    writer.write(34);
                    writer.write(token);
                    writer.write(34);
                } else {
                    writer.write(token);
                }
            }
        }
    }
}

