/*
 * Decompiled with CFR 0.152.
 */
package zifnab.hdf;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import zifnab.hdf.DataDocument;
import zifnab.hdf.DataElement;
import zifnab.hdf.DataNode;
import zifnab.hdf.DataParseException;
import zifnab.hdf.SourceLocation;

final class Parser {
    @Nonnull
    private final DataDocument _document = new DataDocument();
    @Nonnull
    private final String _location;
    @Nonnull
    private final LineNumberReader _reader;
    @Nullable
    private DataElement _parentNode;
    @Nullable
    private DataNode _lastNode;
    private int _indent = 0;
    private int _column;
    private String _line;

    @Nonnull
    Parser(@Nonnull String location, @Nonnull LineNumberReader reader) throws IOException, DataParseException {
        this._location = Objects.requireNonNull(location);
        this._reader = Objects.requireNonNull(reader);
        this.parseDocument();
    }

    @Nonnull
    DataDocument getDocument() {
        return this._document;
    }

    private void parseDocument() throws IOException, DataParseException {
        while (null != (this._line = this.readLine())) {
            this.parseLine();
        }
    }

    private void parseLine() throws DataParseException {
        int length = this._line.length();
        if (0 != length) {
            this._column = 0;
            this.parseIndentation();
            if (length > this._column) {
                if ('#' == this._line.charAt(this._column)) {
                    SourceLocation location = this.newLocation();
                    String comment = length > this._column + 1 && ' ' == this._line.charAt(this._column + 1) ? this._line.substring(this._column + 2) : this._line.substring(this._column + 1);
                    this._lastNode = null == this._parentNode ? this._document.comment(location, comment) : this._parentNode.comment(location, comment);
                } else {
                    SourceLocation location = this.newLocation();
                    String[] tokens = this.parseTokens();
                    this._lastNode = null == this._parentNode ? this._document.element(location, tokens) : this._parentNode.element(location, tokens);
                }
            }
        }
    }

    @Nonnull
    private String[] parseTokens() throws DataParseException {
        String token;
        ArrayList<String> tokens = new ArrayList<String>();
        while (null != (token = this.parseToken())) {
            tokens.add(token);
        }
        return tokens.toArray(new String[0]);
    }

    @Nullable
    private String parseToken() throws DataParseException {
        this.stripWhiteSpace();
        if (this._line.length() == this._column) {
            return null;
        }
        if ('`' == this._line.charAt(this._column)) {
            return this.parseBackTickedToken();
        }
        if ('\"' == this._line.charAt(this._column)) {
            return this.parseQuotedToken();
        }
        return this.parseRawToken();
    }

    @Nonnull
    private String parseBackTickedToken() throws DataParseException {
        assert ('`' == this._line.charAt(this._column));
        ++this._column;
        StringBuilder sb = new StringBuilder();
        while (this._line.length() > this._column && '`' != this._line.charAt(this._column)) {
            sb.append(this._line.charAt(this._column));
            ++this._column;
        }
        if (this._line.length() == this._column) {
            throw this.newDataParseException("Quoted token missing closing `");
        }
        ++this._column;
        return sb.toString();
    }

    @Nonnull
    private String parseQuotedToken() throws DataParseException {
        assert ('\"' == this._line.charAt(this._column));
        ++this._column;
        StringBuilder sb = new StringBuilder();
        while (this._line.length() > this._column && '\"' != this._line.charAt(this._column)) {
            sb.append(this._line.charAt(this._column));
            ++this._column;
        }
        if (this._line.length() == this._column) {
            throw this.newDataParseException("Quoted token missing closing \"");
        }
        ++this._column;
        return sb.toString();
    }

    @Nonnull
    private String parseRawToken() {
        StringBuilder sb = new StringBuilder();
        while (this._line.length() > this._column && ' ' != this._line.charAt(this._column)) {
            sb.append(this._line.charAt(this._column));
            ++this._column;
        }
        return sb.toString();
    }

    private void stripWhiteSpace() {
        while (this._line.length() > this._column && ' ' == this._line.charAt(this._column)) {
            ++this._column;
        }
    }

    private void parseIndentation() throws DataParseException {
        int indent = 0;
        while (this._line.length() > this._column && this._line.charAt(this._column) == '\t') {
            ++this._column;
            ++indent;
        }
        if (this._line.length() <= this._column) {
            return;
        }
        if (indent > this._indent + 1) {
            String message = "Invalid file. Moved from indent level " + this._indent + " to indent level " + indent;
            throw this.newDataParseException(message);
        }
        if (indent == this._indent + 1) {
            if (null == this._lastNode) {
                throw this.newDataParseException("Attempted to define node without a parent node");
            }
            if (!(this._lastNode instanceof DataElement)) {
                throw this.newDataParseException("Attempted to define node below a comment");
            }
            this._parentNode = (DataElement)this._lastNode;
        } else if (indent < this._indent) {
            int downSteps = this._indent - indent;
            for (int i = 0; i < downSteps; ++i) {
                assert (null != this._parentNode);
                this._parentNode = this._parentNode.getParent();
            }
        }
        this._indent = indent;
    }

    @Nonnull
    private DataParseException newDataParseException(String message) {
        return new DataParseException(message, this.newLocation());
    }

    @Nonnull
    private SourceLocation newLocation() {
        return new SourceLocation(this._location, this._reader.getLineNumber(), this._column);
    }

    @Nullable
    private String readLine() throws IOException {
        return this._reader.readLine();
    }
}

