/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j;

import org.neo4j.graphdb.Relationship;
import org.reco4j.graph.BasicEdge;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.Neo4JNode;

public class Neo4JEdge
extends BasicEdge {
    private Relationship edge;
    private INode source;
    private INode destination;

    public Neo4JEdge(Relationship edge) {
        this.setEdge(edge);
    }

    public void setProperty(String name, String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getProperty(String name) {
        Object value = this.edge.getProperty(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value == null) {
            StringBuilder exception = new StringBuilder();
            exception.append("getProperty conversion data not supported! Not available property '").append(name).append("'on node!\n");
            exception.append("Available properties are:\n");
            for (String key : this.edge.getPropertyKeys()) {
                exception.append(key).append("\n");
            }
            throw new RuntimeException(exception.toString());
        }
        throw new RuntimeException("getProperty conversion data not supported! Not supported data type for property '" + name + "': " + value.getClass());
    }

    public INode getSource() {
        return this.source;
    }

    public INode getDestination() {
        return this.destination;
    }

    public Relationship getEdge() {
        return this.edge;
    }

    public void setEdge(Relationship edge) {
        this.edge = edge;
        this.destination = new Neo4JNode(edge.getEndNode());
        this.source = new Neo4JNode(edge.getStartNode());
    }

    public void setSource(INode source) {
        this.source = source;
    }

    public void setDestination(INode destination) {
        this.destination = destination;
    }

    public String getPermissiveProperty(String name) {
        if (!this.edge.hasProperty(name)) {
            return null;
        }
        Object value = this.edge.getProperty(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value == null) {
            return null;
        }
        throw new RuntimeException("getProperty conversion data not supported! Not supported data type for property '" + name + "': " + value.getClass());
    }
}

