/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j;

import java.util.HashMap;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.reco4j.graph.BasicNode;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.IEdgeType;
import org.reco4j.graph.IGraphCallable;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.traversal.GraphTraversal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4JNode
extends BasicNode {
    private Node node;

    public Neo4JNode(Node node) {
        this.node = node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public void setProperty(String name, String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getProperty(String name) {
        Object value = this.node.getProperty(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value == null) {
            StringBuilder exception = new StringBuilder();
            exception.append("getProperty conversion data not supported! Not available property '").append(name).append("'on node!\n");
            exception.append("Available properties are:\n");
            for (String key : this.node.getPropertyKeys()) {
                exception.append(key).append("\n");
            }
            throw new RuntimeException(exception.toString());
        }
        throw new RuntimeException("getProperty conversion data not supported! Not supported data type for property '" + name + "': " + value.getClass());
    }

    public Boolean isConnected(INode b, IEdgeType edgeType) {
        return GraphTraversal.getInstance().isConnected((INode)this, b, edgeType);
    }

    public Boolean isConnected(INode node, List<IEdgeType> edgeTypes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Boolean isConnectedIn(INode node, List<IEdgeType> edgeTypes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Boolean isConnectedOut(INode node, List<IEdgeType> edgeTypes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IEdge getEdge(INode node, IEdgeType edgeType) {
        IEdge edge = GraphTraversal.getInstance().getEdge((INode)this, node, edgeType);
        return edge;
    }

    public List<IEdge> getInEdge(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getInEdge((INode)this, edgeType);
    }

    public List<IEdge> getOutEdge(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getOutEdge((INode)this, edgeType);
    }

    public HashMap<Long, INode> getCommonNodes(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getCommonNodes((INode)this, edgeType);
    }

    public void iterateOnCommonNodes(IEdgeType edgeType, IGraphCallable<INode> callback) {
        GraphTraversal.getInstance().getCommonNodes((INode)this, edgeType, callback);
    }

    public int getInEdgeNumber(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getInEdgeNumber((INode)this, edgeType);
    }
}

