/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.IEdgeType;
import org.reco4j.graph.IGraph;
import org.reco4j.graph.IGraphCallable;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.traversal.GraphTraversal;
import org.reco4j.graph.neo4j.util.Neo4JPropertiesHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4jGraph
implements IGraph {
    private GraphDatabaseService graphDB;
    private boolean isTest = false;
    private Logger logger = Logger.getLogger(Neo4jGraph.class.getName());

    public void initDatabase() {
        String dbPath = Neo4JPropertiesHandle.getInstance().getDBPath();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("use_memory_mapped_buffers", "false");
        config.put("neostore.nodestore.db.mapped_memory", "800M");
        config.put("neostore.relationshipstore.db.mapped_memory", "100M");
        config.put("neostore.propertystore.db.mapped_memory", "100M");
        config.put("neostore.propertystore.db.index.mapped_memory", "1M");
        config.put("neostore.propertystore.db.index.keys.mapped_memory", "1M");
        config.put("neostore.propertystore.db.strings.mapped_memory", "150M");
        config.put("neostore.propertystore.db.arrays.mapped_memory", "0M");
        this.graphDB = (EmbeddedGraphDatabase)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dbPath).setConfig(config).newGraphDatabase();
        Neo4jGraph.registerShutdownHook(this.graphDB);
        GraphTraversal.getInstance().init(this.graphDB);
    }

    public void setDatabase(GraphDatabaseService graphDB) {
        this.graphDB = graphDB;
        GraphTraversal.getInstance().init(graphDB);
    }

    public List<INode> getNeighbours(List<IEdgeType> edgesType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<INode> getNodesByType(String type) {
        return GraphTraversal.getInstance().getNodesByType(type);
    }

    public List<INode> getNodesByInEdge(IEdgeType edgesType) {
        return GraphTraversal.getInstance().getNodesByInEdge(edgesType);
    }

    public void setProperties(Properties properties) {
        Neo4JPropertiesHandle.getInstance().setProperties(properties);
    }

    public void loadGraph() {
    }

    private static void registerShutdownHook(final GraphDatabaseService graphDb) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("Shuting down neo4j db instance ...");
                graphDb.shutdown();
                System.out.println("... done!");
            }
        });
    }

    public GraphDatabaseService getGraphDB() {
        return this.graphDB;
    }

    public boolean isIsTest() {
        return this.isTest;
    }

    public void setIsTest(boolean isTest) {
        this.isTest = isTest;
    }

    public void addEdge(INode x, INode y, IEdgeType similarityEdgeType, String propertyName, String value) {
        GraphTraversal.getInstance().addEdge(x, y, similarityEdgeType, propertyName, value);
    }

    public void setEdgeProperty(IEdge edge, String propertyName, String value) {
        GraphTraversal.getInstance().setEdgeProperty(edge, propertyName, value);
    }

    public List<IEdge> getEdgesByType(IEdgeType edgesType) {
        return GraphTraversal.getInstance().getEdgesByType(edgesType);
    }

    public HashMap<String, INode> getNodesMapByType(String type, String identifier) {
        return GraphTraversal.getInstance().getNodesMapByType(type, identifier);
    }

    public void optimizeGraph() {
    }

    public void tidyUpGraph() {
    }

    public void getNodesByType(String type, IGraphCallable<INode> callback) {
        GraphTraversal.getInstance().getNodesByType(type, callback);
    }
}

