/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j.engine;

import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.reco4j.graph.IGraph;
import org.reco4j.graph.engine.RecommenderEngine;
import org.reco4j.graph.neo4j.Neo4jGraph;
import org.reco4j.graph.recommenders.IRecommender;
import org.reco4j.graph.recommenders.RecommenderEvaluator;
import org.reco4j.session.RecommenderSessionManager;

public class RecommenderNeo4jEngine {
    private static Logger logger = Logger.getLogger(RecommenderNeo4jEngine.class);
    private Neo4jGraph learningDataSet;
    private Neo4jGraph testingDataSet;

    public void setUP(Properties properties) {
        this.learningDataSet = new Neo4jGraph();
        this.learningDataSet.setProperties(properties);
        this.learningDataSet.initDatabase();
        RecommenderSessionManager.getInstance().setLearningDataSet((IGraph)this.learningDataSet);
        this.testingDataSet = new Neo4jGraph();
        this.testingDataSet.setProperties(properties);
        this.testingDataSet.setDatabase(this.learningDataSet.getGraphDB());
        this.testingDataSet.setIsTest(true);
        RecommenderSessionManager.getInstance().setTestingDataSet((IGraph)this.testingDataSet);
    }

    public static void main(String[] args) {
        Properties properties = RecommenderNeo4jEngine.loadProperties();
        RecommenderNeo4jEngine reco = new RecommenderNeo4jEngine();
        reco.setUP(properties);
        IRecommender recommender = RecommenderEngine.createRecommender((Properties)properties);
        recommender.loadRecommender((IGraph)reco.learningDataSet);
        recommender.buildRecommender((IGraph)reco.learningDataSet);
        RecommenderEvaluator.evaluateRecommender((IGraph)reco.getTestingDataSet(), (IRecommender)recommender);
    }

    public static Properties loadProperties() {
        Properties properties = new Properties();
        try {
            properties.load(RecommenderNeo4jEngine.class.getResourceAsStream("init.properties"));
        }
        catch (IOException ex) {
            logger.error((Object)"Error while loading properties", (Throwable)ex);
        }
        return properties;
    }

    public Neo4jGraph getLearningDataSet() {
        return this.learningDataSet;
    }

    public void setLearningDataSet(Neo4jGraph learningDataSet) {
        this.learningDataSet = learningDataSet;
    }

    public Neo4jGraph getTestingDataSet() {
        return this.testingDataSet;
    }

    public void setTestingDataSet(Neo4jGraph testingDataSet) {
        this.testingDataSet = testingDataSet;
    }
}

