/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j.plugin;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.Neo4JNode;
import org.reco4j.graph.neo4j.engine.RecommenderNeo4jEngineManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Description(value="An extension to the Neo4j Server for recommendation getting from reco4j")
public class Reco4jRecommender
extends ServerPlugin {
    @Name(value="get_recommendations")
    @Description(value="Get recommendation for a user")
    @PluginTarget(value=Node.class)
    public Iterable<Node> getRecommendations(@Source Node source, @Description(value="The type of recommender to use") @Parameter(name="type", optional=true) int type) {
        Logger.getLogger(Reco4jRecommender.class.getName()).log(Level.WARNING, "Reco4jRecommender ... ... chiamato!");
        return RecommenderNeo4jEngineManager.getInstance().getRecommender((INode)new Neo4JNode(source), type);
    }

    @Name(value="get_users")
    @Description(value="Get all users managed by the recommender accrodingly to its configuration")
    @PluginTarget(value=GraphDatabaseService.class)
    public Iterable<Node> getAllNodes(@Source GraphDatabaseService graphDb) {
        return RecommenderNeo4jEngineManager.getInstance().getUsers();
    }

    @Name(value="get_items")
    @Description(value="Get all item managed by the recommender accrodingly to its configuration")
    @PluginTarget(value=GraphDatabaseService.class)
    public Iterable<Node> getItems(@Source GraphDatabaseService graphDb) {
        return RecommenderNeo4jEngineManager.getInstance().getItems();
    }

    @Name(value="get_ratings")
    @Description(value="Get ratings given by a user")
    @PluginTarget(value=Node.class)
    public Iterable<Relationship> getRatings(@Source Node source) {
        return RecommenderNeo4jEngineManager.getInstance().getRatings(source);
    }

    @Name(value="get_testratings")
    @Description(value="Get test ratings given by a user")
    @PluginTarget(value=Node.class)
    public Iterable<Relationship> getTestRatings(@Source Node source) {
        return RecommenderNeo4jEngineManager.getInstance().getRatingsTest(source);
    }
}

