/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j.traversal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.tooling.GlobalGraphOperations;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.IEdgeType;
import org.reco4j.graph.IGraphCallable;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.Neo4JEdge;
import org.reco4j.graph.neo4j.Neo4JNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphTraversal {
    private static GraphDatabaseService graphDB;

    public static GraphTraversal getInstance() {
        return GraphTraversalHolder.INSTANCE;
    }

    public void init(GraphDatabaseService graphDB) {
        GraphTraversal.graphDB = graphDB;
    }

    private static void shutdown() {
        graphDB.shutdown();
    }

    public List<INode> getNodesByType(String type) {
        Index idx_node_type = graphDB.index().forNodes("idx_node_type");
        IndexHits result = idx_node_type.get("type", (Object)type);
        return this.getNodeList((IndexHits<Node>)result);
    }

    public HashMap<String, INode> getNodesMapByType(String type, String identifier) {
        HashMap<String, INode> nodes = new HashMap<String, INode>();
        Index idx_node_type = graphDB.index().forNodes("idx_node_type");
        IndexHits result = idx_node_type.get("type", (Object)type);
        while (result.hasNext()) {
            Node item = (Node)result.next();
            Neo4JNode node = new Neo4JNode(item);
            nodes.put((String)item.getProperty(identifier), (INode)node);
        }
        return nodes;
    }

    public void getNodesByType(String type, IGraphCallable<INode> callback) {
        Index idx_node_type = graphDB.index().forNodes("idx_node_type");
        IndexHits result = idx_node_type.get("type", (Object)type);
        while (result.hasNext()) {
            Neo4JNode node = new Neo4JNode((Node)result.next());
            callback.call((Object)node);
        }
    }

    public List<IEdge> getEdgesByType(IEdgeType edgeType) {
        String type = edgeType.getEdgeName();
        Iterable allRelationships = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllRelationships();
        ArrayList<IEdge> edges = new ArrayList<IEdge>();
        for (Relationship next : allRelationships) {
            if (!next.isType((RelationshipType)DynamicRelationshipType.withName((String)type))) continue;
            Neo4JEdge edge = new Neo4JEdge(next);
            edges.add((IEdge)edge);
        }
        return edges;
    }

    public List<INode> getNodesByInEdge(IEdgeType edgesType) {
        Iterable allRelationships = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllRelationships();
        ArrayList<INode> nodes = new ArrayList<INode>();
        RelationshipType relationshipType = this.getRelationshipTypeByEdgeType(edgesType);
        for (Relationship next : allRelationships) {
            if (!next.isType(relationshipType)) continue;
            Node item = next.getEndNode();
            Neo4JNode node = new Neo4JNode(item);
            nodes.add((INode)node);
        }
        return nodes;
    }

    public List<IEdge> getInEdge(INode inode, IEdgeType edgesType) {
        Node nodeTmp = ((Neo4JNode)inode).getNode();
        Iterable edgeList = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.INCOMING);
        return this.getIEdgeList(edgeList);
    }

    public List<IEdge> getOutEdge(INode inode, IEdgeType edgesType) {
        Node nodeTmp = ((Neo4JNode)inode).getNode();
        Iterable edgeList = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.OUTGOING);
        return this.getIEdgeList(edgeList);
    }

    public Boolean isConnected(INode x, INode y, IEdgeType edgesType) {
        Node a = ((Neo4JNode)x).getNode();
        Node b = ((Neo4JNode)y).getNode();
        Iterable edgeList = a.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.BOTH);
        for (Relationship edge : edgeList) {
            Node otherNode = edge.getOtherNode(a);
            if (otherNode.getId() != b.getId()) continue;
            return true;
        }
        return false;
    }

    public IEdge getEdge(INode x, INode y, IEdgeType edgesType) {
        Node a = ((Neo4JNode)x).getNode();
        Node b = ((Neo4JNode)y).getNode();
        Iterable edgeList = a.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.BOTH);
        for (Relationship edge : edgeList) {
            if (edge.getOtherNode(a).getId() != b.getId()) continue;
            return new Neo4JEdge(edge);
        }
        return null;
    }

    public HashMap<Long, INode> getCommonNodes(INode node, IEdgeType edgesType) {
        HashMap<Long, INode> nodes = new HashMap<Long, INode>();
        Node nodeTmp = ((Neo4JNode)node).getNode();
        Iterable inRelationships = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.INCOMING);
        for (Relationship inRelationship : inRelationships) {
            Node source = inRelationship.getStartNode();
            Iterable outRelationships = source.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.OUTGOING);
            for (Relationship outRelationship : outRelationships) {
                Node dest = outRelationship.getEndNode();
                if (dest.getId() == nodeTmp.getId() || nodes.containsKey(dest.getId())) continue;
                nodes.put(dest.getId(), (INode)new Neo4JNode(dest));
            }
        }
        return nodes;
    }

    public void getCommonNodes(INode node, IEdgeType edgesType, IGraphCallable<INode> callback) {
        HashMap<Long, Neo4JNode> nodes = new HashMap<Long, Neo4JNode>();
        Node nodeTmp = ((Neo4JNode)node).getNode();
        Iterable inRelationships = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.INCOMING);
        for (Relationship inRelationship : inRelationships) {
            Node source = inRelationship.getStartNode();
            Iterable outRelationships = source.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.OUTGOING);
            for (Relationship outRelationship : outRelationships) {
                Node dest = outRelationship.getEndNode();
                if (dest.getId() == nodeTmp.getId() || nodes.containsKey(dest.getId())) continue;
                Neo4JNode neo4JNode = new Neo4JNode(dest);
                nodes.put(dest.getId(), neo4JNode);
                callback.call((Object)neo4JNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdge(INode x, INode y, IEdgeType similarityEdgeType, String propertyName, String value) {
        Node source = ((Neo4JNode)x).getNode();
        Node dest = ((Neo4JNode)y).getNode();
        Transaction tx = graphDB.beginTx();
        try {
            Relationship createRelationshipTo = source.createRelationshipTo(dest, this.getRelationshipTypeByEdgeType(similarityEdgeType));
            createRelationshipTo.setProperty(propertyName, (Object)value);
            tx.success();
        }
        catch (Exception ex) {
            tx.failure();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error during addEdgeTransaction: ", ex);
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEdgeProperty(IEdge edge, String propertyName, String value) {
        Relationship rel = ((Neo4JEdge)edge).getEdge();
        Transaction tx = graphDB.beginTx();
        try {
            rel.setProperty(propertyName, (Object)value);
            tx.success();
        }
        catch (Exception ex) {
            tx.failure();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error during addEdgeTransaction: ", ex);
        }
        finally {
            tx.finish();
        }
    }

    public int getInEdgeNumber(INode node, IEdgeType edgeType) {
        Node nodeTmp = ((Neo4JNode)node).getNode();
        Iterable edgeList = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgeType), Direction.INCOMING);
        return this.getIEdgeList(edgeList).size();
    }

    private List<IEdge> getIEdgeList(Iterable<Relationship> allRelationships, String type) {
        ArrayList<IEdge> edges = new ArrayList<IEdge>();
        for (Relationship next : allRelationships) {
            if (!next.isType((RelationshipType)DynamicRelationshipType.withName((String)type))) continue;
            Neo4JEdge edge = new Neo4JEdge(next);
            edges.add((IEdge)edge);
        }
        return edges;
    }

    private List<IEdge> getIEdgeList(Iterable<Relationship> allRelationships) {
        ArrayList<IEdge> edges = new ArrayList<IEdge>();
        for (Relationship next : allRelationships) {
            Neo4JEdge edge = new Neo4JEdge(next);
            edges.add((IEdge)edge);
        }
        return edges;
    }

    private List<INode> getNodeList(IndexHits<Node> result) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        while (result.hasNext()) {
            Neo4JNode node = new Neo4JNode((Node)result.next());
            nodes.add((INode)node);
        }
        return nodes;
    }

    private RelationshipType getRelationshipTypeByEdgeType(IEdgeType edgesType) {
        String edges = edgesType.getEdgeName();
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)edges);
        return relType;
    }

    private static class GraphTraversalHolder {
        private static final GraphTraversal INSTANCE = new GraphTraversal();

        private GraphTraversalHolder() {
        }
    }
}

