/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j;

import java.lang.ref.SoftReference;
import org.neo4j.graphdb.Relationship;
import org.reco4j.graph.BasicEdge;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.Neo4JNode;
import org.reco4j.graph.neo4j.traversal.GraphTraversal;

public class Neo4JEdge
extends BasicEdge {
    private SoftReference<Relationship> edgeRef;
    private long id;

    public Neo4JEdge(Relationship edge) {
        this.setEdge(edge);
    }

    public void setProperty(String name, Object value) {
        GraphTraversal.getInstance().setEdgeProperty((IEdge)this, name, value);
    }

    public String getProperty(String name) {
        String value = this.getPropertyValue(name);
        if (value == null) {
            StringBuilder exception = new StringBuilder();
            exception.append("getProperty conversion data not supported! Not available property '").append(name).append("'on node!\n");
            exception.append("Available properties are:\n");
            for (String key : this.getEdge().getPropertyKeys()) {
                exception.append(key).append("\n");
            }
            throw new RuntimeException(exception.toString());
        }
        return value;
    }

    public INode getSource() {
        return new Neo4JNode(this.getEdge().getStartNode());
    }

    public INode getDestination() {
        return new Neo4JNode(this.getEdge().getEndNode());
    }

    public Relationship getEdge() {
        Relationship edge = this.edgeRef.get();
        if (edge == null) {
            edge = GraphTraversal.getInstance().getBaseEdgeById(this.id);
            this.setEdge(edge);
        }
        return edge;
    }

    public final void setEdge(Relationship edge) {
        this.id = edge.getId();
        this.edgeRef = new SoftReference<Relationship>(edge);
    }

    public String getPermissiveProperty(String name) {
        if (!this.getEdge().hasProperty(name)) {
            return null;
        }
        return this.getPropertyValue(name);
    }

    public long getId() {
        return this.id;
    }

    private String getPropertyValue(String name) throws RuntimeException {
        Object value = this.getEdge().getProperty(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Float) {
            return ((Float)value).toString();
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof Double) {
            return ((Double)value).toString();
        }
        throw new RuntimeException("getProperty conversion data not supported! Not supported data type for property '" + name + "': " + value.getClass());
    }

    public void setId(long id) {
        this.id = id;
    }
}

