/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.IEdgeType;
import org.reco4j.graph.IGraph;
import org.reco4j.graph.IGraphCallable;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.Neo4JNode;
import org.reco4j.graph.neo4j.plugin.handler.Reco4jEventHandler;
import org.reco4j.graph.neo4j.traversal.GraphTraversal;
import org.reco4j.graph.neo4j.util.INeo4JGraphConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4jGraph
implements IGraph {
    private GraphDatabaseService graphDB;
    private static final Logger logger = Logger.getLogger(Neo4jGraph.class.getName());
    private final INeo4JGraphConfig neo4JGraphConfig;

    public Neo4jGraph(INeo4JGraphConfig neo4JGraphConfig) {
        this.neo4JGraphConfig = neo4JGraphConfig;
    }

    public void initDatabase() {
        HashMap<String, String> graphDatabaseBuilderConfig = new HashMap<String, String>();
        graphDatabaseBuilderConfig.put("use_memory_mapped_buffers", "false");
        graphDatabaseBuilderConfig.put("neostore.nodestore.db.mapped_memory", "800M");
        graphDatabaseBuilderConfig.put("neostore.relationshipstore.db.mapped_memory", "100M");
        graphDatabaseBuilderConfig.put("neostore.propertystore.db.mapped_memory", "100M");
        graphDatabaseBuilderConfig.put("neostore.propertystore.db.index.mapped_memory", "1M");
        graphDatabaseBuilderConfig.put("neostore.propertystore.db.index.keys.mapped_memory", "1M");
        graphDatabaseBuilderConfig.put("neostore.propertystore.db.strings.mapped_memory", "150M");
        graphDatabaseBuilderConfig.put("neostore.propertystore.db.arrays.mapped_memory", "0M");
        GraphDatabaseService newGraphDatabase = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.neo4JGraphConfig.getDBPath()).setConfig(graphDatabaseBuilderConfig).newGraphDatabase();
        this.setDatabase(newGraphDatabase);
        Neo4jGraph.registerShutdownHook(newGraphDatabase);
    }

    public void setDatabase(GraphDatabaseService graphDB) {
        this.graphDB = graphDB;
        Reco4jEventHandler evtHandler = new Reco4jEventHandler();
        this.graphDB.registerTransactionEventHandler((TransactionEventHandler)evtHandler);
        GraphTraversal.getInstance().init(graphDB);
    }

    public List<INode> getNodesByType(String type) {
        return GraphTraversal.getInstance().getNodesByType(type);
    }

    public List<INode> getUserNodes() {
        return this.getNodesByType(this.neo4JGraphConfig.getUserType());
    }

    public List<INode> getItemNodes() {
        return this.getNodesByType(this.neo4JGraphConfig.getItemType());
    }

    public List<INode> getNodesByInEdge(IEdgeType edgesType) {
        return GraphTraversal.getInstance().getNodesByInEdge(edgesType);
    }

    private static void registerShutdownHook(final GraphDatabaseService graphDb) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("Shuting down neo4j db instance ...");
                graphDb.shutdown();
                System.out.println("... done!");
            }
        });
    }

    public GraphDatabaseService getGraphDB() {
        return this.graphDB;
    }

    public void addEdge(INode x, INode y, IEdgeType similarityEdgeType, String propertyName, String value) {
        GraphTraversal.getInstance().addEdge(x, y, similarityEdgeType, propertyName, value);
    }

    public void setEdgeProperty(IEdge edge, String propertyName, String value) {
        GraphTraversal.getInstance().setEdgeProperty(edge, propertyName, value);
    }

    public List<IEdge> getEdgesByType(IEdgeType edgesType) {
        return GraphTraversal.getInstance().getEdgesByType(edgesType);
    }

    public ConcurrentHashMap<Long, INode> getNodesMapByType(String type) {
        return GraphTraversal.getInstance().getNodesMapByType(type);
    }

    public void optimizeGraph() {
    }

    public void tidyUpGraph() {
    }

    public void getNodesByType(String type, IGraphCallable<INode> callback) {
        GraphTraversal.getInstance().getNodesByType(type, callback);
    }

    public INode getUserNodeById(long id) {
        return this.getNodeByIdAndVerifyType(id, this.neo4JGraphConfig.getUserType());
    }

    public INode getItemNodeById(long id) {
        return this.getNodeByIdAndVerifyType(id, this.neo4JGraphConfig.getItemType());
    }

    public int getNodesNumberByType(String type) {
        return GraphTraversal.getInstance().getNodesNumberByType(type);
    }

    public FastIDSet getEdgesIdByType(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getEdgesIdByType(edgeType);
    }

    public FastIDSet getNodesIdByType(String type) {
        return GraphTraversal.getInstance().getNodesIdByType(type);
    }

    public INode getNodeById(long id) {
        if (id < 1L) {
            return null;
        }
        Node node = GraphTraversal.getInstance().getBaseNodeById(id);
        Neo4JNode inode = new Neo4JNode(node);
        return inode;
    }

    private INode getNodeByIdAndVerifyType(long id, String type) {
        INode inode = this.getNodeById(id);
        if (!inode.getProperty(this.neo4JGraphConfig.getNodeTypeName()).equalsIgnoreCase(type)) {
            logger.log(Level.WARNING, "Requested a node for type " + type + " but it is of different type. ID: {0}", id);
            return null;
        }
        return inode;
    }

    public INode addNode(Map<String, String> properties) {
        return GraphTraversal.getInstance().addNode(properties);
    }

    public void setNodeProperty(INode node, String propertyName, String value) {
        GraphTraversal.getInstance().setNodeProperty(node, propertyName, value);
    }

    public ConcurrentHashMap<Long, INode> getNodesByQuery(String query) {
        return GraphTraversal.getInstance().getNodesByQuery(query);
    }

    public List<IEdge> getEdgesByQuery(String query) {
        return GraphTraversal.getInstance().getEdgesByQuery(query);
    }

    public FastIDSet getNodesIdByQuery(String query) {
        return GraphTraversal.getInstance().getNodesIdByQuery(query);
    }
}

