/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j.engine;

import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.reco4j.engine.RecommenderBuilderThread;
import org.reco4j.engine.RecommenderEngine;
import org.reco4j.graph.EdgeTypeFactory;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.IGraph;
import org.reco4j.graph.IGraphConfig;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.Neo4JEdge;
import org.reco4j.graph.neo4j.Neo4JNode;
import org.reco4j.graph.neo4j.Neo4jGraph;
import org.reco4j.graph.neo4j.util.Neo4JPropertiesHandle;
import org.reco4j.model.Rating;
import org.reco4j.recommender.IRecommender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecommenderNeo4jEngineManager {
    private static final Logger logger = Logger.getLogger(RecommenderNeo4jEngineManager.class.getName());
    private Neo4jGraph learningDataSet;
    private IRecommender recommender;
    private RecommenderBuilderThread recommenderThread;

    private RecommenderNeo4jEngineManager() {
    }

    public void setup(GraphDatabaseService gds) {
        this.learningDataSet = new Neo4jGraph(Neo4JPropertiesHandle.getInstance());
        this.learningDataSet.setDatabase(gds);
    }

    public static RecommenderNeo4jEngineManager getInstance() {
        return RecommenderNeo4jEngeManagerHolder.INSTANCE;
    }

    private Properties loadProperties(String propertiesPath) {
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(propertiesPath));
        }
        catch (IOException ex) {
            Logger.getLogger(RecommenderNeo4jEngineManager.class.getName()).log(Level.SEVERE, "Error while loading properties: " + propertiesPath, ex);
        }
        return properties;
    }

    public Iterable<Node> getRecommender(INode user, int type) {
        List recommendations = this.recommender.recommend(user);
        ArrayList<Node> result = new ArrayList<Node>();
        for (Rating reco : recommendations) {
            result.add(((Neo4JNode)reco.getItem()).getNode());
        }
        logger.log(Level.INFO, "Size {0}", result.size());
        return result;
    }

    public void updateRecommender(Relationship edge, int operation) {
        if (edge.isType((RelationshipType)DynamicRelationshipType.withName((String)EdgeTypeFactory.getEdgeType((int)1, (IGraphConfig)this.recommender.getConfig().getGraphConfig()).getEdgeName()))) {
            this.recommender.updateRecommender((IEdge)new Neo4JEdge(edge), operation);
        }
    }

    public void init(GraphDatabaseService gds, Configuration c) {
        this.setup(gds);
        String propertiesPath = c.getString("org.reco4j.graph.neo4j.engine.properties");
        Properties properties = this.loadProperties(propertiesPath);
        this.recommender = RecommenderEngine.createRecommender((Properties)properties);
        this.recommenderThread = new RecommenderBuilderThread(this.recommender, (IGraph)this.learningDataSet);
        logger.log(Level.INFO, "Reco4j Initialized!");
    }

    public void startRecommender() {
        try {
            this.recommenderThread.start();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error in recommender Thread!!!", ex);
        }
    }

    public Iterable<Node> getUsers() {
        List<INode> users = this.learningDataSet.getUserNodes();
        ArrayList<Node> result = new ArrayList<Node>();
        for (INode node : users) {
            result.add(((Neo4JNode)node).getNode());
        }
        return result;
    }

    public Iterable<Node> getItems() {
        List<INode> items = this.learningDataSet.getItemNodes();
        ArrayList<Node> result = new ArrayList<Node>();
        for (INode node : items) {
            result.add(((Neo4JNode)node).getNode());
        }
        return result;
    }

    public Iterable<Relationship> getAllRatings() {
        List<IEdge> rels = this.learningDataSet.getEdgesByType(EdgeTypeFactory.getEdgeType((int)1, (IGraphConfig)this.recommender.getConfig().getGraphConfig()));
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (IEdge item : rels) {
            result.add(((Neo4JEdge)item).getEdge());
        }
        return result;
    }

    public Iterable<Relationship> getRatings(Node node) {
        Neo4JNode n = new Neo4JNode(node);
        List<IEdge> relationships = n.getOutEdge(EdgeTypeFactory.getEdgeType((int)1, (IGraphConfig)this.recommender.getConfig().getGraphConfig()));
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (IEdge relationship : relationships) {
            result.add(((Neo4JEdge)relationship).getEdge());
        }
        return result;
    }

    public Iterable<Relationship> getRatingsTest(Node node) {
        Neo4JNode n = new Neo4JNode(node);
        List<IEdge> relationships = n.getOutEdge(EdgeTypeFactory.getEdgeType((int)5, (IGraphConfig)this.recommender.getConfig().getGraphConfig()));
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (IEdge relationship : relationships) {
            result.add(((Neo4JEdge)relationship).getEdge());
        }
        return result;
    }

    private static class RecommenderNeo4jEngeManagerHolder {
        private static final RecommenderNeo4jEngineManager INSTANCE = new RecommenderNeo4jEngineManager();

        private RecommenderNeo4jEngeManagerHolder() {
        }
    }
}

