/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j.traversal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.tooling.GlobalGraphOperations;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.IEdgeType;
import org.reco4j.graph.IGraphCallable;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.Neo4JEdge;
import org.reco4j.graph.neo4j.Neo4JNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphTraversal {
    private static Logger logger = Logger.getLogger(GraphTraversal.class.getName());
    private static GraphDatabaseService graphDB;

    public static GraphTraversal getInstance() {
        return GraphTraversalHolder.INSTANCE;
    }

    public void init(GraphDatabaseService graphDB) {
        GraphTraversal.graphDB = graphDB;
    }

    public List<INode> getNodesByType(String type) {
        if (graphDB.index().existsForNodes("idx_node_type")) {
            Index idx_node_type = graphDB.index().forNodes("idx_node_type");
            IndexHits result = idx_node_type.get("type", (Object)type);
            return this.getNodeList((IndexHits<Node>)result);
        }
        Iterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllNodes();
        return this.getNodeList(allNodes, type);
    }

    public FastIDSet getNodesIdByType(String type) {
        FastIDSet ids = new FastIDSet();
        if (graphDB.index().existsForNodes("idx_node_type")) {
            Index idx_node_type = graphDB.index().forNodes("idx_node_type");
            IndexHits result = idx_node_type.get("type", (Object)type);
            while (result.hasNext()) {
                ids.add(((Node)result.next()).getId());
            }
        } else {
            Iterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllNodes();
            for (Node next : allNodes) {
                if (!((String)next.getProperty("type")).equalsIgnoreCase(type)) continue;
                ids.add(next.getId());
            }
        }
        return ids;
    }

    public ConcurrentHashMap<Long, INode> getNodesMapByType(String type) {
        ConcurrentHashMap<Long, INode> nodes = new ConcurrentHashMap<Long, INode>();
        if (graphDB.index().existsForNodes("idx_node_type")) {
            Index idx_node_type = graphDB.index().forNodes("idx_node_type");
            IndexHits result = idx_node_type.get("type", (Object)type);
            while (result.hasNext()) {
                Node item = (Node)result.next();
                Neo4JNode node = new Neo4JNode(item);
                nodes.put(node.getId(), (INode)node);
            }
            return nodes;
        }
        Iterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllNodes();
        for (Node next : allNodes) {
            if (!((String)next.getProperty("type")).equalsIgnoreCase(type)) continue;
            Neo4JNode node = new Neo4JNode(next);
            nodes.put(node.getId(), (INode)node);
        }
        return nodes;
    }

    public void getNodesByType(String type, IGraphCallable<INode> callback) {
        if (graphDB.index().existsForNodes("idx_node_type")) {
            Index idx_node_type = graphDB.index().forNodes("idx_node_type");
            IndexHits result = idx_node_type.get("type", (Object)type);
            while (result.hasNext()) {
                Neo4JNode node = new Neo4JNode((Node)result.next());
                callback.call((Object)node);
            }
        } else {
            Iterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllNodes();
            for (Node next : allNodes) {
                if (!((String)next.getProperty("type")).equalsIgnoreCase(type)) continue;
                Neo4JNode node = new Neo4JNode(next);
                callback.call((Object)node);
            }
        }
    }

    public ConcurrentHashMap<Long, INode> getNodesByQuery(String query) {
        ConcurrentHashMap<Long, INode> result = new ConcurrentHashMap<Long, INode>();
        ExecutionEngine engine = new ExecutionEngine(graphDB);
        ExecutionResult resultSet = engine.execute(query);
        Iterator allNodes = resultSet.columnAs("n");
        for (Node next : IteratorUtil.asIterable((Iterator)allNodes)) {
            Neo4JNode node = new Neo4JNode(next);
            result.put(node.getId(), (INode)node);
        }
        return result;
    }

    public FastIDSet getNodesIdByQuery(String query) {
        FastIDSet result = new FastIDSet();
        ExecutionEngine engine = new ExecutionEngine(graphDB);
        ExecutionResult resultSet = engine.execute(query);
        Iterator allNodes = resultSet.columnAs("n");
        for (Node next : IteratorUtil.asIterable((Iterator)allNodes)) {
            if (next.getId() <= 0L) continue;
            result.add(next.getId());
        }
        return result;
    }

    public List<IEdge> getEdgesByQuery(String query) {
        ArrayList<IEdge> result = new ArrayList<IEdge>();
        ExecutionEngine engine = new ExecutionEngine(graphDB);
        ExecutionResult resultSet = engine.execute(query);
        Iterator allRelationships = resultSet.columnAs("r");
        for (Relationship next : IteratorUtil.asIterable((Iterator)allRelationships)) {
            Neo4JEdge edge = new Neo4JEdge(next);
            result.add((IEdge)edge);
        }
        return result;
    }

    public List<IEdge> getEdgesByType(IEdgeType edgeType) {
        String type = edgeType.getEdgeName();
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)type);
        ArrayList<IEdge> edges = new ArrayList<IEdge>();
        if (graphDB.index().existsForRelationships("reco4j_idx_rel_type")) {
            RelationshipIndex relIndex = graphDB.index().forRelationships("reco4j_idx_rel_type");
            IndexHits relations = relIndex.get("type", (Object)relType.name());
            while (relations.hasNext()) {
                Relationship item = (Relationship)relations.next();
                Neo4JEdge edge = new Neo4JEdge(item);
                edges.add((IEdge)edge);
            }
        } else {
            Iterable allRelationships = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllRelationships();
            for (Relationship next : allRelationships) {
                if (!next.isType((RelationshipType)relType)) continue;
                Neo4JEdge edge = new Neo4JEdge(next);
                edges.add((IEdge)edge);
            }
        }
        return edges;
    }

    public FastIDSet getEdgesIdByType(IEdgeType edgeType) {
        String type = edgeType.getEdgeName();
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)type);
        FastIDSet edges = new FastIDSet();
        if (graphDB.index().existsForRelationships("reco4j_idx_rel_type")) {
            RelationshipIndex relIndex = graphDB.index().forRelationships("reco4j_idx_rel_type");
            IndexHits relations = relIndex.get("type", (Object)relType.name());
            while (relations.hasNext()) {
                edges.add(((Relationship)relations.next()).getId());
            }
        } else {
            Iterable allRelationships = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllRelationships();
            for (Relationship next : allRelationships) {
                if (!next.isType((RelationshipType)relType)) continue;
                edges.add(next.getId());
            }
        }
        return edges;
    }

    public List<INode> getNodesByInEdge(IEdgeType edgesType) {
        Iterable allRelationships = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllRelationships();
        ArrayList<INode> nodes = new ArrayList<INode>();
        RelationshipType relationshipType = this.getRelationshipTypeByEdgeType(edgesType);
        for (Relationship next : allRelationships) {
            if (!next.isType(relationshipType)) continue;
            Node item = next.getEndNode();
            Neo4JNode node = new Neo4JNode(item);
            nodes.add((INode)node);
        }
        return nodes;
    }

    public List<IEdge> getInEdge(INode inode, IEdgeType edgesType) {
        Node nodeTmp = ((Neo4JNode)inode).getNode();
        Iterable edgeList = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.INCOMING);
        return this.getIEdgeList(edgeList);
    }

    public FastIDSet getInEdgeIds(INode inode, IEdgeType edgesType) {
        Node nodeTmp = ((Neo4JNode)inode).getNode();
        Iterable edgeList = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.INCOMING);
        return this.getIEdgeSet(edgeList);
    }

    public List<IEdge> getOutEdge(INode inode, IEdgeType edgesType) {
        Node nodeTmp = ((Neo4JNode)inode).getNode();
        Iterable edgeList = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.OUTGOING);
        return this.getIEdgeList(edgeList);
    }

    public Boolean isConnected(INode x, INode y, IEdgeType edgesType) {
        Node a = ((Neo4JNode)x).getNode();
        Node b = ((Neo4JNode)y).getNode();
        Iterable edgeList = a.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.BOTH);
        for (Relationship edge : edgeList) {
            Node otherNode = edge.getOtherNode(a);
            if (otherNode.getId() != b.getId()) continue;
            return true;
        }
        return false;
    }

    public IEdge getEdge(INode x, INode y, IEdgeType edgesType) {
        Node a = ((Neo4JNode)x).getNode();
        Node b = ((Neo4JNode)y).getNode();
        Iterable edgeList = a.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.BOTH);
        for (Relationship edge : edgeList) {
            if (edge.getOtherNode(a).getId() != b.getId()) continue;
            return new Neo4JEdge(edge);
        }
        return null;
    }

    public ConcurrentHashMap<Long, INode> getCommonNodes(INode node, IEdgeType edgesType, String identifier) {
        ConcurrentHashMap<Long, INode> nodes = new ConcurrentHashMap<Long, INode>();
        Node nodeTmp = ((Neo4JNode)node).getNode();
        String nodeIdentifier = node.getProperty(identifier);
        Iterable inRelationships = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.INCOMING);
        for (Relationship inRelationship : inRelationships) {
            Node source = inRelationship.getStartNode();
            Iterable outRelationships = source.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.OUTGOING);
            for (Relationship outRelationship : outRelationships) {
                Node dest = outRelationship.getEndNode();
                String destIdentifier = new Neo4JNode(dest).getProperty(identifier);
                if (destIdentifier.equalsIgnoreCase(nodeIdentifier) || nodes.containsKey(destIdentifier)) continue;
                nodes.put(dest.getId(), (INode)new Neo4JNode(dest));
            }
        }
        return nodes;
    }

    public FastIDSet getCommonNodeIds(INode node, IEdgeType edgesType) {
        FastIDSet nodes = new FastIDSet();
        Node nodeTmp = ((Neo4JNode)node).getNode();
        Iterable inRelationships = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.INCOMING);
        for (Relationship inRelationship : inRelationships) {
            Node source = inRelationship.getStartNode();
            Iterable outRelationships = source.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.OUTGOING);
            for (Relationship outRelationship : outRelationships) {
                if (outRelationship.getEndNode().getId() == nodeTmp.getId()) continue;
                nodes.add(outRelationship.getEndNode().getId());
            }
        }
        return nodes;
    }

    public void getCommonNodes(INode node, IEdgeType edgesType, IGraphCallable<INode> callback) {
        HashMap<Long, Neo4JNode> nodes = new HashMap<Long, Neo4JNode>();
        Node nodeTmp = ((Neo4JNode)node).getNode();
        Iterable inRelationships = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.INCOMING);
        for (Relationship inRelationship : inRelationships) {
            Node source = inRelationship.getStartNode();
            Iterable outRelationships = source.getRelationships(this.getRelationshipTypeByEdgeType(edgesType), Direction.OUTGOING);
            for (Relationship outRelationship : outRelationships) {
                Node dest = outRelationship.getEndNode();
                if (dest.getId() == nodeTmp.getId() || nodes.containsKey(dest.getId())) continue;
                Neo4JNode neo4JNode = new Neo4JNode(dest);
                nodes.put(dest.getId(), neo4JNode);
                callback.call((Object)neo4JNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdge(INode x, INode y, IEdgeType similarityEdgeType, String propertyName, Object value) {
        Node source = ((Neo4JNode)x).getNode();
        Node dest = ((Neo4JNode)y).getNode();
        Transaction tx = graphDB.beginTx();
        try {
            Relationship createRelationshipTo = source.createRelationshipTo(dest, this.getRelationshipTypeByEdgeType(similarityEdgeType));
            createRelationshipTo.setProperty(propertyName, value);
            tx.success();
        }
        catch (Exception ex) {
            tx.failure();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error during addEdgeTransaction: ", ex);
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdge(INode x, INode y, IEdgeType edgeType) {
        Node source = ((Neo4JNode)x).getNode();
        Node dest = ((Neo4JNode)y).getNode();
        Transaction tx = graphDB.beginTx();
        try {
            Relationship createRelationshipTo = source.createRelationshipTo(dest, this.getRelationshipTypeByEdgeType(edgeType));
            tx.success();
        }
        catch (Exception ex) {
            tx.failure();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error during addEdgeTransaction: ", ex);
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEdgeProperty(IEdge edge, String propertyName, Object value) {
        Relationship rel = ((Neo4JEdge)edge).getEdge();
        Transaction tx = graphDB.beginTx();
        try {
            rel.setProperty(propertyName, value);
            tx.success();
        }
        catch (Exception ex) {
            tx.failure();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error during addEdgeTransaction: ", ex);
        }
        finally {
            tx.finish();
        }
    }

    public int getInEdgeNumber(INode node, IEdgeType edgeType) {
        Node nodeTmp = ((Neo4JNode)node).getNode();
        Iterable edgeList = nodeTmp.getRelationships(this.getRelationshipTypeByEdgeType(edgeType), Direction.INCOMING);
        return this.getIEdgeSet(edgeList).size();
    }

    private List<IEdge> getIEdgeList(Iterable<Relationship> allRelationships) {
        ArrayList<IEdge> edges = new ArrayList<IEdge>();
        for (Relationship next : allRelationships) {
            Neo4JEdge edge = new Neo4JEdge(next);
            edges.add((IEdge)edge);
        }
        return edges;
    }

    private FastIDSet getIEdgeSet(Iterable<Relationship> allRelationships) {
        FastIDSet edges = new FastIDSet();
        for (Relationship next : allRelationships) {
            edges.add(next.getId());
        }
        return edges;
    }

    private List<INode> getNodeList(IndexHits<Node> result) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        while (result.hasNext()) {
            Neo4JNode node = new Neo4JNode((Node)result.next());
            nodes.add((INode)node);
        }
        return nodes;
    }

    private List<INode> getNodeList(Iterable<Node> allNodes, String type) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (Node next : allNodes) {
            if (!((String)next.getProperty("type")).equalsIgnoreCase(type)) continue;
            Neo4JNode node = new Neo4JNode(next);
            nodes.add((INode)node);
        }
        return nodes;
    }

    private RelationshipType getRelationshipTypeByEdgeType(IEdgeType edgesType) {
        String edges = edgesType.getEdgeName();
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)edges);
        return relType;
    }

    public void iterateOnEdge(Neo4JNode node, IEdgeType edgeType, IGraphCallable<IEdge> callback) {
        Node neo4jNode = node.getNode();
        Iterable edgeList = neo4jNode.getRelationships(new RelationshipType[]{this.getRelationshipTypeByEdgeType(edgeType)});
        for (Relationship next : edgeList) {
            Neo4JEdge edge = new Neo4JEdge(next);
            callback.call((Object)edge);
        }
    }

    public int getNodesNumberByType(String type) {
        if (graphDB.index().existsForNodes("idx_node_type")) {
            Index idx_node_type = graphDB.index().forNodes("idx_node_type");
            IndexHits result = idx_node_type.get("type", (Object)type);
            return result.size();
        }
        int count = 0;
        Iterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllNodes();
        for (Node next : allNodes) {
            if (!((String)next.getProperty("type")).equalsIgnoreCase(type)) continue;
            ++count;
        }
        return count;
    }

    public INode getNodeById(long id, String type, String identifier) {
        if (graphDB.index().existsForNodes("idx_node_type")) {
            Index idx_node_type = graphDB.index().forNodes("idx_node_type");
            IndexHits result = idx_node_type.get("type", (Object)type);
            while (result.hasNext()) {
                Node next = (Node)result.next();
                Integer nodeId = (Integer)next.getProperty(identifier);
                if (nodeId.longValue() != id) continue;
                return new Neo4JNode(next);
            }
        } else {
            Iterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllNodes();
            for (Node next : allNodes) {
                Integer nodeId;
                if (!((String)next.getProperty("type")).equalsIgnoreCase(type) || (nodeId = (Integer)next.getProperty(identifier)).longValue() != id) continue;
                return new Neo4JNode(next);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeGraph(boolean force) {
        Transaction tx;
        String reco4j_idx_rel_type = "reco4j_idx_rel_type";
        if (force && graphDB.index().existsForRelationships("reco4j_idx_rel_type")) {
            logger.warning("Deleting index!");
            tx = graphDB.beginTx();
            try {
                graphDB.index().forRelationships("reco4j_idx_rel_type").delete();
                tx.success();
            }
            catch (Exception ex) {
                tx.failure();
                logger.log(Level.SEVERE, "Error during deleting relationship index: reco4j_idx_rel_type", ex);
            }
            finally {
                tx.finish();
            }
        }
        if (!graphDB.index().existsForRelationships("reco4j_idx_rel_type")) {
            logger.warning("Index on Relationship: reco4j_idx_rel_type not present. Let me add it!");
            tx = graphDB.beginTx();
            try {
                RelationshipIndex index_on_type = graphDB.index().forRelationships("reco4j_idx_rel_type");
                Iterable allRelationships = GlobalGraphOperations.at((GraphDatabaseService)graphDB).getAllRelationships();
                int count = 0;
                for (Relationship next : allRelationships) {
                    index_on_type.add((PropertyContainer)next, "type", (Object)next.getType().name());
                    if (++count % 1000 != 0) continue;
                    tx.success();
                    tx.finish();
                    tx = graphDB.beginTx();
                }
                tx.success();
            }
            catch (Exception ex) {
                tx.failure();
                logger.log(Level.SEVERE, "Error during add relationship index: ", ex);
            }
            finally {
                tx.finish();
            }
        }
    }

    public Node getBaseNodeById(long id) {
        return graphDB.getNodeById(id);
    }

    public Relationship getBaseEdgeById(long id) {
        return graphDB.getRelationshipById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode addNode(Map<String, String> properties) {
        Neo4JNode node = null;
        Transaction tx = graphDB.beginTx();
        try {
            Node newNode = graphDB.createNode();
            for (String property : properties.keySet()) {
                newNode.setProperty(property, (Object)properties.get(property));
            }
            node = new Neo4JNode(newNode);
            tx.success();
        }
        catch (Exception ex) {
            tx.failure();
            logger.log(Level.SEVERE, "Error during node creation: ", ex);
        }
        finally {
            tx.finish();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeProperty(INode node, String propertyName, String value) {
        Transaction tx = graphDB.beginTx();
        try {
            Node newNode = ((Neo4JNode)node).getNode();
            newNode.setProperty(propertyName, (Object)value);
            tx.success();
        }
        catch (Exception ex) {
            tx.failure();
            logger.log(Level.SEVERE, "Error during node property setting: ", ex);
        }
        finally {
            tx.finish();
        }
    }

    private static class GraphTraversalHolder {
        private static final GraphTraversal INSTANCE = new GraphTraversal();

        private GraphTraversalHolder() {
        }
    }
}

