/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j;

import java.lang.ref.SoftReference;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.neo4j.graphdb.Node;
import org.reco4j.graph.BasicNode;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.IEdgeType;
import org.reco4j.graph.IGraphCallable;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.traversal.GraphTraversal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4JNode
extends BasicNode {
    private long id;
    private SoftReference<Node> nodeRef;

    public Neo4JNode(long id) {
        this.setNode(GraphTraversal.getInstance().getBaseNodeById(id));
    }

    public Neo4JNode(Node node) {
        this.setNode(node);
    }

    public final void setNode(Node node) {
        this.id = node.getId();
        this.nodeRef = new SoftReference<Node>(node);
    }

    public Node getNode() {
        Node node = this.nodeRef.get();
        if (node == null) {
            node = GraphTraversal.getInstance().getBaseNodeById(this.id);
            this.setNode(node);
        }
        return node;
    }

    public void setProperty(String name, String value) {
        GraphTraversal.getInstance().setNodeProperty((INode)this, name, value);
    }

    public String getProperty(String name) {
        Object value = this.getNode().getProperty(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value == null) {
            StringBuilder exception = new StringBuilder();
            exception.append("getProperty conversion data not supported! Not available property '").append(name).append("'on node!\n");
            exception.append("Available properties are:\n");
            for (String key : this.getNode().getPropertyKeys()) {
                exception.append(key).append("\n");
            }
            throw new RuntimeException(exception.toString());
        }
        throw new RuntimeException("getProperty conversion data not supported! Not supported data type for property '" + name + "': " + value.getClass());
    }

    public Boolean isConnected(INode b, IEdgeType edgeType) {
        return GraphTraversal.getInstance().isConnected((INode)this, b, edgeType);
    }

    public Boolean isConnected(INode node, List<IEdgeType> edgeTypes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Boolean isConnectedIn(INode node, List<IEdgeType> edgeTypes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Boolean isConnectedOut(INode node, List<IEdgeType> edgeTypes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IEdge getEdge(INode node, IEdgeType edgeType) {
        IEdge edge = GraphTraversal.getInstance().getEdge((INode)this, node, edgeType);
        return edge;
    }

    public List<IEdge> getInEdge(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getInEdge((INode)this, edgeType);
    }

    public List<IEdge> getOutEdge(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getOutEdge((INode)this, edgeType);
    }

    public ConcurrentHashMap<Long, INode> getCommonNodes(IEdgeType edgeType, String identifier) {
        return GraphTraversal.getInstance().getCommonNodes((INode)this, edgeType, identifier);
    }

    public FastIDSet getCommonNodeIds(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getCommonNodeIds((INode)this, edgeType);
    }

    public void iterateOnCommonNodes(IEdgeType edgeType, IGraphCallable<INode> callback) {
        GraphTraversal.getInstance().getCommonNodes((INode)this, edgeType, callback);
    }

    public int getInEdgeNumber(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getInEdgeNumber((INode)this, edgeType);
    }

    public void iterateOnEdge(IEdgeType edgeType, IGraphCallable<IEdge> callback) {
        GraphTraversal.getInstance().iterateOnEdge(this, edgeType, callback);
    }

    public long getId() {
        return this.id;
    }

    public FastIDSet getInEdgeIds(IEdgeType edgeType) {
        return GraphTraversal.getInstance().getInEdgeIds((INode)this, edgeType);
    }

    public void setId(long id) {
        this.id = id;
    }

    public void addOutEdge(IEdgeType edgeType, INode destination) {
        GraphTraversal.getInstance().addEdge((INode)this, destination, edgeType);
    }

    public void addInEdge(IEdgeType edgeType, INode source) {
        source.addOutEdge(edgeType, (INode)this);
    }

    public void addOutEdgeWithProperty(IEdgeType edgeType, INode destination, String propertyName, Object value) {
        GraphTraversal.getInstance().addEdge((INode)this, destination, edgeType, propertyName, value);
    }

    public void addInEdgeWithProperty(IEdgeType edgeType, INode source, String propertyName, Object value) {
        source.addOutEdgeWithProperty(edgeType, (INode)this, propertyName, value);
    }
}

