/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j.engine;

import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.reco4j.dataset.FilteredUserItemDataset;
import org.reco4j.dataset.UserItemDataset;
import org.reco4j.engine.RecommenderBuilderThread;
import org.reco4j.engine.RecommenderEngine;
import org.reco4j.filter.IPostFilter;
import org.reco4j.filter.IPreFilter;
import org.reco4j.graph.EdgeTypeFactory;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.IGraph;
import org.reco4j.graph.IGraphConfig;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.Neo4JEdge;
import org.reco4j.graph.neo4j.Neo4JNode;
import org.reco4j.graph.neo4j.Neo4jGraph;
import org.reco4j.graph.neo4j.filter.Neo4JPostFilter;
import org.reco4j.graph.neo4j.filter.Neo4JPreFilter;
import org.reco4j.graph.neo4j.util.Neo4JPropertiesHandle;
import org.reco4j.model.IModel;
import org.reco4j.model.Rating;
import org.reco4j.recommender.IRecommender;
import org.reco4j.recommender.knn.ICollaborativeFilteringRecommenderConfig;
import org.reco4j.recommender.knn.IKNNModel;
import org.reco4j.util.RecommenderPropertiesHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecommenderNeo4jEngineManager {
    private static final Logger logger = Logger.getLogger(RecommenderNeo4jEngineManager.class.getName());
    private HashMap<String, IRecommender> recommenders = new HashMap();
    private List<RecommenderBuilderThread> recommenderThreads = new ArrayList<RecommenderBuilderThread>();

    private RecommenderNeo4jEngineManager() {
    }

    public static RecommenderNeo4jEngineManager getInstance() {
        return RecommenderNeo4jEngeManagerHolder.INSTANCE;
    }

    private Properties loadProperties(String propertiesPath) {
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(propertiesPath));
        }
        catch (IOException ex) {
            Logger.getLogger(RecommenderNeo4jEngineManager.class.getName()).log(Level.SEVERE, "Error while loading properties: " + propertiesPath, ex);
        }
        return properties;
    }

    public Iterable<Node> getRecommender(INode user, String recommenderName) {
        IRecommender recommender = this.getRecommenderByName(recommenderName);
        List recommendations = recommender.recommend(user);
        ArrayList<Node> result = new ArrayList<Node>();
        for (Rating reco : recommendations) {
            result.add(((Neo4JNode)reco.getItem()).getNode());
        }
        logger.log(Level.INFO, "Size {0}", result.size());
        return result;
    }

    public void updateRecommender(Relationship edge, int operation) {
        for (IRecommender recommender : this.recommenders.values()) {
            if (!edge.isType((RelationshipType)DynamicRelationshipType.withName((String)EdgeTypeFactory.getEdgeType((int)1, (IGraphConfig)recommender.getConfig().getGraphConfig()).getEdgeName()))) continue;
            recommender.updateRecommender((IEdge)new Neo4JEdge(edge), operation);
        }
    }

    private IRecommender getRecommenderByName(String recommenderName) throws RuntimeException {
        IRecommender recommender = this.recommenders.get(recommenderName);
        if (recommender == null) {
            throw new RuntimeException("Recommender with name " + recommenderName + " does not exist!");
        }
        return recommender;
    }

    private IRecommender initializeRecommender(Neo4JPropertiesHandle propertiesHandle, Neo4jGraph learningDataSet) {
        if (!propertiesHandle.isFiltered()) {
            return this.initializeBasicRecommender(propertiesHandle, learningDataSet);
        }
        logger.warning("Is filtered!");
        return this.initializeFilteredRecommender(propertiesHandle, learningDataSet);
    }

    private IRecommender initializeBasicRecommender(Neo4JPropertiesHandle propertiesHandle, Neo4jGraph learningDataSet) {
        IRecommender recommender = RecommenderEngine.createRecommender((RecommenderPropertiesHandle)propertiesHandle);
        recommender.setModelName(propertiesHandle.getModelName());
        RecommenderBuilderThread recommenderThread = new RecommenderBuilderThread(recommender, (IGraph)learningDataSet);
        this.recommenderThreads.add(recommenderThread);
        return recommender;
    }

    private IRecommender initializeFilteredRecommender(Neo4JPropertiesHandle propertiesHandle, Neo4jGraph learningDataSet) {
        IRecommender recommender = RecommenderEngine.createRecommender((RecommenderPropertiesHandle)propertiesHandle);
        recommender.setModelName(propertiesHandle.getModelName());
        boolean preFilterConfigured = true;
        boolean postFilterConfigured = true;
        logger.log(Level.WARNING, "propertiesHandle.getItemsQuery(): {0}", propertiesHandle.getItemsQuery());
        logger.log(Level.WARNING, "propertiesHandle.getUsersQuery(): {0}", propertiesHandle.getUsersQuery());
        logger.log(Level.WARNING, "propertiesHandle.getRatingsQuery(): {0}", propertiesHandle.getRatingsQuery());
        logger.log(Level.WARNING, "propertiesHandle.getCommonsNodeQuery(): {0}", propertiesHandle.getCommonsNodeQuery());
        if (propertiesHandle.getItemsQuery() == null || propertiesHandle.getUsersQuery() == null || propertiesHandle.getRatingsQuery() == null || propertiesHandle.getCommonsNodeQuery() == null) {
            preFilterConfigured = false;
        }
        if (propertiesHandle.getPostItemsQuery() == null) {
            postFilterConfigured = false;
        }
        if (!preFilterConfigured && !postFilterConfigured) {
            throw new RuntimeException("propertiesHandle.isFiltered() is true but there is no (complete) specification");
        }
        Neo4JPreFilter preFilter = null;
        if (preFilterConfigured) {
            preFilter = new Neo4JPreFilter();
            preFilter.setItemsQuery(propertiesHandle.getItemsQuery());
            preFilter.setUsersQuery(propertiesHandle.getUsersQuery());
            preFilter.setRatingsQuery(propertiesHandle.getRatingsQuery());
            preFilter.setCommonsNodeQuery(propertiesHandle.getCommonsNodeQuery());
        }
        Neo4JPostFilter postFilter = null;
        if (postFilterConfigured) {
            postFilter = new Neo4JPostFilter();
            postFilter.setItemsQuery(propertiesHandle.getPostItemsQuery());
        }
        logger.log(Level.WARNING, "->>>> {0} {1}", new Object[]{preFilter, postFilter});
        FilteredUserItemDataset userItemDataset = new FilteredUserItemDataset();
        userItemDataset.init((IGraph)learningDataSet, (ICollaborativeFilteringRecommenderConfig)propertiesHandle, (IPreFilter)preFilter, (IPostFilter)postFilter);
        RecommenderBuilderThread recommenderThread = new RecommenderBuilderThread(recommender, (IGraph)learningDataSet, (UserItemDataset)userItemDataset);
        this.recommenderThreads.add(recommenderThread);
        return recommender;
    }

    public void init(GraphDatabaseService gds, Configuration c) {
        String[] propertiesPaths;
        for (String propertiesPath : propertiesPaths = c.getStringArray("org.reco4j.graph.neo4j.engine.properties")) {
            Properties properties = this.loadProperties(propertiesPath);
            Neo4JPropertiesHandle propertiesHandle = new Neo4JPropertiesHandle(properties);
            String recommenderName = propertiesHandle.getRecommenderName();
            logger.log(Level.INFO, "Initializing {0} reco4j recommender", recommenderName);
            if (this.recommenders.containsKey(recommenderName)) {
                logger.log(Level.SEVERE, "A recommender with name {0} already exist the second one is ignored", recommenderName);
                continue;
            }
            Neo4jGraph learningDataSet = new Neo4jGraph(propertiesHandle);
            learningDataSet.setDatabase(gds);
            IRecommender recommender = this.initializeRecommender(propertiesHandle, learningDataSet);
            this.recommenders.put(recommenderName, recommender);
            logger.log(Level.INFO, "{0} reco4j recommender initialized!", recommenderName);
        }
    }

    public void startRecommender() {
        try {
            for (RecommenderBuilderThread recommenderThread : this.recommenderThreads) {
                recommenderThread.start();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error in recommender Thread!!!", ex);
        }
    }

    public Iterable<Node> getUsers(String recommenderName) {
        IRecommender recommender = this.getRecommenderByName(recommenderName);
        ConcurrentHashMap users = recommender.getUserItemDataset().getUserList();
        ArrayList<Node> result = new ArrayList<Node>();
        for (INode node : users.values()) {
            result.add(((Neo4JNode)node).getNode());
        }
        return result;
    }

    public Iterable<Node> getItems(String recommenderName) {
        IRecommender recommender = this.getRecommenderByName(recommenderName);
        ConcurrentHashMap items = recommender.getUserItemDataset().getItemList();
        ArrayList<Node> result = new ArrayList<Node>();
        for (INode node : items.values()) {
            result.add(((Neo4JNode)node).getNode());
        }
        return result;
    }

    public Iterable<Relationship> getAllRatings(String recommenderName) {
        IRecommender recommender = this.getRecommenderByName(recommenderName);
        List ratings = recommender.getUserItemDataset().getRatingList();
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (IEdge relationship : ratings) {
            result.add(((Neo4JEdge)relationship).getEdge());
        }
        return result;
    }

    public Iterable<Relationship> getRatings(Node node, String recommenderName) {
        IRecommender recommender = this.getRecommenderByName(recommenderName);
        Neo4JNode n = new Neo4JNode(node);
        List ratingsByUser = recommender.getUserItemDataset().getRatingsByUser(node.getId());
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (IEdge relationship : ratingsByUser) {
            result.add(((Neo4JEdge)relationship).getEdge());
        }
        return result;
    }

    public Iterable<Relationship> getRatingsTest(Node node, String recommenderName) {
        IRecommender recommender = this.getRecommenderByName(recommenderName);
        Neo4JNode n = new Neo4JNode(node);
        List<IEdge> relationships = n.getOutEdge(EdgeTypeFactory.getEdgeType((int)5, (IGraphConfig)recommender.getConfig().getGraphConfig()));
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (IEdge relationship : relationships) {
            result.add(((Neo4JEdge)relationship).getEdge());
        }
        return result;
    }

    public double getPrediction(Node node, Node item, String recommenderName) {
        IRecommender recommender = this.getRecommenderByName(recommenderName);
        Neo4JNode n = new Neo4JNode(node);
        Neo4JNode i = new Neo4JNode(item);
        return recommender.estimateRating((INode)n, (INode)i);
    }

    public Iterable<Node> getSimilarItems(Node item, int cardinality, String recommenderName) {
        IRecommender recommender = this.getRecommenderByName(recommenderName);
        IModel model = recommender.getModel();
        if (!(model instanceof IKNNModel)) {
            throw new RuntimeException("Model doesn't support similarity");
        }
        Neo4JNode i = new Neo4JNode(item);
        List similarItem = ((IKNNModel)model).getSimilarItem((INode)i, cardinality);
        ArrayList<Node> result = new ArrayList<Node>();
        for (Rating rate : similarItem) {
            result.add(((Neo4JNode)rate.getItem()).getNode());
        }
        return result;
    }

    private static class RecommenderNeo4jEngeManagerHolder {
        private static final RecommenderNeo4jEngineManager INSTANCE = new RecommenderNeo4jEngineManager();

        private RecommenderNeo4jEngeManagerHolder() {
        }
    }
}

