/*
 * Decompiled with CFR 0.152.
 */
package org.reco4j.graph.neo4j.filter;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.reco4j.filter.IPreFilter;
import org.reco4j.graph.IEdge;
import org.reco4j.graph.IGraph;
import org.reco4j.graph.INode;
import org.reco4j.graph.neo4j.Neo4jGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4JPreFilter
implements IPreFilter {
    private Neo4jGraph graph;
    private String usersQuery;
    private String itemsQuery;
    private String ratingsQuery;
    private String commonsNodeQuery;

    public void setGraph(IGraph graph) {
        if (!(graph instanceof Neo4jGraph)) {
            throw new RuntimeException("Try to initialize Neo4JFilter with a graph that is not an instance of Neo4jGraph");
        }
        this.graph = (Neo4jGraph)graph;
    }

    public ConcurrentHashMap<Long, INode> getItemNodesMap() {
        return this.graph.getNodesByQuery(this.itemsQuery);
    }

    public ConcurrentHashMap<Long, INode> getUserNodesMap() {
        return this.graph.getNodesByQuery(this.usersQuery);
    }

    public List<IEdge> getRatingList() {
        return this.graph.getEdgesByQuery(this.ratingsQuery);
    }

    public FastIDSet getCommonNodeIds(INode item) {
        String replacedString = this.commonsNodeQuery.replace("$1", "" + item.getId());
        return this.graph.getNodesIdByQuery(replacedString);
    }

    public FastIDSet getItemNodesId() {
        return this.graph.getNodesIdByQuery(this.itemsQuery);
    }

    public void setUsersQuery(String usersQuery) {
        this.usersQuery = usersQuery;
    }

    public void setItemsQuery(String itemsQuery) {
        this.itemsQuery = itemsQuery;
    }

    public void setRatingsQuery(String ratingsQuery) {
        this.ratingsQuery = ratingsQuery;
    }

    public void setCommonsNodeQuery(String commonsNodeQuery) {
        this.commonsNodeQuery = commonsNodeQuery;
    }

    public ConcurrentHashMap<Long, INode> getCommonNodes(INode item) {
        String replacedString = this.commonsNodeQuery.replace("$1", "" + item.getId());
        return this.graph.getNodesByQuery(replacedString);
    }
}

