/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.PropertySourcePropertyResolver;
import io.micronaut.core.naming.conventions.StringConvention;
import jakarta.inject.Inject;
import java.util.Set;
import org.redisson.client.NettyHook;
import org.redisson.client.codec.Codec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.AddressResolverGroupFactory;
import org.redisson.connection.ConnectionListener;

@ConfigurationProperties(value="redisson")
@Requirements(value={@Requires(missingBeans={Config.class}), @Requires(property="redisson")})
public class RedissonConfiguration
extends Config {
    @Inject
    public RedissonConfiguration(PropertySourcePropertyResolver propertyResolver) {
        Set props = propertyResolver.getProperties("redisson", StringConvention.CAMEL_CASE).keySet();
        for (String prop : props) {
            if (prop.startsWith("clusterServersConfig")) {
                this.useClusterServers();
                break;
            }
            if (prop.startsWith("singleServerConfig")) {
                this.useSingleServer();
                break;
            }
            if (prop.startsWith("replicatedServersConfig")) {
                this.useReplicatedServers();
                break;
            }
            if (prop.startsWith("sentinelServersConfig")) {
                this.useSentinelServers();
                break;
            }
            if (!prop.startsWith("masterSlaveServersConfig")) continue;
            this.useMasterSlaveServers();
            break;
        }
        if (props.contains("codec")) {
            this.setCodec((String)propertyResolver.getProperty("redisson.codec", String.class).get());
        }
        if (props.contains("addressResolverGroupFactory")) {
            this.setAddressResolverGroupFactory((String)propertyResolver.getProperty("redisson.address-resolver-group-factory", String.class).get());
        }
        if (props.contains("connectionListener")) {
            this.setConnectionListener((String)propertyResolver.getProperty("redisson.connection-listener", String.class).get());
        }
        if (props.contains("nettyHook")) {
            this.setNettyHook((String)propertyResolver.getProperty("redisson.netty-hook", String.class).get());
        }
    }

    @ConfigurationBuilder(value="singleServerConfig")
    public SingleServerConfig getSingleServerConfig() {
        return super.getSingleServerConfig();
    }

    @ConfigurationBuilder(value="clusterServersConfig")
    public ClusterServersConfig getClusterServersConfig() {
        return super.getClusterServersConfig();
    }

    @ConfigurationBuilder(value="replicatedServersConfig")
    public ReplicatedServersConfig getReplicatedServersConfig() {
        return super.getReplicatedServersConfig();
    }

    @ConfigurationBuilder(value="sentinelServersConfig")
    public SentinelServersConfig getSentinelServersConfig() {
        return super.getSentinelServersConfig();
    }

    @ConfigurationBuilder(value="masterSlaveServersConfig")
    public MasterSlaveServersConfig getMasterSlaveServersConfig() {
        return super.getMasterSlaveServersConfig();
    }

    public Config setCodec(String className) {
        try {
            Codec codec = (Codec)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return super.setCodec(codec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Config setNettyHook(String className) {
        try {
            NettyHook nettyHook = (NettyHook)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return super.setNettyHook(nettyHook);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Config setAddressResolverGroupFactory(String className) {
        try {
            AddressResolverGroupFactory value = (AddressResolverGroupFactory)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return super.setAddressResolverGroupFactory(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Config setConnectionListener(String className) {
        try {
            ConnectionListener connectionListener = (ConnectionListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return super.setConnectionListener(connectionListener);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

