/*
 * Decompiled with CFR 0.152.
 */
package org.redkale.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.redkale.boot.PrepareCompiler;
import org.redkale.convert.json.JsonConvert;
import org.redkale.util.RedkaleClassLoader;
import org.redkale.util.Utility;

@Mojo(name="compile", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class RedkaleCompileMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.artifact}", readonly=true, required=true)
    private Artifact projectArtifact;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    protected List<String> nativeimageArgs;
    @Parameter
    protected Boolean skipCopyConf;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outputDirectory.isDirectory()) {
            this.projectArtifact.setFile(this.outputDirectory);
        }
        try {
            Object out;
            File confFile;
            List paths = this.project.getCompileClasspathElements();
            URL[] urls = new URL[paths.size()];
            for (int i = 0; i < urls.length; ++i) {
                this.getLog().debug((CharSequence)("redkale.compile.path[" + i + "] = " + (String)paths.get(i)));
                urls[i] = new File((String)paths.get(i)).toURI().toURL();
            }
            RedkaleClassLoader contextLoader = new RedkaleClassLoader(urls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader((ClassLoader)contextLoader);
            new PrepareCompiler().run();
            Logger.getLogger("com.google.inject.internal").setLevel(Level.INFO);
            File nativeImageDir = new File(this.outputDirectory, "META-INF" + File.separatorChar + "native-image" + File.separatorChar + this.projectArtifact.getGroupId() + File.separatorChar + this.projectArtifact.getArtifactId());
            nativeImageDir.mkdirs();
            if ((this.skipCopyConf == null || !this.skipCopyConf.booleanValue()) && (confFile = new File(this.project.getBasedir(), "conf")).isDirectory()) {
                File destFile = new File(this.outputDirectory, "/META-INF/redkale/conf");
                RedkaleCompileMojo.copyFile(confFile, destFile);
            }
            HashSet<String> classLoadSet = new HashSet<String>();
            LinkedHashMap classBytesMap = new LinkedHashMap();
            RedkaleClassLoader.forEachDynClass(classBytesMap::put);
            for (Map.Entry en : classBytesMap.entrySet()) {
                classLoadSet.add((String)en.getKey());
                File file = new File(this.outputDirectory, ((String)en.getKey()).replace('.', File.separatorChar) + ".class");
                file.getParentFile().mkdirs();
                out = new FileOutputStream(file);
                try {
                    ((FileOutputStream)out).write((byte[])en.getValue());
                    ((OutputStream)out).flush();
                    ((FileOutputStream)out).close();
                }
                finally {
                    ((FileOutputStream)out).close();
                }
            }
            RedkaleClassLoader.forEachServiceLoader((k, v) -> classLoadSet.add((String)k));
            RedkaleClassLoader.forEachReflection((k, v) -> classLoadSet.add((String)k));
            ArrayList classLoadList22 = new ArrayList(classLoadSet);
            Collections.sort(classLoadList22);
            File file = new File(this.outputDirectory, "/META-INF/redkale/redkale.load.classes");
            file.getParentFile().mkdirs();
            try (FileOutputStream out2 = new FileOutputStream(file);){
                for (String v2 : classLoadList22) {
                    out2.write((v2 + "\r\n").getBytes(StandardCharsets.UTF_8));
                }
                out2.flush();
                out2.close();
            }
            File reflectionFile = new File(nativeImageDir, "reflect-config.json");
            TreeMap<String, HashMap> reflectionMap = new TreeMap<String, HashMap>();
            RedkaleClassLoader.forEachReflection(reflectionMap::put);
            try {
                contextLoader.loadClass("io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue");
                reflectionMap.put("io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerIndexField", Utility.ofMap((Object[])new Object[]{"name", "io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerIndexField", "fields", Utility.ofArray((Object[])new HashMap[]{Utility.ofMap((Object[])new Object[]{"name", "producerIndex", "allowUnsafeAccess", true})})}));
                reflectionMap.put("io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerLimitField", Utility.ofMap((Object[])new Object[]{"name", "io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerLimitField", "fields", Utility.ofArray((Object[])new HashMap[]{Utility.ofMap((Object[])new Object[]{"name", "producerLimit", "allowUnsafeAccess", true})})}));
                reflectionMap.put("io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueConsumerIndexField", Utility.ofMap((Object[])new Object[]{"name", "io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueConsumerIndexField", "fields", Utility.ofArray((Object[])new HashMap[]{Utility.ofMap((Object[])new Object[]{"name", "consumerIndex", "allowUnsafeAccess", true})})}));
                reflectionMap.put("io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueProducerFields", Utility.ofMap((Object[])new Object[]{"name", "io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueProducerFields", "fields", Utility.ofArray((Object[])new HashMap[]{Utility.ofMap((Object[])new Object[]{"name", "producerIndex", "allowUnsafeAccess", true})})}));
                reflectionMap.put("io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields", Utility.ofMap((Object[])new Object[]{"name", "io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields", "fields", Utility.ofArray((Object[])new HashMap[]{Utility.ofMap((Object[])new Object[]{"name", "producerLimit", "allowUnsafeAccess", true})})}));
                reflectionMap.put("io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueConsumerFields", Utility.ofMap((Object[])new Object[]{"name", "io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueConsumerFields", "fields", Utility.ofArray((Object[])new HashMap[]{Utility.ofMap((Object[])new Object[]{"name", "consumerIndex", "allowUnsafeAccess", true})})}));
                reflectionMap.put("io.netty.channel.socket.nio.NioSocketChannel", Utility.ofMap((Object[])new Object[]{"name", "io.netty.channel.socket.nio.NioSocketChannel", "allPublicConstructors", true, "methods", Utility.ofArray((Object[])new HashMap[]{Utility.ofMap((Object[])new Object[]{"name", "<init>", "parameterTypes", new String[0]})})}));
                reflectionMap.put("io.netty.buffer.AbstractByteBufAllocator", Utility.ofMap((Object[])new Object[]{"name", "io.netty.buffer.AbstractByteBufAllocator", "allDeclaredMethods", true}));
                reflectionMap.put("io.netty.buffer.AdvancedLeakAwareByteBuf", Utility.ofMap((Object[])new Object[]{"name", "io.netty.buffer.AdvancedLeakAwareByteBuf", "allDeclaredMethods", true}));
                reflectionMap.put("io.netty.util.ReferenceCountUtil", Utility.ofMap((Object[])new Object[]{"name", "io.netty.util.ReferenceCountUtil", "allDeclaredMethods", true}));
            }
            catch (Throwable classLoadList22) {
                // empty catch block
            }
            try (FileOutputStream out3 = new FileOutputStream(reflectionFile);){
                out3.write(JsonConvert.root().convertToBytes(reflectionMap.values()));
                out3.flush();
                out3.close();
            }
            File resourceFile = new File(nativeImageDir, "resource-config.json");
            HashSet<String> resourceSet = new HashSet<String>();
            if ("/META-INF/redkale/redkale.load.classes".indexOf(47) == 0) {
                resourceSet.add("/META-INF/redkale/redkale.load.classes".substring(1));
            } else {
                resourceSet.add("/META-INF/redkale/redkale.load.classes");
            }
            RedkaleClassLoader.forEachServiceLoader((k, v) -> resourceSet.add("META-INF/services/" + k));
            RedkaleClassLoader.forEachResourcePath(v -> resourceSet.add((String)v));
            ArrayList resourceNames = new ArrayList(resourceSet);
            Collections.sort(resourceNames);
            ArrayList<HashMap> resourceList = new ArrayList<HashMap>();
            for (String v3 : resourceNames) {
                resourceList.add(Utility.ofMap((Object[])new Object[]{"pattern", v3}));
            }
            ArrayList bundleList = new ArrayList();
            RedkaleClassLoader.forEachBundleResource((k, v) -> {
                for (String e : v) {
                    bundleList.add(Utility.ofMap((Object[])new Object[]{"name", k + "_" + e}));
                }
            });
            TreeMap resmap = new TreeMap();
            if (!bundleList.isEmpty()) {
                resmap.put("bundles", bundleList);
            }
            resmap.put("resources", resourceList);
            try (FileOutputStream out4 = new FileOutputStream(resourceFile);){
                out4.write(JsonConvert.root().convertToBytes(resmap));
                out4.flush();
                out4.close();
            }
            File propertiesFile = new File(nativeImageDir, "native-image.properties");
            StringBuilder sb = new StringBuilder();
            sb.append(RedkaleClassLoader.class.getName());
            RedkaleClassLoader.forEachBuildClass(v -> sb.append(",").append((String)v));
            RedkaleClassLoader.forEachBuildPackage(v -> sb.append(",").append((String)v));
            Properties props = new Properties();
            LinkedHashSet<Object> args = new LinkedHashSet<Object>();
            if (this.nativeimageArgs != null) {
                args.addAll(this.nativeimageArgs);
            }
            args.add("--enable-http");
            args.add("--enable-https");
            Set<String> sysPropertyNames = Set.of("jdk.", "path.", "java.", "file.", "os.", "line.", "sun.", "user.", "awt.", "graalvm.", "org.graalvm.");
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x, y) -> {
                if (Utility.find((Collection)sysPropertyNames, s -> x.toString().startsWith((String)s)) == null) {
                    args.add("-D" + x + "=" + y);
                }
            }));
            args.add("--initialize-at-build-time=" + sb);
            props.put("Args", String.join((CharSequence)" ", args));
            out = new FileOutputStream(propertiesFile);
            try {
                props.store((OutputStream)out, null);
                ((OutputStream)out).flush();
                ((FileOutputStream)out).close();
            }
            finally {
                ((FileOutputStream)out).close();
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("redkale compiler error", e);
        }
    }

    private static int copyFile(File src, File dest) throws Exception {
        if (!src.isFile() && !src.isDirectory()) {
            return -1;
        }
        if (src.isFile()) {
            dest.getParentFile().mkdirs();
            Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else {
            Object cachePath;
            if (!dest.isDirectory()) {
                dest.mkdirs();
            }
            if (((String)(cachePath = "/META-INF/redkale/conf")).indexOf(47) == 0) {
                cachePath = ((String)cachePath).substring(1);
            }
            if (!((String)cachePath).endsWith("/")) {
                cachePath = (String)cachePath + "/";
            }
            int len = src.getPath().length() + 1;
            for (File f : src.listFiles()) {
                String fname = f.getPath().substring(len);
                RedkaleClassLoader.putResourcePath((String)((String)cachePath + fname.replace('\\', '/')));
                RedkaleCompileMojo.copyFile(f, new File(dest, fname));
            }
        }
        return 0;
    }
}

