/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm.payload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.redline_rpm.ChannelWrapper;
import org.redline_rpm.ReadableChannelWrapper;
import org.redline_rpm.Util;
import org.redline_rpm.payload.CpioHeader;
import org.redline_rpm.payload.Directive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contents {
    private static final Set<String> BUILTIN = new HashSet<String>();
    private static final Set<String> DOC_DIRS = new HashSet<String>();
    private Logger logger = Logger.getLogger(Contents.class.getName());
    private int inode = 1;
    protected final Set<CpioHeader> headers = new TreeSet<CpioHeader>(new HeaderComparator());
    protected final Set<String> files = new HashSet<String>();
    protected final Map<CpioHeader, Object> sources = new HashMap<CpioHeader, Object>();
    protected final Set<String> builtins = new HashSet<String>();

    public Contents() {
        this.builtins.addAll(BUILTIN);
    }

    public synchronized void addLink(String path, String target) {
        this.addLink(path, target, -1);
    }

    public synchronized void addLink(String path, String target, int permissions) {
        this.addLink(path, target, permissions, null, null);
    }

    public synchronized void addLink(String path, String target, int permissions, String uname, String gname) {
        if (this.files.contains(path)) {
            return;
        }
        this.files.add(path);
        this.logger.log(Level.FINE, "Adding link ''{0}''.", path);
        CpioHeader header = new CpioHeader(path);
        header.setType(10);
        header.setFileSize(target.length());
        header.setMtime(System.currentTimeMillis());
        header.setUname(this.getDefaultIfMissing(uname, "root"));
        header.setGname(this.getDefaultIfMissing(gname, "root"));
        if (permissions != -1) {
            header.setPermissions(permissions);
        }
        this.headers.add(header);
        this.sources.put(header, target);
    }

    private String getDefaultIfMissing(String value, String defaultValue) {
        return value == null || value.isEmpty() ? defaultValue : value;
    }

    public synchronized void addDirectory(String path) {
        this.addDirectory(path, -1);
    }

    public synchronized void addDirectory(String path, Directive directive) {
        this.addDirectory(path, -1, directive, null, null);
    }

    public synchronized void addDirectory(String path, int permissions) {
        this.addDirectory(path, permissions, null, null, null);
    }

    public synchronized void addDirectory(String path, int permissions, Directive directive, String uname, String gname) {
        this.addDirectory(path, permissions, directive, uname, gname, true);
    }

    public synchronized void addDirectory(String path, int permissions, Directive directive, String uname, String gname, boolean addParents) {
        if (this.files.contains(path)) {
            return;
        }
        if (addParents) {
            this.addParents(new File(path), permissions, uname, gname);
        }
        this.files.add(path);
        this.logger.log(Level.FINE, "Adding directory ''{0}''.", path);
        CpioHeader header = new CpioHeader(path);
        header.setType(4);
        header.setInode(this.inode++);
        if (null == uname) {
            header.setUname("root");
        } else if (0 == uname.length()) {
            header.setUname("root");
        } else {
            header.setUname(uname);
        }
        if (null == gname) {
            header.setGname("root");
        } else if (0 == gname.length()) {
            header.setGname("root");
        } else {
            header.setGname(gname);
        }
        header.setMtime(System.currentTimeMillis());
        if (-1 == permissions) {
            header.setPermissions(493);
        } else {
            header.setPermissions(permissions);
        }
        this.headers.add(header);
        this.sources.put(header, "");
        if (directive != null) {
            header.setFlags(directive.flag());
        }
    }

    public void addFile(String path, File source) throws FileNotFoundException {
        this.addFile(path, source, -1);
    }

    public void addFile(String path, File source, int permissions) throws FileNotFoundException {
        this.addFile(path, source, permissions, null, null, null);
    }

    public void addFile(String path, File source, int permissions, int dirmode) throws FileNotFoundException {
        this.addFile(path, source, permissions, null, null, null, dirmode);
    }

    public void addFile(String path, File source, int permissions, Directive directive) throws FileNotFoundException {
        this.addFile(path, source, permissions, directive, null, null);
    }

    public void addFile(String path, File source, int permissions, Directive directive, String uname, String gname) throws FileNotFoundException {
        this.addFile(path, source, permissions, directive, uname, gname, -1);
    }

    public synchronized void addFile(String path, File source, int permissions, Directive directive, String uname, String gname, int dirmode) throws FileNotFoundException {
        this.addFile(path, source, permissions, directive, uname, gname, dirmode, true);
    }

    public synchronized void addFile(String path, File source, int permissions, Directive directive, String uname, String gname, int dirmode, boolean addParents) throws FileNotFoundException {
        this.addFile(path, source, permissions, directive, uname, gname, dirmode, addParents, -1);
    }

    public synchronized void addFile(String path, File source, int permissions, Directive directive, String uname, String gname, int dirmode, boolean addParents, int verifyFlags) throws FileNotFoundException {
        if (this.files.contains(path)) {
            return;
        }
        if (addParents) {
            this.addParents(new File(path), dirmode, uname, gname);
        }
        this.files.add(path);
        this.logger.log(Level.FINE, "Adding file ''{0}''.", path);
        CpioHeader header = directive != null && (directive.flag() & 0x40) == 64 ? new CpioHeader(path) : new CpioHeader(path, source);
        header.setType(8);
        header.setInode(this.inode++);
        if (null == uname) {
            header.setUname("root");
        } else if (0 == uname.length()) {
            header.setUname("root");
        } else {
            header.setUname(uname);
        }
        if (null == gname) {
            header.setGname("root");
        } else if (0 == gname.length()) {
            header.setGname("root");
        } else {
            header.setGname(gname);
        }
        if (-1 == permissions) {
            header.setPermissions(420);
        } else {
            header.setPermissions(permissions);
        }
        header.setVerifyFlags(verifyFlags);
        this.headers.add(header);
        this.sources.put(header, source);
        if (directive != null) {
            header.setFlags(directive.flag());
        }
    }

    public synchronized void addURL(String path, URL source, int permissions, Directive directive, String uname, String gname, int dirmode) throws FileNotFoundException {
        if (this.files.contains(path)) {
            return;
        }
        this.addParents(new File(path), dirmode, uname, gname);
        this.files.add(path);
        this.logger.log(Level.FINE, "Adding file ''{0}''.", path);
        CpioHeader header = new CpioHeader(path, source);
        header.setType(8);
        header.setInode(this.inode++);
        if (uname != null) {
            header.setUname(uname);
        }
        if (gname != null) {
            header.setGname(gname);
        }
        if (permissions != -1) {
            header.setPermissions(permissions);
        }
        this.headers.add(header);
        this.sources.put(header, source);
        if (directive != null) {
            header.setFlags(directive.flag());
        }
    }

    protected synchronized void addParents(File file, int permissions, String uname, String gname) {
        ArrayList<String> parents = new ArrayList<String>();
        this.listParents(parents, file);
        for (String parent : parents) {
            this.addDirectory(parent, permissions, null, uname, gname);
        }
    }

    public static synchronized void addBuiltinDirectory(String directory) {
        BUILTIN.add(directory);
    }

    public synchronized void addLocalBuiltinDirectory(String directory) {
        this.builtins.add(directory);
    }

    public int size() {
        return this.headers.size();
    }

    public Iterable<CpioHeader> headers() {
        return this.headers;
    }

    public Object getSource(CpioHeader header) {
        return this.sources.get(header);
    }

    public int getTotalSize() {
        int total = 0;
        try {
            for (Object object : this.sources.values()) {
                if (object instanceof File) {
                    total = (int)((long)total + ((File)object).length());
                    continue;
                }
                if (!(object instanceof URL)) continue;
                total += ((URL)object).openConnection().getContentLength();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return total;
    }

    public String[] getDirNames() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (CpioHeader header : this.headers) {
            String path = new File(header.getName()).getParent();
            if (path == null) continue;
            String parent = Util.normalizePath(path);
            if (!parent.endsWith("/")) {
                parent = parent + "/";
            }
            set.add(parent);
        }
        return set.toArray(new String[set.size()]);
    }

    public int[] getDirIndexes() {
        List<String> dirs = Arrays.asList(this.getDirNames());
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            String path = new File(header.getName()).getParent();
            if (path == null) continue;
            String parent = Util.normalizePath(path);
            if (!parent.endsWith("/")) {
                parent = parent + "/";
            }
            array[x++] = dirs.indexOf(parent);
        }
        return array;
    }

    public String[] getBaseNames() {
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = Util.normalizePath(new File(header.getName()).getName());
        }
        return array;
    }

    public int[] getSizes() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        try {
            for (CpioHeader header : this.headers) {
                Object object = this.sources.get(header);
                if (object instanceof File) {
                    array[x] = (int)((File)object).length();
                } else if (object instanceof URL) {
                    array[x] = ((URL)object).openConnection().getContentLength();
                } else if (header.getType() == 4) {
                    array[x] = 4096;
                } else if (header.getType() == 10) {
                    array[x] = ((String)object).length();
                }
                ++x;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return array;
    }

    public short[] getModes() {
        short[] array = new short[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = (short)header.getMode();
        }
        return array;
    }

    public short[] getRdevs() {
        short[] array = new short[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = (short)((header.getRdevMajor() << 8) + header.getRdevMinor());
        }
        return array;
    }

    public int[] getMtimes() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getMtime();
        }
        return array;
    }

    public String[] getMD5s() throws NoSuchAlgorithmException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            Object object = this.sources.get(header);
            String value = "";
            if (object instanceof File) {
                FileInputStream fileInput = new FileInputStream((File)object);
                ReadableChannelWrapper input = new ReadableChannelWrapper(fileInput.getChannel());
                ChannelWrapper.Key<byte[]> key = input.start("MD5");
                while (input.read(buffer) != -1) {
                    buffer.rewind();
                }
                value = Util.hex(input.finish(key));
                input.close();
                fileInput.close();
            } else if (object instanceof URL) {
                ReadableChannelWrapper input = new ReadableChannelWrapper(Channels.newChannel(((URL)object).openConnection().getInputStream()));
                ChannelWrapper.Key<byte[]> key = input.start("MD5");
                while (input.read(buffer) != -1) {
                    buffer.rewind();
                }
                value = Util.hex(input.finish(key));
                input.close();
            }
            array[x++] = value;
        }
        return array;
    }

    public String[] getLinkTos() {
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            Object object = this.sources.get(header);
            String value = "";
            if (object instanceof String) {
                value = String.valueOf(object);
            }
            array[x++] = value;
        }
        return array;
    }

    public int[] getFlags() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getFlags();
        }
        return array;
    }

    public String[] getUsers() {
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getUname() == null ? "root" : header.getUname();
        }
        return array;
    }

    public String[] getGroups() {
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getGname() == null ? "root" : header.getGname();
        }
        return array;
    }

    public int[] getColors() {
        return new int[this.headers.size()];
    }

    public int[] getVerifyFlags() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getVerifyFlags();
        }
        return array;
    }

    public int[] getClasses() {
        int[] array = new int[this.headers.size()];
        Arrays.fill(array, 1);
        return array;
    }

    public int[] getDevices() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = (header.getDevMajor() << 8) + header.getDevMinor();
        }
        return array;
    }

    public int[] getInodes() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getInode();
        }
        return array;
    }

    public String[] getLangs() {
        Object[] array = new String[this.headers.size()];
        Arrays.fill(array, "");
        return array;
    }

    public int[] getDependsX() {
        return new int[this.headers.size()];
    }

    public int[] getDependsN() {
        return new int[this.headers.size()];
    }

    public String[] getContexts() {
        Object[] array = new String[this.headers.size()];
        Arrays.fill(array, "<<none>>");
        return array;
    }

    protected void listParents(List<String> parents, File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return;
        }
        String path = Util.normalizePath(parent.getPath());
        if (this.builtins.contains(path)) {
            return;
        }
        parents.add(path);
        this.listParents(parents, parent);
    }

    static {
        BUILTIN.add("/");
        BUILTIN.add("/bin");
        BUILTIN.add("/dev");
        BUILTIN.add("/etc");
        BUILTIN.add("/etc/bash_completion.d");
        BUILTIN.add("/etc/cron.d");
        BUILTIN.add("/etc/cron.daily");
        BUILTIN.add("/etc/cron.hourly");
        BUILTIN.add("/etc/cron.monthly");
        BUILTIN.add("/etc/cron.weekly");
        BUILTIN.add("/etc/default");
        BUILTIN.add("/etc/init.d");
        BUILTIN.add("/etc/logrotate.d");
        BUILTIN.add("/lib");
        BUILTIN.add("/usr");
        BUILTIN.add("/usr/bin");
        BUILTIN.add("/usr/lib");
        BUILTIN.add("/usr/lib64");
        BUILTIN.add("/usr/local");
        BUILTIN.add("/usr/local/bin");
        BUILTIN.add("/usr/local/lib");
        BUILTIN.add("/usr/sbin");
        BUILTIN.add("/usr/share");
        BUILTIN.add("/usr/share/applications");
        BUILTIN.add("/root");
        BUILTIN.add("/sbin");
        BUILTIN.add("/opt");
        BUILTIN.add("/run");
        BUILTIN.add("/srv");
        BUILTIN.add("/tmp");
        BUILTIN.add("/var");
        BUILTIN.add("/var/cache");
        BUILTIN.add("/var/lib");
        BUILTIN.add("/var/log");
        BUILTIN.add("/var/run");
        BUILTIN.add("/var/spool");
        DOC_DIRS.add("/usr/doc");
        DOC_DIRS.add("/usr/man");
        DOC_DIRS.add("/usr/X11R6/man");
        DOC_DIRS.add("/usr/share/doc");
        DOC_DIRS.add("/usr/share/man");
        DOC_DIRS.add("/usr/share/info");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeaderComparator
    implements Comparator<CpioHeader> {
        private HeaderComparator() {
        }

        @Override
        public int compare(CpioHeader one, CpioHeader two) {
            return one.getName().compareTo(two.getName());
        }

        public boolean equals(CpioHeader one, CpioHeader two) {
            return one.getName().equals(two.getName());
        }
    }
}

