
/**
 * Copyright 2011-2012 Clint Combs
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.regrest.report

import org.regrest.{RestRequest,RestResponse}
import java.io.{BufferedWriter,OutputStreamWriter,PrintWriter}

trait PlainTextReporter extends Reporter {

	lazy val writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));

	def init = {
	}

	def start = {
	}

	def report(req:RestRequest, res:RestResponse) = {
		writer.println("Request " + req.method + " " + req.url)
		writer.println("\tHeaders:")
		req.headers.foreach { h => writer.println("\t\t" + h._1 + "=" + h._2) }
		writer.println
		writer.println("Response")
		writer.println("\tProtocol Version: " + res.protocolVersion)
		writer.println("\tStatus Code: " + res.statusCode)
		writer.println("\tReason Phrase: " + res.reasonPhrase)
		writer.println("\tHeaders:")
		res.headerMap.foreach { h => writer.println("\t\t" + h._1 + "=" + h._2) }
		writer.println("-------------------")
	}

	def finish = {
		writer.close
	}
}
