
/**
 * Copyright 2011-2012 Clint Combs
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.regrest.report

import java.io.{File,OutputStream}
import org.regrest.{RestRequest,RestResponse}
import com.weiglewilczek.slf4s.Logging

trait Reporter extends Logging {
	var osOption:Option[OutputStream] = None;
	var workingDirectoryOption:Option[File] = None;

	def os:OutputStream = {
		osOption match {
			case Some(i) => i
			case None => require(osOption != None, "outputStream not set"); null
		}
	}

	def apply(outputStream:OutputStream) = {
		osOption = Option(outputStream)
	}

	def workingDirectory(f:File) = {
		require(!f.isFile, "working directory is a file, not a directory: " + f)
		workingDirectoryOption = Option(f)
	}

	def workingDirectory:File = {
		workingDirectoryOption match {
			case Some(d) => d
			case None => require(workingDirectoryOption != None, "workingDirectory not set"); null
		}
	}

	def init
	def start
	def report(req:RestRequest, res:RestResponse)
	def finish
}
