
/**
 * Copyright 2011-2012 Clint Combs
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.regrest.restclient

import java.io.{File,FileOutputStream}
import org.regrest.RegrestRunner
import org.regrest.report.Reporter
import org.regrest.http.RequestProcessor
import com.weiglewilczek.slf4s.Logging

class RestClientRunner(
		inputFileOrDirectory:File, reportFile:File,
		runnerWorkingDirectory:File, overrideHost:Option[String]) extends RegrestRunner with Logging {
	this:Reporter =>

	def run = {
		this(new FileOutputStream(reportFile))
		workingDirectory(runnerWorkingDirectory)
		overrideHost match {
			case Some(host) => logger.info("overriding host on all requests with: " + host)
			case None =>
		}
		sendRequests
	}

	def sendRequests = {
		val restRequestOptions =
			new RequestClientRequestSource(inputFileOrDirectory).loadRestRequests()

		val processor = new RequestProcessor(overrideHost)
		init
		start
		restRequestOptions.map { restRequestOption =>
			restRequestOption._2 match {
				case None =>
					logger.info("no request found in: " + restRequestOption._1)
				case Some(req) =>
					logger.info("processing request found in: " + restRequestOption._1.getName)
					val processResult = processor.processRequest(restRequestOption._2.get)
					report(processResult._1, processResult._2)
			}
		}
		finish
	}
}
