
/**
 * Copyright 2011-2012 Clint Combs
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.regrest.restclient

import java.io.File
import org.regrest.{RestRequest,Body}
import scala.xml.{Elem,Node}

class RestClientXmlParser {
	def parse(e:Elem):Option[RestRequest] = {
		val restClientNodes = e\\"rest-client"

		if (restClientNodes.length == 1) {
			val requestNode = (restClientNodes(0)\\"request")(0)
			Option(new RestClientRequestParser(requestNode).parse)
		} else None
	}
}

class RestClientRequestParser(request:Node) {
	def parse = RestRequest(parseHttpVersion, parseUrl, parseMethod, parseHeaders, body)

	def parseHttpVersion = request\"http-version" text

	def parseUrl = request\"URL" text

	def parseMethod = request\"method" text

	lazy val headers = request\"headers"\"header"

	def parseHeaders:Map[String, String] =
		(Map[String, String]() /: headers) {
			case (m, n) => m + ((n\"@key" text) -> (n\"@value" text))
		}

	def body:Option[Body] =
		if ((request\"body").length > 0)
			Some(Body(contentType=request\"body"\"@content-type" text,
					charset=request\"body"\"@charset" text,
					text=request\"body" text))
		else None
}
